/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.driver.modiscoworkflow.execution;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.workflow.Constants;
import org.eclipse.gmt.modisco.workflow.DriverExecutionInterface;
import org.eclipse.gmt.modisco.workflow.MoDiscoWorkflowLaunchConstants;
import org.eclipse.gmt.modisco.workflow.actions.MoDiscoWorkflowDelegate;
import org.eclipse.gmt.modisco.workflow.driver.modiscoworkflow.Activator;
import org.eclipse.gmt.modisco.workflow.driver.modiscoworkflow.MoDiscoWorkflowLauncher;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Work;

public class TransformationExecute implements DriverExecutionInterface, MoDiscoWorkflowLauncher {

	public void launch(ILaunchConfigurationWorkingCopy configuration, ILaunch launch) {
		try {
			MoDiscoWorkflowDelegate delegate = new MoDiscoWorkflowDelegate();
			delegate.launch(configuration,ILaunchManager.RUN_MODE, launch,new NullProgressMonitor());
		} catch (CoreException e) {
			MoDiscoLogger.logError(e, Activator.getDefault());
		}
	}

	public ILaunchConfiguration createConfiguration() {
		ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(org.eclipse.gmt.modisco.workflow.driver.modiscoworkflow.Constant.typeLaunchConfiguration);
		ILaunchConfiguration launchConfiguration = null;
		try {
			launchConfiguration = type.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(null));
		} catch (CoreException e) {
			MoDiscoLogger.logWarning(e, Activator.getDefault());
		}
		return launchConfiguration;
	}

	public void launch(ILaunchConfiguration configuration) {
		try {
			configuration.launch(ILaunchManager.RUN_MODE,new NullProgressMonitor());
		} catch (CoreException e) {
			MoDiscoLogger.logError(e, Activator.getDefault());
		}
	}

	public ILaunchConfiguration createConfiguration(File file) {
		String configurationName = file.getName().substring(0, file.getName().lastIndexOf(".")); //$NON-NLS-1$
		//Create a new instance of configuration from file
		ILaunchConfiguration configuration = createConfigurationMoDiscoWork(configurationName);
		ILaunchConfigurationWorkingCopy copy = null;
		boolean exist = false;
		boolean changeName = false;
		try {
			copy = configuration.getWorkingCopy();
			ParseLaunchConfigurationFile parse = new ParseLaunchConfigurationFile(file);
			parse.save(copy);
			/*
			 * Do not create a new configuration (physically) if there is the same
			 */
			for(ILaunchConfiguration config :DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations()){
				//It are the same name but didn't have the same contents
				if(copy.getName().equals(config.getName())==true){
					if(config.getType().equals(configuration.getType())){
						if(equalsConfig(config,copy)){
							exist = true;
							configuration = config;
							break;
						}else{
							changeName = true;
							break;
						}
					}else{
						changeName = true;
						break;
					}
				}
			}
			if(!exist){
				if(changeName){
					configuration = createConfigurationMoDiscoWork(DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(configurationName));
					configuration = configuration.getWorkingCopy().getParent().doSave();
					copy = configuration.getWorkingCopy();
					parse.save(copy);
					changeName(copy);
				}else{
					configuration = configuration.getWorkingCopy().getParent().doSave();
					copy = configuration.getWorkingCopy();
					parse.save(copy);
				}
				configuration = copy.doSave();
			}
		} catch (CoreException e) {
			MoDiscoLogger.logWarning(e, Activator.getDefault());
		}
		return configuration;
	}
	
	/**
	 * Allows to change name to didn't have a conflict
	 * @param copy LaunchConfigurationWorkingCopy create previously 
	 */
	private void changeName(ILaunchConfigurationWorkingCopy copy) {
		try {
			String idWorkflow = copy.getAttribute(MoDiscoWorkflowLaunchConstants.idWorkflow, (String)null);
			if(idWorkflow.equals(MoDiscoWorkflowLaunchConstants.idMinimaliste)==false){
				String ressourcepath = copy.getAttribute(MoDiscoWorkflowLaunchConstants.resourcePath,(String)null);
				IPath path = new Path(ressourcepath);
				path = path.removeLastSegments(1).append(copy.getName()).addFileExtension(Constants.workflowExtension);
				copy.setAttribute(MoDiscoWorkflowLaunchConstants.resourcePath, path.toString());
				renameFile(ressourcepath, path.toString());
			}
		} catch (CoreException e) {
			MoDiscoLogger.logWarning(e, Activator.getDefault());
		}
		
	}

	/**
	 * Allows to compare two launchConfiguration
	 * @param config the LaunchCOnfiguration tested
	 * @param copy LaunchConfigurationWorkingCopy create previously 
	 * @return True if config and copy are the same
	 */
	@SuppressWarnings("unchecked")
	private boolean equalsConfig(ILaunchConfiguration config,
			ILaunchConfigurationWorkingCopy copy) {
		boolean equals = false;
		try {
			String idConfig = config.getAttribute(MoDiscoWorkflowLaunchConstants.idWorkflow,MoDiscoWorkflowLaunchConstants.idMinimaliste);
			String idCopy = copy.getAttribute(MoDiscoWorkflowLaunchConstants.idWorkflow,MoDiscoWorkflowLaunchConstants.idMinimaliste);
			if(idConfig.equals(idCopy)==true){
				if(idConfig.equals(MoDiscoWorkflowLaunchConstants.idMinimaliste)){
					List<String> listMConfig = config.getAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist,(List<String>)null);
					List<String> listMCopy = copy.getAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist,(List<String>)null);
					if(listMConfig.equals(listMCopy)){
						equals = true;
					}
				}else{
					if(config.getAttribute(MoDiscoWorkflowLaunchConstants.moDiscoWorkNumber,0)==copy.getAttribute(MoDiscoWorkflowLaunchConstants.moDiscoWorkNumber,0)){
						if(config.getAttribute(MoDiscoWorkflowLaunchConstants.resourcePath,(String)null).equals(copy.getAttribute(MoDiscoWorkflowLaunchConstants.resourcePath,(String)null))){
							List<String> listSConfig = config.getAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListSerialize,(List<String>)null);
							List<String> listSCopy = copy.getAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListSerialize,(List<String>)null);
							if(listSConfig.equals(listSCopy)){
								equals = true;
							}
						}
					}
				}
			}
		} catch (CoreException e) {
			MoDiscoLogger.logWarning(e, Activator.getDefault());
		}
		return equals;
	}

	/**
	 * Allows to create a launchConfiguration of MoDiscoWorkflow
	 * @param name Name of configuration
	 * @return A new LaunchConfiguration of MoDiscoWorkflow
	 */
	private ILaunchConfiguration createConfigurationMoDiscoWork(String name){
		ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(MoDiscoWorkflowLaunchConstants.launchTypeMoDiscoWorkflow);
		ILaunchConfiguration launchConfiguration = null;
		try {
			launchConfiguration = type.newInstance(null,name);
		} catch (CoreException e) {
			MoDiscoLogger.logWarning(e, Activator.getDefault());
		}
		return launchConfiguration;
	}
	
	/**
	 * Allows to renameFile a file
	 * @param pathFile1 Source file
	 * @param pathFile2 Destination file
	 */
	private void renameFile(String pathFile1, String pathFile2){
		FileChannel in = null; 
		FileChannel out = null; 
		try {
			in = new FileInputStream(pathFile1).getChannel();
			out = new FileOutputStream(pathFile2).getChannel();
			in.transferTo(0, in.size(), out);
		} catch (Exception e) {
			MoDiscoLogger.logWarning(e, Activator.getDefault());
		} finally { 
			if(in != null) {
				try {
					in.close();
				} catch (IOException e) {
					MoDiscoLogger.logWarning(e, Activator.getDefault());
				}
			}
			if(out != null) {
				try {
					out.close();
				} catch (IOException e) {
					MoDiscoLogger.logWarning(e, Activator.getDefault());
				}
			}
		}
		File f = new File(pathFile1);
		f.delete();
	}

	public void launch(Work modiscoWork) {}
}
