/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */

package org.eclipse.gmt.modisco.infra.discoverymanager.ui.launch.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/**
 * @author Gabriel Barbier
 * 
 */
public class IFileCellEditor extends DialogCellEditor {

	/**
	 * Opens a dialog box under the given parent control and returns the
	 * dialog's value when it closes, or <code>null</code> if the dialog was
	 * canceled or no selection was made in the dialog.
	 * <p>
	 * This framework method must be implemented by concrete subclasses. It is
	 * called when the user has pressed the button and the dialog box must pop
	 * up.
	 * </p>
	 * 
	 * @param cellEditorWindow
	 *            the parent control cell editor's window so that a subclass can
	 *            adjust the dialog box accordingly
	 * @return the selected value, or <code>null</code> if the dialog was
	 *         canceled or no selection was made in the dialog
	 */
	@Override
	protected Object openDialogBox(Control cellEditorWindow) {
		Object result = null;
		ILabelProvider lp = new WorkbenchLabelProvider();
		ITreeContentProvider cp = new WorkbenchContentProvider();
		ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(cellEditorWindow
				.getShell(), lp, cp);
		dialog.setAllowMultiple(false);
		dialog.setTitle("IFile selection dialog");
		dialog.setMessage("Please, select a file in following tree.");
		dialog.setInput(ResourcesPlugin.getWorkspace().getRoot());
		dialog.setValidator(new ISelectionStatusValidator() {
			
			public IStatus validate(Object[] selection) {
				IStatus result = Status.CANCEL_STATUS;
				if (selection != null) {
					result = Status.OK_STATUS;
					for(Object object : selection) {
						if ((object instanceof IFile) == false) {
							result = Status.CANCEL_STATUS;
						}
					}
				}
				return result;
			}
		});
//		dialog.addFilter(new ViewerFilter() {
//			
//			@Override
//			public boolean select(Viewer viewer, Object parentElement, Object element) {
//				if (element instanceof IFile)
//					return ((IFile)element).getFileExtension().equals("asm"); //$NON-NLS-1$
//				return true;
//
//			}
//		
//		});
		if (dialog.open() == Window.OK) {
			result = dialog.getFirstResult();
		}
		return result;
	}

}
