package org.eclipse.gmt.modisco.infra.query.core.exception;

public class MissingBundleException extends ModelQueryException {

	private static final long serialVersionUID = -8404816241040395882L;
	private final String bundleName;

	public String getBundleName() {
		return this.bundleName;
	}

	public MissingBundleException(final String bundleName) {
		super("The bundle " + bundleName //$NON-NLS-1$
				+ " is missing. The bundle has to be installed, it will not be hot loaded."); //$NON-NLS-1$
		this.bundleName = bundleName;
	}

}
