/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire DUPE (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.infra.query.core.internal.validation;

import java.util.Arrays;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.query.JavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.internal.Activator;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.osgi.framework.Bundle;

public class ImplementationClassInterface extends AbstractModelConstraint {

	@Override
	public IStatus validate(final IValidationContext ctx) {
		JavaModelQuery modelQuery = (JavaModelQuery) ctx.getTarget();
		EMFEventType eType = ctx.getEventType();
		if (eType == EMFEventType.NULL) {
			if (modelQuery.getImplementationClassName() == null) {
				return ctx.createSuccessStatus();
			}
			URI uri = modelQuery.eResource().getURI();
			String containerName = uri.segment(1);
			if (uri.segment(0).equals("plugin")) { //$NON-NLS-1$
				Bundle bundle = Platform.getBundle(containerName);
				try {
					Class<? extends Object> c = bundle.loadClass(modelQuery
							.getImplementationClassName());
					if (!IJavaModelQuery.class.isAssignableFrom(c)) {
						return ctx.createFailureStatus(modelQuery.getImplementationClassName());
					}
				} catch (ClassNotFoundException e) {
					return ctx.createSuccessStatus();
				}
			} else if (uri.segment(0).equals("resource")) { //$NON-NLS-1$
				IWorkspace ws = ResourcesPlugin.getWorkspace();
				IWorkspaceRoot wsr = ws.getRoot();
				IProject iproject = wsr.getProject(containerName);
				IJavaProject javaProject = JavaCore.create(iproject);
				try {
					IType type = javaProject.findType(modelQuery.getImplementationClassName());
					if (type == null) {
						return ctx.createSuccessStatus();
					}
					List<String> names = Arrays.asList(type.getSuperInterfaceNames());
					for (String name : names) {
						if (name.matches(".*" + IJavaModelQuery.class.getSimpleName() + "<.*>")) {
							return ctx.createSuccessStatus();
						}
					}
					return ctx.createFailureStatus(modelQuery.getImplementationClassName());
				} catch (JavaModelException e) {
					MoDiscoLogger.logError(e, Activator.getDefault());
				}
			}
		}
		return ctx.createSuccessStatus();
	}

}
