/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Grgoire Dup (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.browser.custom.examples.uml;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.java.ParameterValueList;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;

/**
 * @author Gregoire Dupe (Mia-Software)
 */
public class AllClassifiers_Classifier implements IJavaModelQuery<Classifier, List<Classifier>> {

	public List<Classifier> evaluate(final Classifier context,
			final ParameterValueList parameterValues) throws ModelQueryExecutionException {
		List<Classifier> allClassifiers = new ArrayList<Classifier>();
		List<Classifier> classifiers = new ArrayList<Classifier>();
		for (Element element : context.getOwnedElements())
		{
			if (element instanceof Classifier) {
				Classifier classifier = (Classifier) element;
				classifiers.add(classifier);
			}
		}
		allClassifiers.addAll(classifiers);
		for (Classifier ownedClassifier : classifiers){
			allClassifiers.addAll(evaluate(ownedClassifier, null));
		}
		return allClassifiers;
	}

}
