/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.io.library;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.java.Archive;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.Manifest;
import org.eclipse.gmt.modisco.java.ManifestAttribute;
import org.eclipse.gmt.modisco.java.ManifestEntry;
import org.eclipse.gmt.modisco.java.emf.JavaFactory;
import org.eclipse.jdt.core.IPackageFragmentRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ManifestReader {
    private ManifestReader() {
    }

    public static void completeArchiveWithManifest(IPackageFragmentRoot physicalArchive, Archive modelArchive, JavaFactory factory) {
        try {
            File jarFile = null;
            jarFile = physicalArchive.isExternal() ? new File(physicalArchive.getPath().toOSString()) : new File(physicalArchive.getResource().getRawLocation().toOSString());
            JarFile jar = new JarFile(jarFile);
            java.util.jar.Manifest manifest = jar.getManifest();
            if (manifest != null) {
                Manifest modelManifest = factory.createManifest();
                modelArchive.setManifest(modelManifest);
                Attributes mainAttrs = manifest.getMainAttributes();
                modelManifest.getMainAttributes().addAll(ManifestReader.readAttributes(mainAttrs, factory));
                for (Map.Entry<String, Attributes> entry : manifest.getEntries().entrySet()) {
                    ManifestEntry modelEntry = factory.createManifestEntry();
                    modelEntry.setName(entry.getKey());
                    modelEntry.getAttributes().addAll(ManifestReader.readAttributes(entry.getValue(), factory));
                    modelManifest.getEntryAttributes().add((Object)modelEntry);
                }
            }
        }
        catch (IOException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
        }
    }

    public static List<ManifestAttribute> readAttributes(Attributes attributes, JavaFactory factory) {
        ArrayList<ManifestAttribute> modelAttributes = new ArrayList<ManifestAttribute>();
        for (Map.Entry<Object, Object> attribute : attributes.entrySet()) {
            ManifestAttribute modelAttribute = factory.createManifestAttribute();
            modelAttribute.setKey(attribute.getKey().toString());
            modelAttribute.setValue(attribute.getValue().toString());
            modelAttributes.add(modelAttribute);
        }
        return modelAttributes;
    }
}

