/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.discoverer.benchmark.cdo.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.java.cdo.impl.JavaPackageImpl;
import org.eclipse.gmt.modisco.java.cdo.meta.JavaFactory;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.Activator;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.cdo.client.Messages;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.emfstat.DiscoverJavaModelFromJavaProjectEMFStat;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.emfstat.JavaReaderEMFStat;
import org.eclipse.gmt.modisco.java.discoverer.cdo.JavaDiscovererCDO;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.net4j.tcp.ITCPConnector;

public class BenchmarkJavaDiscovererCDO
extends DiscoverJavaModelFromJavaProjectEMFStat {
    private final String cacheType = "LRU_CACHE";
    private Object serverDescription = Messages.JavaDiscovererCDO_0;
    private int port = 2036;
    private static Map<CDOView, ITCPConnector> connectors = new HashMap<CDOView, ITCPConnector>();

    protected void terminate(Resource r) {
        JavaDiscovererCDO.close((Resource)r, (boolean)true);
    }

    public Resource getResource(String resourceName, IJavaProject javaProject) {
        String resourceName2 = String.valueOf(resourceName) + System.currentTimeMillis();
        Status status = new Status(1, "org.eclipse.gmt.modisco.java.discoverer.benchmark", String.valueOf(Messages.JavaDiscovererCDO_10) + resourceName2);
        Activator.getDefault().getLog().log((IStatus)status);
        EPackage ePackage = this.getEFactory().getEPackage();
        if (ePackage == null) {
            throw new RuntimeException(String.valueOf(Messages.JavaDiscovererCDO_11) + this.getEFactory());
        }
        CDOResource result = JavaDiscovererCDO.getOrCreateCDOResource((String)resourceName2, (EPackage)ePackage, (String)"LRU_CACHE", (int)this.port);
        result.getContents().add((Object)this.getEFactory().createModel());
        this.dbInit(result);
        return result;
    }

    protected Properties getProperties() {
        Properties properties = super.getProperties();
        properties.put("STORAGE_KIND", "CDO");
        properties.put("CDO_VERSION", Platform.getBundle((String)"org.eclipse.emf.cdo").getVersion().toString());
        if ("LRU_CACHE".equals("LRU_CACHE")) {
            properties.put("CDO_CACHE_TYPE", "LRU_CACHE");
            properties.put("CURRENT_LRU_CAPACITY", new Integer(1000).toString());
            properties.put("REVISED_LRU_CAPACITY", new Integer(1000).toString());
        } else if ("DEFAULT_CACHE".equals("LRU_CACHE")) {
            properties.put("CDO_CACHE_TYPE", "DEFAULT_CACHE");
        } else if ("MEM_CACHE".equals("LRU_CACHE")) {
            properties.put("CDO_CACHE_TYPE", "MEM_CACHE");
        } else {
            properties.put("CDO_CACHE_TYPE", "Wrong revision cache type");
            Status status = new Status(4, "org.eclipse.gmt.modisco.java.discoverer.benchmark", "Wrong revision cache type", (Throwable)new Exception());
            Activator.getDefault().getLog().log((IStatus)status);
        }
        properties.put("CDO_SERVER_DESCRIPTION", this.serverDescription);
        properties.put("ALGO_VARIANTE", Messages.JavaDiscovererCDO_18);
        return properties;
    }

    public org.eclipse.gmt.modisco.java.emf.JavaFactory getEFactory() {
        JavaPackageImpl.init();
        return JavaFactory.eINSTANCE;
    }

    private void dbInit(CDOResource resource) {
        CDOView cdoView;
        if (this.getStatistics() != null) {
            this.getStatistics().beginInit();
        }
        if ((cdoView = resource.cdoView()) instanceof CDOTransaction) {
            CDOTransaction cdoTransaction = (CDOTransaction)cdoView;
            cdoTransaction.commit();
        }
        if (this.getStatistics() != null) {
            this.getStatistics().endInit();
        }
    }

    protected JavaReaderEMFStat getJavaReader(boolean isIncremental) {
        JavaReaderEMFStat javaReader = new JavaReaderEMFStat(this.getEFactory(), true){

            protected void reset() {
                CDOObject cdoObject;
                CDOView cdoView;
                if (this.getStatistics() != null) {
                    this.getStatistics().tabValueReport("Begin reset");
                }
                this.getGlobalBindings().resolveBindings(this.getResultModel());
                if (this.getStatistics() != null) {
                    this.getStatistics().tabValueReport("globalBindings resolved");
                }
                if (this.getStatistics() != null) {
                    this.getStatistics().beginSave();
                }
                if (this.getResultModel() instanceof CDOObject && (cdoView = (cdoObject = (CDOObject)this.getResultModel()).cdoView()) instanceof CDOTransaction) {
                    CDOTransaction cdoTransaction = (CDOTransaction)cdoView;
                    cdoTransaction.commit();
                }
                this.setGlobalBindings(this.getBindingManager());
                if (this.getStatistics() != null) {
                    this.getStatistics().endSave();
                }
                if (this.getStatistics() != null) {
                    this.getStatistics().tabValueReport("End reset");
                }
            }
        };
        javaReader.setStatistics(this.getStatistics());
        return javaReader;
    }

    public void saveResource(URI target, IPath path, Resource resource, IProgressMonitor monitor) throws IOException {
        monitor.subTask(Messages.JavaDiscovererCDO_22);
        resource.save(new HashMap());
    }

    public void setServerDescription(String serverDescription) {
        this.serverDescription = serverDescription;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }
}

