/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.query.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.ImageUtils;
import org.eclipse.gmt.modisco.infra.common.ui.internal.dialogs.MetaclassSelectionDialog;
import org.eclipse.gmt.modisco.infra.query.ModelQuerySet;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.gmt.modisco.infra.query.ui.Messages;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateQueryWizardPage
extends WizardPage {
    private final ModelQuerySet initialModelQuerySet;
    private final EClass initialScope;
    private ModelQuerySet querySet;
    private List<EClass> scope;
    private EClassifier returnType;
    private Text scopeText;
    private Text returnTypeText;
    private FilteredList querySetFilteredList;
    private Combo comboType;
    private Text queryNameText;
    private Text queryDescriptionText;
    private Button cbMultivalued;

    protected CreateQueryWizardPage(ModelQuerySet initialModelQuerySet, EClass initialScope) {
        super(CreateQueryWizardPage.class.getSimpleName());
        this.initialModelQuerySet = initialModelQuerySet;
        this.initialScope = initialScope;
        this.setTitle(Messages.CreateQueryWizardPage_createNewModelQuery);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout mainLayout = new GridLayout(1, false);
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        composite.setLayout((Layout)mainLayout);
        this.createQuerySetFilteredList(composite);
        Composite fieldsComposite = new Composite(composite, 0);
        fieldsComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        fieldsComposite.setLayout((Layout)new GridLayout(3, false));
        this.createTypeField(fieldsComposite);
        this.createNameField(fieldsComposite);
        this.createDescriptionField(fieldsComposite);
        this.createScopeField(fieldsComposite);
        this.createReturnTypeField(fieldsComposite);
        if (this.initialScope != null) {
            this.setScope(Collections.singletonList(this.initialScope));
        }
        this.setControl((Control)composite);
    }

    private void createTypeField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.CreateQueryWizardPage_queryType);
        this.comboType = new Combo(parent, 8);
        this.comboType.add("Java");
        this.comboType.select(0);
        GridData comboData = new GridData(4, 0, true, false);
        comboData.horizontalSpan = 2;
        this.comboType.setLayoutData((Object)comboData);
    }

    private void createNameField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.CreateQueryWizardPage_queryName);
        this.queryNameText = new Text(parent, 2048);
        GridData textData = new GridData(4, 0, true, false);
        textData.horizontalSpan = 2;
        this.queryNameText.setLayoutData((Object)textData);
        this.queryNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateQueryWizardPage.this.updateButtons();
            }
        });
    }

    protected void updateButtons() {
        IWizardContainer container = this.getContainer();
        if (container != null && container.getCurrentPage() != null) {
            container.updateButtons();
        }
    }

    private void createDescriptionField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.CreateQueryWizardPage_description);
        this.queryDescriptionText = new Text(parent, 2048);
        GridData textData = new GridData(4, 0, true, false);
        textData.horizontalSpan = 2;
        this.queryDescriptionText.setLayoutData((Object)textData);
    }

    private void createScopeField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.CreateQueryWizardPage_scope);
        this.scopeText = new Text(parent, 2056);
        this.scopeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button browseButton = new Button(parent, 8);
        browseButton.setText(Messages.CreateQueryWizardPage_browseBtn);
        browseButton.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateQueryWizardPage.this.browseScope();
            }
        });
    }

    private void browseScope() {
        MetaclassSelectionDialog metaclassSelectionDialog = new MetaclassSelectionDialog(this.getShell(), true, true);
        if (metaclassSelectionDialog.open() == 0) {
            this.setScope(metaclassSelectionDialog.getSelectedMetaclasses());
        }
    }

    private void setScope(List<EClass> eClasses) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < eClasses.size()) {
            EClass eClass = eClasses.get(i);
            builder.append(String.valueOf(eClass.getEPackage().getName()) + "::" + eClass.getName());
            if (i != eClasses.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        this.scopeText.setText(builder.toString());
        this.scope = eClasses;
        this.updateButtons();
    }

    private void createReturnTypeField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.CreateQueryWizardPage_returnType);
        this.returnTypeText = new Text(parent, 2056);
        this.returnTypeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button browseButton = new Button(parent, 8);
        browseButton.setText(Messages.CreateQueryWizardPage_browseBtn);
        browseButton.setLayoutData((Object)new GridData(0, 0x1000000, false, false));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateQueryWizardPage.this.browseReturnType();
            }
        });
        this.spacer(parent);
        this.cbMultivalued = new Button(parent, 32);
        this.cbMultivalued.setText(Messages.CreateQueryWizardPage_multiValuedReturnType);
        GridData gridData = new GridData(0, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        this.cbMultivalued.setLayoutData((Object)gridData);
    }

    private void browseReturnType() {
        List selectedMetaclasses;
        MetaclassSelectionDialog metaclassSelectionDialog = new MetaclassSelectionDialog(this.getShell(), false, false);
        if (metaclassSelectionDialog.open() == 0 && (selectedMetaclasses = metaclassSelectionDialog.getSelectedClassifiers()).size() > 0) {
            this.setReturnType((EClassifier)selectedMetaclasses.get(0));
        }
    }

    private void setReturnType(EClassifier eClassifier) {
        this.returnTypeText.setText(String.valueOf(eClassifier.getEPackage().getName()) + "::" + eClassifier.getName());
        this.returnType = eClassifier;
        this.updateButtons();
    }

    private void spacer(Composite parent) {
        new Label(parent, 0);
    }

    private void createQuerySetFilteredList(Composite parent) {
        Group querySetGroup = new Group(parent, 0);
        querySetGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        querySetGroup.setLayout((Layout)new GridLayout());
        querySetGroup.setText(Messages.CreateQueryWizardPage_parentQuerySet);
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ModelQuerySet) {
                    ModelQuerySet modelQuerySet = (ModelQuerySet)element;
                    return modelQuerySet.getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                return ImageUtils.getImage((Object)element);
            }
        };
        this.querySetFilteredList = new FilteredList((Composite)querySetGroup, 2048, (ILabelProvider)labelProvider, false, false, true);
        this.querySetFilteredList.setLayoutData((Object)new GridData(4, 4, true, true));
        Collection allModelQuerySets = ModelQuerySetCatalog.getSingleton().getAllModelQuerySets();
        ArrayList<ModelQuerySet> editableQuerySets = new ArrayList<ModelQuerySet>();
        for (ModelQuerySet modelQuerySet : allModelQuerySets) {
            URI uri = ModelQuerySetCatalog.getSingleton().getURI(modelQuerySet.getName());
            if (!uri.isPlatformResource()) continue;
            editableQuerySets.add(modelQuerySet);
        }
        Object[] elements = editableQuerySets.toArray(new ModelQuerySet[editableQuerySets.size()]);
        this.querySetFilteredList.setElements(elements);
        this.querySetFilteredList.setSelection(new Object[]{this.initialModelQuerySet});
        this.querySetFilteredList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateQueryWizardPage.this.querySetChanged();
            }
        });
    }

    private void querySetChanged() {
        Object[] selection = this.querySetFilteredList.getSelection();
        this.querySet = selection.length == 1 ? (ModelQuerySet)selection[0] : null;
        this.updateButtons();
    }

    public ModelQuerySet getQuerySet() {
        return this.querySet;
    }

    public List<EClass> getScope() {
        if (this.scope != null) {
            return Collections.unmodifiableList(this.scope);
        }
        return Collections.emptyList();
    }

    public EClassifier getReturnType() {
        return this.returnType;
    }

    public String getQueryName() {
        return this.queryNameText.getText().trim();
    }

    public String getQueryDescription() {
        return this.queryDescriptionText.getText();
    }

    public boolean isReturnTypeMultiValued() {
        return this.cbMultivalued.getSelection();
    }

    public boolean isPageComplete() {
        return this.querySet != null && this.scope != null && this.returnType != null && this.queryNameText.getText().trim().length() > 0;
    }
}

