/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.actions.IBrowserActionBarContributor;
import org.eclipse.gmt.modisco.infra.browser.core.LinkItem;
import org.eclipse.gmt.modisco.infra.browser.core.ModelElementItem;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.gmt.modisco.infra.browser.editors.table.TableEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;

public class OpenTableEditorAction
extends Action {
    private final IBrowserActionBarContributor browserActionBarContributor;

    public OpenTableEditorAction(IBrowserActionBarContributor browserActionBarContributor) {
        super(Messages.openTableEditorOnSelection);
        this.browserActionBarContributor = browserActionBarContributor;
    }

    public void run() {
        ISelection selection;
        EcoreBrowser browser = this.browserActionBarContributor.getBrowser();
        if (browser != null && (selection = this.browserActionBarContributor.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1 && structuredSelection.getFirstElement() instanceof LinkItem) {
                LinkItem linkItemProvider = (LinkItem)structuredSelection.getFirstElement();
                this.openOn(browser.getBrowserConfiguration(), linkItemProvider);
            } else {
                this.openOn(browser.getBrowserConfiguration(), structuredSelection);
            }
        }
    }

    private void openOn(BrowserConfiguration browserConfiguration, LinkItem linkItem) {
        List<EObject> childrenElements = linkItem.getChildrenElements();
        ArrayList<EObject> elementsList = new ArrayList<EObject>(childrenElements);
        String description = TableEditor.getEditorDescriptionFor(linkItem.getParent(), linkItem.getReference(), browserConfiguration);
        TableEditor.openOn(browserConfiguration, elementsList, description);
    }

    private void openOn(BrowserConfiguration browserConfiguration, IStructuredSelection structuredSelection) {
        ArrayList<EObject> elements = new ArrayList<EObject>();
        for (Object selectedElement : structuredSelection) {
            if (selectedElement instanceof ModelElementItem) {
                ModelElementItem modelElementItem = (ModelElementItem)selectedElement;
                elements.add(modelElementItem.getEObject());
                continue;
            }
            MoDiscoBrowserPlugin.logWarning(Messages.EcoreActionBarContributor_cannotOpenTableEditorNotModelElements);
            return;
        }
        String metamodelName = browserConfiguration.getMetamodelName();
        String description = metamodelName != null ? NLS.bind((String)Messages.EcoreActionBarContributor_elementsSelection, (Object)metamodelName) : Messages.EcoreActionBarContributor_elementsSelectionUnknowMetamodel;
        TableEditor.openOn(browserConfiguration, elements, description);
    }
}

