/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.browser.core.InstancesForMetaclass;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.browser.util.EMFUtil;
import org.eclipse.gmt.modisco.infra.common.core.internal.adapters.instances.MetaclassInstances;
import org.eclipse.gmt.modisco.infra.common.core.internal.adapters.instances.ModelChangeListener;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.core.FacetContext;
import org.eclipse.gmt.modisco.infra.facet.core.FacetContextListener;
import org.eclipse.gmt.modisco.infra.facet.core.adapters.instances.MetaclassInstancesAdapterFactoryWithFacet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstancesForMetaclasses
implements FacetContextListener,
ModelChangeListener {
    private final TreeMap<EClass, InstancesForMetaclass> modelElements;
    private final ArrayList<InstancesForMetaclass> rootMetaclasses = new ArrayList();
    private final BrowserConfiguration browserConfiguration;
    private final Set<Resource> resources;
    private final List<MetaclassesChangeListener> listeners = new ArrayList<MetaclassesChangeListener>();

    public InstancesForMetaclasses(BrowserConfiguration browserConfiguration, Set<Resource> resources) {
        this.browserConfiguration = browserConfiguration;
        this.resources = resources;
        this.modelElements = new TreeMap(new Comparator<EClass>(){

            @Override
            public int compare(EClass e1, EClass e2) {
                String q1 = ModelUtils.getMetaclassQualifiedName((EClassifier)e1);
                String q2 = ModelUtils.getMetaclassQualifiedName((EClassifier)e2);
                if (q1 == null) {
                    return -1;
                }
                return q1.compareTo(q2);
            }
        });
        Set<EClass> allClasses = EMFUtil.findAllClasses(resources);
        for (EClass eClass : allClasses) {
            InstancesForMetaclass instancesForMetaclass = new InstancesForMetaclass(eClass, this, browserConfiguration, resources);
            this.modelElements.put(eClass, instancesForMetaclass);
        }
        FacetContext facetContext = browserConfiguration.getFacetContext();
        MetaclassInstancesAdapterFactoryWithFacet.getInstance().setFacetContext(facetContext);
        for (Resource resource : resources) {
            MetaclassInstances instances = (MetaclassInstances)MetaclassInstancesAdapterFactoryWithFacet.getInstance().adapt((Notifier)resource, MetaclassInstances.class);
            instances.addListener((ModelChangeListener)this);
        }
        facetContext.addListener((FacetContextListener)this);
    }

    public InstancesForMetaclass[] getInstancesForMetaclasses() {
        Collection<InstancesForMetaclass> instancesForMetaclasses = this.modelElements.values();
        return instancesForMetaclasses.toArray(new InstancesForMetaclass[instancesForMetaclasses.size()]);
    }

    public InstancesForMetaclass getInstancesForMetaclass(EClass eClass) {
        return this.modelElements.get(eClass);
    }

    public void buildDerivationTree() {
        InstancesForMetaclass instancesForMetaclass;
        InstancesForMetaclass[] instancesByMetaclass = this.getInstancesForMetaclasses();
        this.rootMetaclasses.clear();
        InstancesForMetaclass[] instancesForMetaclassArray = instancesByMetaclass;
        int n = instancesByMetaclass.length;
        int n2 = 0;
        while (n2 < n) {
            instancesForMetaclass = instancesForMetaclassArray[n2];
            instancesForMetaclass.clearSubclasses();
            ++n2;
        }
        instancesForMetaclassArray = instancesByMetaclass;
        n = instancesByMetaclass.length;
        n2 = 0;
        while (n2 < n) {
            instancesForMetaclass = instancesForMetaclassArray[n2];
            instancesForMetaclass.buildParentsSubclasses();
            if (instancesForMetaclass.getEClass().getESuperTypes().isEmpty()) {
                this.rootMetaclasses.add(instancesForMetaclass);
            }
            ++n2;
        }
    }

    public InstancesForMetaclass[] getRootMetaclasses() {
        return this.rootMetaclasses.toArray(new InstancesForMetaclass[this.rootMetaclasses.size()]);
    }

    public void facetAdded(Facet facet) {
        InstancesForMetaclass instancesForMetaclass = new InstancesForMetaclass((EClass)facet, this, this.browserConfiguration, this.resources);
        this.modelElements.put((EClass)facet, instancesForMetaclass);
    }

    public void facetsCleared() {
        Iterator<EClass> iterator = this.modelElements.keySet().iterator();
        while (iterator.hasNext()) {
            EClass eClass = iterator.next();
            if (!(eClass instanceof Facet)) continue;
            iterator.remove();
        }
    }

    public void addListener(MetaclassesChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(MetaclassesChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyChanged() {
        for (MetaclassesChangeListener listener : this.listeners) {
            listener.modelChanged();
        }
    }

    public void modelChanged(Notification msg) {
        this.notifyChanged();
    }

    public static interface MetaclassesChangeListener {
        public void modelChanged();
    }
}

