/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.core.BigListItem;
import org.eclipse.gmt.modisco.infra.browser.core.InstancesForMetaclass;
import org.eclipse.gmt.modisco.infra.browser.core.InstancesForMetaclasses;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaclassList {
    private final BrowserConfiguration browserConfiguration;
    private final EClass[] metaclasses;
    private int cachedElementsModCount = -1;
    private List<EObject> cachedElements = null;

    public MetaclassList(BrowserConfiguration browserConfiguration, EClass[] metaclasses) {
        this.browserConfiguration = browserConfiguration;
        this.metaclasses = metaclasses;
    }

    public Collection<?> getElements() {
        if (this.cachedElements == null || this.cachedElementsModCount != this.browserConfiguration.getModCount()) {
            ArrayList<EObject> allElements = new ArrayList<EObject>();
            InstancesForMetaclasses instancesForMetaclasses = this.browserConfiguration.getInstancesForMetaclasses();
            EClass[] eClassArray = this.metaclasses;
            int n = this.metaclasses.length;
            int n2 = 0;
            while (n2 < n) {
                EClass eClass = eClassArray[n2];
                InstancesForMetaclass instancesForMetaclass = instancesForMetaclasses.getInstancesForMetaclass(eClass);
                if (instancesForMetaclass != null) {
                    if (this.browserConfiguration.isDisplayInstancesOfSubclasses()) {
                        allElements.addAll(instancesForMetaclass.getDerivedElements());
                    } else {
                        ArrayList<EObject> elements = instancesForMetaclass.getElements();
                        allElements.addAll(elements);
                    }
                } else {
                    MoDiscoLogger.logWarning((String)("no instancesForMetaclass found for " + eClass.getName()), (Plugin)MoDiscoBrowserPlugin.getPlugin());
                }
                ++n2;
            }
            this.cachedElements = allElements;
            this.cachedElementsModCount = this.browserConfiguration.getModCount();
        }
        return BigListItem.splitElements(null, null, this.cachedElements, this.browserConfiguration, false);
    }
}

