/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.custom.MetamodelView;
import org.eclipse.gmt.modisco.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.gmt.modisco.infra.browser.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.facet.FacetSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PatternFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadCustomizationsDialog
extends Dialog {
    private static final int CUSTOMIZATIONS_TREE_WIDTH = 200;
    private static final int CUSTOMIZATIONS_TREE_HEIGHT = 250;
    private static final int NUM_COLUMNS = 4;
    private final List<MetamodelView> fAvailableCustomizations;
    private final LabelProvider fLabelProvider;
    private final IContentProvider fContentProvider;
    private final EList<MetamodelView> fSelectedCustomizations;
    private TreeViewer fAvailableCustomizationsTreeViewer;
    private TreeViewer fSelectedCustomizationsTreeViewer;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fAddAllButton;
    private Button fRemoveAllButton;
    private Button fUpButton;
    private Button fDownButton;
    private Button fLoadRequiredFacetsCheckbox;
    private final List<MetamodelView> fInitiallySelectedCustomizations;
    private boolean fLoadRequiredFacetsSelected = false;

    public LoadCustomizationsDialog(Shell parent, List<MetamodelView> initiallySelectedCustomizations, final String metamodelURI) {
        super(parent);
        this.fInitiallySelectedCustomizations = initiallySelectedCustomizations;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fSelectedCustomizations = new BasicEList();
        this.fLabelProvider = new LabelProvider(){

            public String getText(Object element) {
                MetamodelView metamodelView = (MetamodelView)element;
                return metamodelView.getName();
            }

            public Image getImage(Object element) {
                return ImageProvider.getInstance().getUiCustomIcon();
            }
        };
        this.fAvailableCustomizations = Collections.synchronizedList(new ArrayList());
        Job loadCustomizationsJob = new Job(Messages.LoadCustomizationsDialog_jobName_LoadCustomizations){

            protected IStatus run(IProgressMonitor monitor) {
                LoadCustomizationsDialog.this.fAvailableCustomizations.clear();
                LoadCustomizationsDialog.this.fAvailableCustomizations.addAll(LoadCustomizationsDialog.this.filterForMetamodel(CustomizationsCatalog.getInstance().getAllCustomizations(), metamodelURI));
                for (MetamodelView initiallySelectedCustomization : LoadCustomizationsDialog.this.fInitiallySelectedCustomizations) {
                    URI initiallySelectedCustomizationURI = EcoreUtil.getURI((EObject)initiallySelectedCustomization);
                    ListIterator availableCustomizationsIterator = LoadCustomizationsDialog.this.fAvailableCustomizations.listIterator();
                    while (availableCustomizationsIterator.hasNext()) {
                        MetamodelView availableCustomization = (MetamodelView)availableCustomizationsIterator.next();
                        URI availableCustomizationURI = EcoreUtil.getURI((EObject)availableCustomization);
                        if (!availableCustomizationURI.equals((Object)initiallySelectedCustomizationURI)) continue;
                        availableCustomizationsIterator.remove();
                        LoadCustomizationsDialog.this.fSelectedCustomizations.add((Object)initiallySelectedCustomization);
                    }
                }
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (!LoadCustomizationsDialog.this.fAvailableCustomizationsTreeViewer.getControl().isDisposed()) {
                            LoadCustomizationsDialog.this.fAvailableCustomizationsTreeViewer.refresh();
                            LoadCustomizationsDialog.this.fSelectedCustomizationsTreeViewer.refresh();
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        loadCustomizationsJob.schedule(50L);
        this.fContentProvider = new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                List customizations = (List)inputElement;
                return customizations.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }
        };
    }

    private Collection<MetamodelView> filterForMetamodel(List<MetamodelView> allCustomizations, String metamodelURI) {
        ArrayList<MetamodelView> filteredCustomizations = new ArrayList<MetamodelView>();
        block0: for (MetamodelView metamodelView : allCustomizations) {
            String nsURI = metamodelView.getMetamodelURI();
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
            while (ePackage != null) {
                nsURI = ePackage.getNsURI();
                if (nsURI != null && nsURI.equals(metamodelURI)) {
                    filteredCustomizations.add(metamodelView);
                    continue block0;
                }
                if (ePackage instanceof FacetSet) {
                    FacetSet facetSet = (FacetSet)ePackage;
                    ePackage = facetSet.getExtendedPackage();
                    continue;
                }
                ePackage = ePackage.getESuperPackage();
            }
        }
        return filteredCustomizations;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.LoadCustomizationsDialog_title_LoadCustomizations);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        GridLayout contentsGridLayout = (GridLayout)contents.getLayout();
        contentsGridLayout.numColumns = 4;
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        this.createLeftPane(contents);
        this.createMiddleButtonsPane(contents);
        this.createRightPane(contents);
        this.createRightButtonsPane(contents);
        this.createLoadRequiredFacetsCheckbox(contents);
        this.fAvailableCustomizationsTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (LoadCustomizationsDialog.this.fAddButton.isEnabled()) {
                    LoadCustomizationsDialog.this.fAddButton.notifyListeners(13, null);
                }
            }
        });
        this.fSelectedCustomizationsTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (LoadCustomizationsDialog.this.fRemoveButton.isEnabled()) {
                    LoadCustomizationsDialog.this.fRemoveButton.notifyListeners(13, null);
                }
            }
        });
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LoadCustomizationsDialog.this.upButtonClicked();
            }
        });
        this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LoadCustomizationsDialog.this.downButtonClicked();
            }
        });
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LoadCustomizationsDialog.this.addButtonClicked();
            }
        });
        this.fAddAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LoadCustomizationsDialog.this.addAllButtonClicked();
            }
        });
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LoadCustomizationsDialog.this.removeButtonClicked();
            }
        });
        this.fRemoveAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LoadCustomizationsDialog.this.removeAllButtonClicked();
            }
        });
        return contents;
    }

    private void upButtonClicked() {
        IStructuredSelection selection = (IStructuredSelection)this.fSelectedCustomizationsTreeViewer.getSelection();
        int minIndex = 0;
        for (MetamodelView element : selection) {
            int index = this.fSelectedCustomizations.indexOf((Object)element);
            this.fSelectedCustomizations.move(Math.max(index - 1, minIndex++), (Object)element);
        }
        this.fSelectedCustomizationsTreeViewer.refresh();
    }

    private void downButtonClicked() {
        IStructuredSelection selection = (IStructuredSelection)this.fSelectedCustomizationsTreeViewer.getSelection();
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedObject = objectArray[n2];
            selectedObjects.add(selectedObject);
            ++n2;
        }
        boolean canMove = !selectedObjects.contains(this.fSelectedCustomizations.get(this.fSelectedCustomizations.size() - 1));
        int i = this.fSelectedCustomizations.size() - 2;
        while (i >= 0) {
            MetamodelView selectedCustomization = (MetamodelView)this.fSelectedCustomizations.get(i);
            if (selectedObjects.contains(selectedCustomization)) {
                if (canMove) {
                    this.fSelectedCustomizations.move(i + 1, (Object)selectedCustomization);
                }
            } else {
                canMove = true;
            }
            --i;
        }
        this.fSelectedCustomizationsTreeViewer.refresh();
    }

    private void addButtonClicked() {
        IStructuredSelection selection = (IStructuredSelection)this.fAvailableCustomizationsTreeViewer.getSelection();
        for (MetamodelView element : selection) {
            if (this.fSelectedCustomizations.contains((Object)element)) continue;
            this.fSelectedCustomizations.add((Object)element);
            this.fAvailableCustomizations.remove(element);
        }
        this.refresh();
        this.fSelectedCustomizationsTreeViewer.setSelection((ISelection)selection);
    }

    private void addAllButtonClicked() {
        ListIterator<MetamodelView> listIterator = this.fAvailableCustomizations.listIterator();
        while (listIterator.hasNext()) {
            MetamodelView element = listIterator.next();
            this.fSelectedCustomizations.add((Object)element);
            listIterator.remove();
        }
        this.refresh();
    }

    private void removeButtonClicked() {
        IStructuredSelection selection = (IStructuredSelection)this.fSelectedCustomizationsTreeViewer.getSelection();
        for (MetamodelView element : selection) {
            this.fSelectedCustomizations.remove((Object)element);
            this.fAvailableCustomizations.add(element);
        }
        if (this.fSelectedCustomizations.size() > 0) {
            this.fSelectedCustomizationsTreeViewer.setSelection((ISelection)new StructuredSelection(this.fSelectedCustomizations.get(0)));
        }
        this.refresh();
    }

    private void removeAllButtonClicked() {
        ListIterator listIterator = this.fSelectedCustomizations.listIterator();
        while (listIterator.hasNext()) {
            MetamodelView element = (MetamodelView)listIterator.next();
            this.fAvailableCustomizations.add(element);
            listIterator.remove();
        }
        this.refresh();
    }

    private void createLeftPane(Composite contents) {
        Composite choiceComposite = new Composite(contents, 0);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalAlignment = 0x1000008;
        choiceComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        data.horizontalAlignment = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        choiceComposite.setLayout((Layout)layout);
        Label choiceLabel = new Label(choiceComposite, 0);
        choiceLabel.setText(Messages.LoadFacetsDialog_AvailableCustomizationsLabel);
        GridData choiceLabelGridData = new GridData();
        choiceLabelGridData.verticalAlignment = 4;
        choiceLabelGridData.horizontalAlignment = 4;
        choiceLabel.setLayoutData((Object)choiceLabelGridData);
        final Text patternText = this.createFilterText(choiceComposite);
        Tree availableCustomizationsTree = new Tree(choiceComposite, 2050);
        GridData availableCustomizationsGridData = new GridData();
        availableCustomizationsGridData.widthHint = 200;
        availableCustomizationsGridData.heightHint = 250;
        availableCustomizationsGridData.horizontalAlignment = 4;
        availableCustomizationsGridData.verticalAlignment = 4;
        availableCustomizationsGridData.grabExcessHorizontalSpace = true;
        availableCustomizationsGridData.grabExcessVerticalSpace = true;
        availableCustomizationsTree.setLayoutData((Object)availableCustomizationsGridData);
        this.fAvailableCustomizationsTreeViewer = new TreeViewer(availableCustomizationsTree);
        this.fAvailableCustomizationsTreeViewer.setContentProvider(this.fContentProvider);
        this.fAvailableCustomizationsTreeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        final PatternFilter filter = new PatternFilter();
        this.fAvailableCustomizationsTreeViewer.addFilter((ViewerFilter)filter);
        this.fAvailableCustomizationsTreeViewer.setInput(this.fAvailableCustomizations);
        TreeItem treeItem = new TreeItem(availableCustomizationsTree, 0);
        treeItem.setText(Messages.LoadCustomizationsDialog_Loading);
        patternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                filter.setPattern(patternText.getText());
                LoadCustomizationsDialog.this.fAvailableCustomizationsTreeViewer.refresh();
            }
        });
    }

    private void createMiddleButtonsPane(Composite contents) {
        Composite buttonsComposite = new Composite(contents, 0);
        GridData buttonsCompositeGridData = new GridData();
        buttonsCompositeGridData.verticalAlignment = 0x1000000;
        buttonsCompositeGridData.horizontalAlignment = 4;
        buttonsComposite.setLayoutData((Object)buttonsCompositeGridData);
        buttonsComposite.setLayout((Layout)new GridLayout());
        this.fAddButton = new Button(buttonsComposite, 8);
        this.fAddButton.setText(Messages.LoadCustomizationsDialog_Add);
        this.fAddButton.setToolTipText(Messages.LoadFacetsDialog_AddTooltip);
        GridData addButtonGridData = new GridData();
        addButtonGridData.verticalAlignment = 4;
        addButtonGridData.horizontalAlignment = 4;
        this.fAddButton.setLayoutData((Object)addButtonGridData);
        this.fRemoveButton = new Button(buttonsComposite, 8);
        this.fRemoveButton.setText(Messages.LoadCustomizationsDialog_Remove);
        this.fRemoveButton.setToolTipText(Messages.LoadFacetsDialog_RemoveTooltip);
        GridData removeButtonGridData = new GridData();
        removeButtonGridData.verticalAlignment = 4;
        removeButtonGridData.horizontalAlignment = 4;
        this.fRemoveButton.setLayoutData((Object)removeButtonGridData);
        this.spacer(buttonsComposite);
        this.fAddAllButton = new Button(buttonsComposite, 8);
        this.fAddAllButton.setText(Messages.LoadCustomizationsDialog_AddAll);
        this.fAddAllButton.setToolTipText(Messages.LoadFacetsDialog_AddAllTooltip);
        this.fRemoveAllButton = new Button(buttonsComposite, 8);
        this.fRemoveAllButton.setText(Messages.LoadCustomizationsDialog_RemoveAll);
        this.fRemoveAllButton.setToolTipText(Messages.LoadFacetsDialog_RemoveAllTooltip);
    }

    private void spacer(Composite parent) {
        new Label(parent, 0);
    }

    private void createRightButtonsPane(Composite contents) {
        Composite buttonsComposite = new Composite(contents, 0);
        GridData buttonsCompositeGridData = new GridData();
        buttonsCompositeGridData.verticalAlignment = 4;
        buttonsCompositeGridData.horizontalAlignment = 4;
        buttonsComposite.setLayoutData((Object)buttonsCompositeGridData);
        buttonsComposite.setLayout((Layout)new GridLayout());
        this.spacer(buttonsComposite);
        this.fUpButton = new Button(buttonsComposite, 8);
        this.fUpButton.setText(Messages.LoadFacetsDialog_UpLabel);
        GridData upButtonGridData = new GridData();
        upButtonGridData.verticalAlignment = 4;
        upButtonGridData.horizontalAlignment = 4;
        this.fUpButton.setLayoutData((Object)upButtonGridData);
        this.fDownButton = new Button(buttonsComposite, 8);
        this.fDownButton.setText(Messages.LoadFacetsDialog_DownLabel);
        GridData downButtonGridData = new GridData();
        downButtonGridData.verticalAlignment = 4;
        downButtonGridData.horizontalAlignment = 4;
        this.fDownButton.setLayoutData((Object)downButtonGridData);
    }

    private void createRightPane(Composite contents) {
        Composite featureComposite = new Composite(contents, 0);
        GridData featureCompositeData = new GridData(4, 4, true, true);
        featureCompositeData.horizontalAlignment = 0x1000008;
        featureComposite.setLayoutData((Object)featureCompositeData);
        GridLayout featureCompositeLayout = new GridLayout();
        featureCompositeData.horizontalAlignment = 4;
        featureCompositeLayout.marginHeight = 0;
        featureCompositeLayout.marginWidth = 0;
        featureCompositeLayout.numColumns = 1;
        featureComposite.setLayout((Layout)featureCompositeLayout);
        Label featureLabel = new Label(featureComposite, 0);
        featureLabel.setText(Messages.LoadFacetsDialog_LoadedCustomizations);
        GridData featureLabelGridData = new GridData();
        featureLabelGridData.horizontalSpan = 2;
        featureLabelGridData.horizontalAlignment = 4;
        featureLabelGridData.verticalAlignment = 4;
        featureLabel.setLayoutData((Object)featureLabelGridData);
        Tree loadedCustomizationsTree = new Tree(featureComposite, 2050);
        GridData loadedCustomizationsGridData = new GridData();
        loadedCustomizationsGridData.widthHint = 200;
        loadedCustomizationsGridData.heightHint = 250;
        loadedCustomizationsGridData.verticalAlignment = 4;
        loadedCustomizationsGridData.horizontalAlignment = 4;
        loadedCustomizationsGridData.grabExcessHorizontalSpace = true;
        loadedCustomizationsGridData.grabExcessVerticalSpace = true;
        loadedCustomizationsTree.setLayoutData((Object)loadedCustomizationsGridData);
        this.fSelectedCustomizationsTreeViewer = new TreeViewer(loadedCustomizationsTree);
        this.fSelectedCustomizationsTreeViewer.setContentProvider(this.fContentProvider);
        this.fSelectedCustomizationsTreeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fSelectedCustomizationsTreeViewer.setInput(this.fSelectedCustomizations);
    }

    private void createLoadRequiredFacetsCheckbox(Composite contents) {
        this.spacer(contents);
        this.spacer(contents);
        this.fLoadRequiredFacetsCheckbox = new Button(contents, 32);
        this.fLoadRequiredFacetsCheckbox.setText(Messages.LoadCustomizationsDialog_loadReferencedFacetsCheckbox);
        this.fLoadRequiredFacetsCheckbox.setSelection(true);
        this.fLoadRequiredFacetsCheckbox.setLayoutData((Object)new GridData(0x1000008, 4, false, false));
    }

    private Text createFilterText(Composite contents) {
        Text patternText = new Text(contents, 2176);
        patternText.setMessage(Messages.LoadFacetsDialog_FilterTextMessage);
        patternText.setLayoutData((Object)new GridData(768));
        return patternText;
    }

    protected void okPressed() {
        this.fLoadRequiredFacetsSelected = this.fLoadRequiredFacetsCheckbox.getSelection();
        super.okPressed();
    }

    public boolean isLoadRequiredFacetsSelected() {
        return this.fLoadRequiredFacetsSelected;
    }

    public List<MetamodelView> getSelectedCustomizations() {
        return this.fSelectedCustomizations;
    }

    private void refresh() {
        this.fAvailableCustomizationsTreeViewer.refresh();
        this.fSelectedCustomizationsTreeViewer.refresh();
    }
}

