/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.ui.common;

import java.net.URL;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmt.modisco.workflow.DriverInterface;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class Common {
    private static Common common = null;

    private Common() {
    }

    public Point centerShell(Display display, Shell shell) {
        Rectangle rect = display.getClientArea();
        Point size = shell.getSize();
        int x = (rect.width - size.x) / 2;
        int y = (rect.height - size.y) / 2;
        return new Point(x, y);
    }

    public Image retrieveImageDriver(String type) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.gmt.modisco.workflow.driver");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals("driverUI")) {
                    try {
                        if (((DriverInterface)element.createExecutableExtension("class")).getTypeLaunchConfig().equals(type)) {
                            Bundle b = Platform.getBundle((String)extension.getNamespaceIdentifier());
                            URL url = b.getResource(element.getAttribute("icon"));
                            return ImageDescriptor.createFromURL((URL)url).createImage();
                        }
                    }
                    catch (InvalidRegistryObjectException e) {
                        e.printStackTrace();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public void refreshPackageExplorer() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static Common getInstance() {
        if (common == null) {
            common = new Common();
        }
        return common;
    }
}

