/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.core.internal.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.common.core.internal.resource.IMoDiscoResourceListener;
import org.eclipse.gmt.modisco.infra.common.core.internal.resource.MoDiscoResourceSet;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.ValidationUtils;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMoDiscoCatalog
implements IMoDiscoResourceListener {
    private static List<AbstractMoDiscoCatalog> catalogs = new ArrayList<AbstractMoDiscoCatalog>();
    private final MoDiscoResourceSet resourceSet = MoDiscoResourceSet.getResourceSetSingleton();
    private final HashMap<String, EObject> nameToInstalledEObjectMap = new HashMap();
    private final HashMap<String, EObject> nameToWorkspaceEObjectMap = new HashMap();
    private final HashMap<String, EObject> uriToEObjectMap = new HashMap();
    private final HashMap<EObject, Bundle> eObjectToBundleMap = new HashMap();
    private final File registryFile;
    private final HashMap<String, URI> uriMap = new HashMap();
    private final List<ModiscoCatalogChangeListener> changeListeners = new ArrayList<ModiscoCatalogChangeListener>();
    private final HashSet<IResource> nonValidFiles = new HashSet();

    protected AbstractMoDiscoCatalog() {
        AbstractMoDiscoCatalog.getCatalogs().add(this);
        IPath absolutePath = this.getActivator().getStateLocation().append(this.getRegistryFileName());
        this.registryFile = absolutePath.toFile();
        this.initInstalledRootObject();
        this.initWorkspaceRootObject();
    }

    protected abstract Plugin getActivator();

    private void initWorkspaceRootObject() {
        try {
            if (this.registryFile.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(this.registryFile));
                String line = br.readLine();
                while (line != null) {
                    URI uri = URI.createURI((String)line);
                    String path = uri.toPlatformString(true);
                    IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        this.addWSFile(file);
                    }
                    line = br.readLine();
                }
                br.close();
            }
        }
        catch (Exception e) {
            Status status = new Status(4, this.getActivator().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e);
            this.getActivator().getLog().log((IStatus)status);
        }
    }

    public void save() {
        try {
            PrintStream ps = new PrintStream(this.registryFile);
            for (EObject rootObject : this.nameToWorkspaceEObjectMap.values()) {
                ps.println(this.getURI(this.getRootObjectName(rootObject)));
            }
            ps.close();
        }
        catch (FileNotFoundException e) {
            Status status = new Status(4, this.getActivator().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e);
            this.getActivator().getLog().log((IStatus)status);
        }
    }

    protected HashMap<String, EObject> getNameToInstalledEObjectMap() {
        return this.nameToInstalledEObjectMap;
    }

    protected HashMap<String, EObject> getNameToWorkspaceEObjectMap() {
        return this.nameToWorkspaceEObjectMap;
    }

    private void initInstalledRootObject() {
        if (this.getRegistryExtensionPoint() != null) {
            IConfigurationElement[] configs;
            IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(this.getRegistryExtensionPoint());
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                String fileName = config.getAttribute("file");
                URI uri = URI.createURI((String)("platform:/plugin/" + config.getContributor().getName() + "/" + fileName));
                EObject rootObject = this.openResource(uri, null);
                if (rootObject != null) {
                    Bundle bundle = Platform.getBundle((String)config.getContributor().getName());
                    this.eObjectToBundleMap.put(rootObject, bundle);
                    String name = this.getRootObjectName(rootObject);
                    this.nameToInstalledEObjectMap.put(name, rootObject);
                }
                ++n2;
            }
        }
    }

    protected abstract String getRootObjectName(EObject var1);

    protected abstract String getRegistryExtensionPoint();

    protected EObject openResource(URI uri, IResource file) {
        EObject rootObject;
        block13: {
            rootObject = null;
            Class<?> expectedClass = this.getRootClass();
            Resource resource = null;
            try {
                try {
                    resource = this.resourceSet.getResource(uri, this);
                    if (ValidationUtils.validate(resource, file)) {
                        if (resource.getContents().size() != 1) {
                            throw new Exception("One and only one root is expected in a model from the catalog; " + resource.getContents().size() + " found.");
                        }
                        EObject root = (EObject)resource.getContents().get(0);
                        if (expectedClass.isInstance(root)) {
                            rootObject = root;
                            this.uriToEObjectMap.put(uri.toString(), rootObject);
                            this.uriMap.put(this.getRootObjectName(rootObject), uri);
                            if (this.getMoDiscoSubProtocol() != null) {
                                URI modiscoUri = URI.createURI((String)("modisco:/" + this.getMoDiscoSubProtocol() + "/" + this.getRootObjectName(rootObject)));
                                Resource modiscoResource = this.resourceSet.getResource(modiscoUri, false);
                                if (modiscoResource == null) {
                                    modiscoResource = this.resourceSet.createResource(modiscoUri);
                                }
                                modiscoResource.getContents().clear();
                                modiscoResource.getContents().addAll((Collection)resource.getContents());
                            }
                        } else {
                            Exception e = new Exception("Wrong kind of root in " + uri.toString() + " : " + root.getClass().getSimpleName() + "; expected " + this.getRootClass().getSimpleName());
                            Status status = new Status(4, this.getActivator().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e);
                            this.getActivator().getLog().log((IStatus)status);
                        }
                        break block13;
                    }
                    this.nonValidFiles.add(file);
                }
                catch (Exception e) {
                    Status status = new Status(4, this.getActivator().getBundle().getSymbolicName(), "Failed to load: " + uri, (Throwable)e);
                    this.getActivator().getLog().log((IStatus)status);
                    if (resource != null) {
                        this.resourceSet.getResources().remove((Object)resource);
                    }
                }
            }
            finally {
                if (resource != null) {
                    this.resourceSet.getResources().remove((Object)resource);
                }
            }
        }
        return rootObject;
    }

    protected abstract String getMoDiscoSubProtocol();

    protected abstract Class<?> getRootClass();

    public final Collection<EObject> getAllRootObjects() {
        return this.getAllRootObjectMap().values();
    }

    protected Map<String, EObject> getAllRootObjectMap() {
        HashMap<String, EObject> allRootObject = new HashMap<String, EObject>();
        allRootObject.putAll(this.nameToInstalledEObjectMap);
        allRootObject.putAll(this.nameToWorkspaceEObjectMap);
        return allRootObject;
    }

    public final EObject getRootObject(String name) {
        return this.getAllRootObjectMap().get(name);
    }

    public final EObject addWSFile(IFile declarationFile) {
        return this.addWSFile(declarationFile, false);
    }

    public void removeWSFile(IFile declarationFile) {
        String pathName = String.valueOf(declarationFile.getProject().getName()) + "/" + declarationFile.getProjectRelativePath().toString();
        URI rootObjectURI = URI.createPlatformResourceURI((String)pathName, (boolean)false);
        EObject oldRootObject = this.uriToEObjectMap.get(rootObjectURI.toString());
        if (oldRootObject != null) {
            EPackage.Registry.INSTANCE.remove((Object)this.getRootObjectNsUri(oldRootObject));
            this.nameToWorkspaceEObjectMap.remove(this.getRootObjectName(oldRootObject));
            this.uriToEObjectMap.remove(this.getRootObjectName(oldRootObject));
            if (oldRootObject.eResource() != null) {
                oldRootObject.eResource().unload();
            }
        }
        try {
            if (declarationFile.exists()) {
                declarationFile.deleteMarkers("org.eclipse.emf.ecore.diagnostic", true, 0);
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, this.getActivator().getBundle().getSymbolicName(), "An exception happened while removing markers", (Throwable)e);
            this.getActivator().getLog().log((IStatus)status);
        }
        this.removeNotify(declarationFile);
    }

    protected abstract String getRootObjectNsUri(EObject var1);

    public final EObject addWSFile(IFile declarationFile, boolean update) {
        EObject rootEObject = null;
        try {
            try {
                declarationFile.deleteMarkers("org.eclipse.emf.ecore.diagnostic", true, 0);
            }
            catch (CoreException e) {
                Status status = new Status(4, this.getActivator().getBundle().getSymbolicName(), "An exception happened while removing markers", (Throwable)e);
                this.getActivator().getLog().log((IStatus)status);
            }
            String pathName = String.valueOf(declarationFile.getProject().getName()) + "/" + declarationFile.getProjectRelativePath().toString();
            URI rootObjectURI = URI.createPlatformResourceURI((String)pathName, (boolean)false);
            rootEObject = this.openResource(rootObjectURI, (IResource)declarationFile);
            if (rootEObject != null) {
                this.nameToWorkspaceEObjectMap.put(this.getRootObjectName(rootEObject), rootEObject);
                this.resourceSet.aResourceHasBeenLoaded(rootEObject.eResource());
                if (update) {
                    this.updateNotify(rootEObject, declarationFile);
                } else {
                    this.addNotify(rootEObject, declarationFile);
                }
            }
        }
        catch (Exception e) {
            String verb = update ? "update" : "add";
            Status status = new Status(4, this.getActivator().getBundle().getSymbolicName(), "Failed to " + verb + " a workspace file in " + this.getClass().getSimpleName() + " : " + declarationFile.getLocation().toString(), (Throwable)e);
            this.getActivator().getLog().log((IStatus)status);
        }
        return rootEObject;
    }

    public final EObject updateWSFile(IFile declarationFile) {
        return this.addWSFile(declarationFile, true);
    }

    private void addNotify(EObject rootObject, IFile file) {
        for (ModiscoCatalogChangeListener listener : this.changeListeners) {
            listener.added(rootObject, file);
        }
    }

    private void removeNotify(IFile file) {
        for (ModiscoCatalogChangeListener listener : this.changeListeners) {
            listener.removed(file);
        }
    }

    private void updateNotify(EObject rootObject, IFile file) {
        for (ModiscoCatalogChangeListener listener : this.changeListeners) {
            listener.changed(rootObject, file);
        }
    }

    public URI getURI(String name) {
        return this.uriMap.get(name);
    }

    public void addChangeListener(ModiscoCatalogChangeListener modiscoCatalogChangeListener) {
        this.changeListeners.add(modiscoCatalogChangeListener);
    }

    public void removeChangeListener(ModiscoCatalogChangeListener modiscoCatalogChangeListener) {
        this.changeListeners.remove(modiscoCatalogChangeListener);
    }

    public void clean(IProject project) {
        for (IResource resource : this.nonValidFiles) {
            try {
                if (resource == null) continue;
                resource.deleteMarkers("org.eclipse.emf.ecore.diagnostic", true, 1);
            }
            catch (CoreException e) {
                MoDiscoLogger.logError(e, "An error happened while removing markers", (Plugin)CommonModiscoActivator.getDefault());
            }
        }
        this.nonValidFiles.clear();
        ArrayList<String> toBeRemovedList = new ArrayList<String>();
        ArrayList<IFile> toBeRemovedFileList = new ArrayList<IFile>();
        for (String rootObjectName : this.nameToWorkspaceEObjectMap.keySet()) {
            IFile file;
            EObject rootObject = this.nameToWorkspaceEObjectMap.get(rootObjectName);
            if (rootObject.eResource() == null) {
                toBeRemovedList.add(rootObjectName);
                continue;
            }
            URI uri = this.getURI(rootObjectName);
            if (!uri.isPlatformResource() || (file = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(uri.toPlatformString(true))) == null || project != file.getProject()) continue;
            toBeRemovedFileList.add(file);
        }
        for (String toBeRemoved : toBeRemovedList) {
            this.nameToWorkspaceEObjectMap.remove(toBeRemoved);
        }
        if (!toBeRemovedList.isEmpty()) {
            this.removeNotify(null);
        }
        for (IFile file : toBeRemovedFileList) {
            this.removeWSFile(file);
        }
        if (!toBeRemovedFileList.isEmpty()) {
            this.removeNotify(null);
        }
    }

    @Override
    public void aListenedResourceHasChanged(URI resourceUri, URI dependingResourceURI) {
        IFile declarationFile = null;
        if (dependingResourceURI.isPlatformResource()) {
            URI uri = dependingResourceURI;
            declarationFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        } else if (dependingResourceURI.scheme().equals("modisco")) {
            URI uri = this.getURI(dependingResourceURI.segment(1));
            declarationFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        } else {
            throw new RuntimeException("Unexpected uri: " + dependingResourceURI);
        }
        if (MoDiscoResourceSet.DEBUG) {
            Status status = new Status(1, this.getActivator().getBundle().getSymbolicName(), "[" + this.getClass().getSimpleName() + ".aListenedResourceHasChanged()] Reloading: file= " + declarationFile);
            this.getActivator().getLog().log((IStatus)status);
        }
        this.updateWSFile(declarationFile);
    }

    private final String getRegistryFileName() {
        return String.valueOf(this.getClass().getName()) + "Registry";
    }

    protected Bundle getBundle(EObject rootObject) {
        return this.eObjectToBundleMap.get(rootObject);
    }

    public static List<AbstractMoDiscoCatalog> getCatalogs() {
        return catalogs;
    }

    public static interface ModiscoCatalogChangeListener
    extends EventListener {
        public void changed(EObject var1, IFile var2);

        public void added(EObject var1, IFile var2);

        public void removed(IFile var1);
    }
}

