/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.core.internal.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.gmt.modisco.infra.common.core.internal.builder.IModiscoBuilder;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;

public class ModiscoProjectBuilder
extends IncrementalProjectBuilder {
    private static final String EXTENSION_POINT_ID = "org.eclipse.gmt.modisco.common.core.builder.register";
    public static final String BUILDER_NAME = "org.eclipse.gmt.modisco.common.core.builder";
    private static ArrayList<BuilderDescriptor> modiscoBuilders = null;

    public ModiscoProjectBuilder() {
        if (modiscoBuilders == null) {
            IConfigurationElement[] configs;
            modiscoBuilders = new ArrayList();
            IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                try {
                    String id = config.getDeclaringExtension().getUniqueIdentifier();
                    IModiscoBuilder builderInst = (IModiscoBuilder)config.createExecutableExtension("class");
                    BuilderDescriptor builderDescriptor = new BuilderDescriptor(builderInst, id);
                    modiscoBuilders.add(builderDescriptor);
                    IConfigurationElement[] iConfigurationElementArray2 = config.getChildren("depends");
                    int n3 = iConfigurationElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement depends = iConfigurationElementArray2[n4];
                        builderDescriptor.getDependsOn().add(depends.getAttribute("builder"));
                        ++n4;
                    }
                }
                catch (Exception e) {
                    MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
                }
                ++n2;
            }
            Collections.sort(modiscoBuilders);
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        for (BuilderDescriptor builder : modiscoBuilders) {
            builder.getBuilderInst().clean(this, monitor);
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        for (BuilderDescriptor builder : modiscoBuilders) {
            builder.getBuilderInst().build(this, kind, args, monitor);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BuilderDescriptor
    implements Comparable<BuilderDescriptor> {
        private final IModiscoBuilder builderInst;
        private final List<String> dependsOn = new ArrayList<String>();
        private final String id;

        public BuilderDescriptor(IModiscoBuilder builderInst, String id) {
            this.builderInst = builderInst;
            this.id = id;
        }

        public List<String> getDependsOn() {
            return this.dependsOn;
        }

        public IModiscoBuilder getBuilderInst() {
            return this.builderInst;
        }

        @Override
        public int compareTo(BuilderDescriptor builderDescriptor) {
            int result = 0;
            if (this.dependsOn.contains(builderDescriptor.id)) {
                result = 1;
            }
            if (builderDescriptor.dependsOn.contains(this.id)) {
                result = -1;
            }
            return result;
        }

        public String toString() {
            return String.valueOf(this.id) + "(" + this.builderInst.getClass().getName() + ")";
        }
    }
}

