/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.core.internal.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FolderUtils {
    private static final int COPY_BUFFER_SIZE = 524288;
    private static boolean debug = false;
    private static ConfigurationManagementFilter configurationManagementFilter;

    private FolderUtils() {
    }

    public static final void clearFolder(File dirtyFolder) {
        File[] files;
        assert (dirtyFolder != null);
        assert (dirtyFolder.exists());
        assert (dirtyFolder.isDirectory());
        File[] fileArray = files = dirtyFolder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FolderUtils.clearFolder(file);
            }
            file.delete();
            ++n2;
        }
    }

    public static final boolean compareFolders(File folderSource, File folderTarget) {
        return FolderUtils.compareFolders(folderSource, folderTarget, configurationManagementFilter, FolderUtils.getDefaultFileComparator());
    }

    public static final boolean compareFolders(File folderSource, File folderTarget, FilenameFilter filter) {
        return FolderUtils.compareFolders(folderSource, folderTarget, filter, FolderUtils.getDefaultFileComparator());
    }

    public static final boolean compareFolders(File folderSource, File folderTarget, FilenameFilter filter, Comparator<File> fileComparison) {
        assert (folderSource != null && folderTarget != null);
        assert (folderSource.isDirectory() && folderTarget.isDirectory());
        boolean result = false;
        if (folderSource.equals(folderTarget)) {
            result = true;
        } else {
            result = FolderUtils.recursiveCompareFolders(folderSource, folderTarget, filter, fileComparison);
            if (debug && !result) {
                MoDiscoLogger.logError("folders " + folderSource.getName() + " and " + folderTarget.getName() + " are not equal.", (Plugin)CommonModiscoActivator.getDefault());
            }
        }
        return result;
    }

    public static final boolean compareFiles(File source, File target) {
        return FolderUtils.compareFiles(source, target, FolderUtils.getDefaultFileComparator());
    }

    private static final Comparator<File> getDefaultFileComparator() {
        return new Comparator<File>(){

            @Override
            public int compare(File source, File target) {
                boolean result = true;
                if (!source.getName().equals(target.getName())) {
                    result = false;
                } else {
                    try {
                        BufferedReader sourceReader = new BufferedReader(new FileReader(source));
                        BufferedReader targetReader = new BufferedReader(new FileReader(target));
                        String sourceLine = sourceReader.readLine();
                        String targetLine = targetReader.readLine();
                        while (sourceLine != null && targetLine != null) {
                            result = result && sourceLine.equals(targetLine);
                            sourceLine = sourceReader.readLine();
                            targetLine = targetReader.readLine();
                        }
                        if (sourceLine != null || targetLine != null) {
                            result = false;
                            MoDiscoLogger.logError("These files do not have the same number of lines.", (Plugin)CommonModiscoActivator.getDefault());
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        result = false;
                    }
                    catch (IOException iOException) {
                        result = false;
                    }
                }
                if (result) {
                    return 0;
                }
                return -1;
            }
        };
    }

    public static final boolean compareFiles(File source, File target, Comparator<File> fileComparator) {
        boolean result;
        assert (source.isFile() && target.isFile());
        boolean bl = result = fileComparator.compare(source, target) == 0;
        if (debug && result) {
            MoDiscoLogger.logInfo("Files " + source.getName() + " and " + target.getName() + " are equal.", (Plugin)CommonModiscoActivator.getDefault());
        }
        return result;
    }

    public static final String getFileContent(File source) {
        StringBuilder result = new StringBuilder();
        try {
            BufferedReader sourceReader = new BufferedReader(new FileReader(source));
            String sourceLine = sourceReader.readLine();
            while (sourceLine != null) {
                result.append(sourceLine);
                result.append("\n");
                sourceLine = sourceReader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    private static final boolean recursiveCompareFolders(File folderSource, File folderTarget, FilenameFilter filter, Comparator<File> fileComparison) {
        File[] targetContents;
        if (debug) {
            MoDiscoLogger.logError("comparison of " + folderSource.getName() + " and " + folderTarget.getName(), (Plugin)CommonModiscoActivator.getDefault());
        }
        boolean result = true;
        File[] sourceContents = folderSource.listFiles(filter);
        if (sourceContents.length != (targetContents = folderTarget.listFiles(filter)).length) {
            result = false;
            if (debug) {
                MoDiscoLogger.logError("folders " + folderSource.getName() + " and " + folderTarget.getName() + " do not have the same number of children (" + sourceContents.length + ", " + targetContents.length + ")", (Plugin)CommonModiscoActivator.getDefault());
            }
        } else {
            File[] fileArray = sourceContents;
            int n = sourceContents.length;
            int n2 = 0;
            while (n2 < n) {
                boolean subResult;
                File sourceContent = fileArray[n2];
                File targetContent = FolderUtils.getCorrespondingTargetContent(sourceContent, targetContents);
                if (targetContent == null) {
                    result = false;
                    if (debug) {
                        MoDiscoLogger.logError("There is no corresponding element in target folder for " + sourceContent.getName(), (Plugin)CommonModiscoActivator.getDefault());
                    }
                } else if (sourceContent.isDirectory()) {
                    subResult = FolderUtils.recursiveCompareFolders(sourceContent, targetContent, filter, fileComparison);
                    boolean bl = result = result && subResult;
                    if (debug && !subResult) {
                        MoDiscoLogger.logError("folders " + sourceContent.getName() + " and " + targetContent.getName() + " are not equal.", (Plugin)CommonModiscoActivator.getDefault());
                    }
                } else {
                    subResult = FolderUtils.compareFiles(sourceContent, targetContent, fileComparison);
                    boolean bl = result = result && subResult;
                    if (debug && !subResult) {
                        MoDiscoLogger.logError("files " + sourceContent.getName() + " and " + targetContent.getName() + " are not equal.", (Plugin)CommonModiscoActivator.getDefault());
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private static final File getCorrespondingTargetContent(File sourceContent, File[] targetContents) {
        File targetContent = null;
        File[] fileArray = targetContents;
        int n = targetContents.length;
        int n2 = 0;
        while (n2 < n) {
            File temp = fileArray[n2];
            if (sourceContent.getName().equals(temp.getName())) {
                targetContent = temp;
            }
            ++n2;
        }
        return targetContent;
    }

    public static final void copyDirectory(File srcDir, File destDir) throws IOException {
        File[] filesList;
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        File[] fileArray = filesList = srcDir.listFiles();
        int n = filesList.length;
        int n2 = 0;
        while (n2 < n) {
            File src = fileArray[n2];
            File dest = new File(String.valueOf(destDir.getPath()) + File.separator + src.getName());
            if (src.isDirectory()) {
                FolderUtils.copyDirectory(src, dest);
            } else {
                FolderUtils.copyFile(src, dest);
            }
            ++n2;
        }
    }

    public static void copyFolderFromBundle(String sourcePath, Plugin sourcePlugin, String destinationPath, IProject project) throws IOException, CoreException {
        Bundle sourceBundle = sourcePlugin.getBundle();
        Enumeration e = sourceBundle.getEntryPaths(sourcePath);
        if (e == null) {
            try {
                InputStream source = sourceBundle.getEntry(sourcePath).openStream();
                IFile javaFile = project.getFile(destinationPath);
                if (javaFile.exists()) {
                    javaFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                javaFile.create(source, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e1) {
                MoDiscoLogger.logError(e1, sourcePlugin);
            }
        } else {
            String subDestinationPath = "/";
            if (!destinationPath.equals("/")) {
                IFolder folder = project.getFolder(destinationPath);
                if (!folder.exists()) {
                    try {
                        folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e1) {
                        MoDiscoLogger.logError(e1, sourcePlugin);
                    }
                }
                subDestinationPath = folder.getProjectRelativePath().toString();
            }
            while (e.hasMoreElements()) {
                Object object = e.nextElement();
                if (object instanceof String) {
                    String subpath = (String)object;
                    if (subpath.matches(".*/\\.svn/")) continue;
                    String dest = String.valueOf(subDestinationPath) + subpath.substring(sourcePath.length() - 1);
                    FolderUtils.copyFolderFromBundle(subpath, sourcePlugin, dest, project);
                    continue;
                }
                throw new RuntimeException("Unexpected element type");
            }
        }
    }

    public static final boolean copyFile(File source, File destination) {
        boolean result;
        block23: {
            result = false;
            FileInputStream sourceFile = null;
            FileOutputStream destinationFile = null;
            try {
                int nbRead;
                destination.createNewFile();
                sourceFile = new FileInputStream(source);
                destinationFile = new FileOutputStream(destination);
                byte[] buffer = new byte[524288];
                while ((nbRead = sourceFile.read(buffer)) != -1) {
                    destinationFile.write(buffer, 0, nbRead);
                }
                result = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                result = false;
                try {
                    if (sourceFile != null) {
                        sourceFile.close();
                    }
                    if (destinationFile != null) {
                        destinationFile.close();
                    }
                    break block23;
                }
                catch (Exception exception) {
                    result = false;
                }
                break block23;
            }
            catch (IOException iOException) {
                try {
                    result = false;
                }
                catch (Throwable throwable) {
                    try {
                        if (sourceFile != null) {
                            sourceFile.close();
                        }
                        if (destinationFile != null) {
                            destinationFile.close();
                        }
                    }
                    catch (Exception exception) {
                        result = false;
                    }
                    throw throwable;
                }
                try {
                    if (sourceFile != null) {
                        sourceFile.close();
                    }
                    if (destinationFile != null) {
                        destinationFile.close();
                    }
                    break block23;
                }
                catch (Exception exception) {
                    result = false;
                }
                break block23;
            }
            try {
                if (sourceFile != null) {
                    sourceFile.close();
                }
                if (destinationFile != null) {
                    destinationFile.close();
                }
            }
            catch (Exception exception) {
                result = false;
            }
        }
        return result;
    }

    public static final void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FolderUtils.clearFolder(directory);
        if (directory.list().length == 0 && !directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }

    public static void createFolder(IFolder folder) throws CoreException {
        if (!folder.getParent().exists()) {
            FolderUtils.createFolder((IFolder)folder.getParent());
        }
        folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static final void writeFileContent(File source, String newContent) throws IOException {
        FileWriter fw = new FileWriter(source, false);
        fw.write(newContent);
        fw.close();
    }

    private static class ConfigurationManagementFilter
    implements FilenameFilter {
        private final String filterName = "CVS";

        private ConfigurationManagementFilter() {
        }

        public boolean accept(File dir, String name) {
            boolean result = false;
            if (!name.equals("CVS")) {
                result = true;
            }
            return result;
        }
    }
}

