/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.core.internal.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelUtils {
    private static final String ENCODING_PROPERTY = "file.encoding";
    private static ResourceSet resourceSet = new ResourceSetImpl();
    private static AdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    private ModelUtils() {
    }

    public static Resource load(File file) throws IOException {
        URI modelURI = URI.createFileURI((String)file.getPath());
        return ModelUtils.load(modelURI);
    }

    public static Resource load(URI modelURI) throws IOException {
        Resource.Factory.Registry reg;
        Object resourceFactory;
        String fileExtension = modelURI.fileExtension();
        if (fileExtension == null || fileExtension.length() == 0) {
            fileExtension = "*";
        }
        if ((resourceFactory = (reg = Resource.Factory.Registry.INSTANCE).getExtensionToFactoryMap().get(fileExtension)) != null) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, resourceFactory);
        } else {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, new XMIResourceFactoryImpl());
        }
        Resource result = resourceSet.createResource(modelURI);
        if (result != null) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", System.getProperty(ENCODING_PROPERTY));
            result.load(options);
        }
        return result;
    }

    private static Set<EObject> getElementsByType(Resource extent, String type) {
        HashSet<EObject> ret = new HashSet<EObject>();
        TreeIterator i = extent.getAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            if (!eo.eClass().getName().equals(type)) continue;
            ret.add(eo);
        }
        return ret;
    }

    public static void registerMetamodel(URI metamodelURI) throws IOException {
        if (EPackage.Registry.INSTANCE.getEPackage(metamodelURI.toString()) != null) {
            return;
        }
        EcoreResourceFactoryImpl myEcoreFactory = new EcoreResourceFactoryImpl();
        Resource mmExtent = myEcoreFactory.createResource(metamodelURI);
        mmExtent.load((InputStream)new FileInputStream(metamodelURI.toFileString()), Collections.EMPTY_MAP);
        for (EPackage ePackage : ModelUtils.getElementsByType(mmExtent, "EPackage")) {
            String nsURI = ePackage.getNsURI();
            if (nsURI == null) {
                nsURI = ePackage.getName();
                ePackage.setNsURI(nsURI);
            }
            EPackage.Registry.INSTANCE.put((Object)nsURI, (Object)ePackage);
        }
        for (EObject eObject : ModelUtils.getElementsByType(mmExtent, "EDataType")) {
            EStructuralFeature sf = eObject.eClass().getEStructuralFeature("name");
            String tname = (String)eObject.eGet(sf);
            String icn = null;
            if (tname.equals("Boolean")) {
                icn = "java.lang.Boolean";
            } else if (tname.equals("Double") || tname.equals("Real")) {
                icn = "java.lang.Double";
            } else if (tname.equals("Float")) {
                icn = "java.lang.Float";
            } else if (tname.equals("Integer")) {
                icn = "java.lang.Integer";
            } else if (tname.equals("String")) {
                icn = "java.lang.String";
            }
            if (icn == null) continue;
            sf = eObject.eClass().getEStructuralFeature("instanceClassName");
            eObject.eSet(sf, (Object)icn);
        }
    }

    public static void save(EObject root, String path) throws IOException {
        URI modelURI = URI.createURI((String)path);
        ModelUtils.save(root, modelURI);
    }

    public static void save(EObject root, URI modelURI) throws IOException {
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource newModelResource = resourceSet.createResource(modelURI);
        newModelResource.getContents().add((Object)root);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", System.getProperty(ENCODING_PROPERTY));
        newModelResource.save(options);
    }

    public static String serialize(EObject root) throws IOException {
        if (root == null) {
            throw new NullPointerException("ModelUtils.NullSaveRoot");
        }
        XMIResourceImpl newResource = new XMIResourceImpl();
        StringWriter writer = new StringWriter();
        newResource.getContents().add((Object)root);
        newResource.save((Writer)writer, Collections.EMPTY_MAP);
        return writer.toString();
    }

    public static boolean compareModels(File leftUri, File rightUri, boolean ignoreIds, boolean delete) throws IOException, InterruptedException {
        boolean result = true;
        Resource leftModel = ModelUtils.load(leftUri);
        Resource rightModel = ModelUtils.load(rightUri);
        result = ModelUtils.compareModels(leftModel, rightModel, ignoreIds);
        if (delete) {
            leftUri.delete();
        }
        return result;
    }

    public static boolean compareModels(Resource leftModel, Resource rightModel, boolean ignoreIds) throws IOException, InterruptedException {
        MatchModel inputMatch;
        DiffModel inputDiff;
        boolean result = true;
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        if (ignoreIds) {
            options.put("match.ignore.xmi.id", Boolean.TRUE);
        }
        if (((DiffGroup)(inputDiff = DiffService.doDiff((MatchModel)(inputMatch = MatchService.doResourceMatch((Resource)leftModel, (Resource)rightModel, options)))).getOwnedElements().get(0)).getSubchanges() != 0) {
            result = false;
            ComparisonResourceSnapshot snapshot = DiffFactory.eINSTANCE.createComparisonResourceSnapshot();
            snapshot.setDiff(inputDiff);
            snapshot.setMatch(inputMatch);
            ModelUtils.save((EObject)snapshot, leftModel.getURI().appendFileExtension("emfdiff"));
        }
        return result;
    }

    public static String getName(EObject eObject) {
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)composedAdapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
        if (itemLabelProvider != null) {
            return itemLabelProvider.getText((Object)eObject);
        }
        return ModelUtils.getDefaultName(eObject);
    }

    public static String getDefaultName(EObject eObject) {
        Object value;
        EStructuralFeature feature = ModelUtils.getLabelFeature(eObject.eClass());
        if (feature != null && (value = eObject.eGet(feature)) != null) {
            return StringUtils.truncateBeforeNewline(value.toString());
        }
        return "";
    }

    private static EStructuralFeature getLabelFeature(EClass eClass) {
        EAttribute result = null;
        for (EAttribute eAttribute : eClass.getEAllAttributes()) {
            if (eAttribute.isMany() || eAttribute.getEType().getInstanceClass() == FeatureMap.Entry.class) continue;
            if ("name".equalsIgnoreCase(eAttribute.getName())) {
                result = eAttribute;
                break;
            }
            if (result == null) {
                result = eAttribute;
                continue;
            }
            if (eAttribute.getEAttributeType().getInstanceClass() != String.class || result.getEAttributeType().getInstanceClass() == String.class) continue;
            result = eAttribute;
        }
        return result;
    }

    public static String getMetaclassQualifiedName(EClassifier eClass) {
        ArrayList<String> qualifiedNameParts = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        EPackage ePackage = eClass.getEPackage();
        while (ePackage != null) {
            qualifiedNameParts.add(ePackage.getName());
            ePackage = ePackage.getESuperPackage();
        }
        int i = qualifiedNameParts.size() - 1;
        while (i >= 0) {
            builder.append(String.valueOf((String)qualifiedNameParts.get(i)) + ".");
            --i;
        }
        builder.append(eClass.getName());
        return builder.toString();
    }
}

