/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.core.internal.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gmt.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.gmt.modisco.infra.common.core.internal.Messages;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.FileUtils;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.FolderUtils;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.osgi.framework.Bundle;

public final class ProjectUtils {
    private static final String JAVA_VERSION = "J2SE-1.5";

    private ProjectUtils() {
    }

    public static void addPdeClassPath(IProject project) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] oldClassPath = javaProject.getRawClasspath();
        IClasspathEntry[] newClassPath = new IClasspathEntry[oldClassPath.length + 1];
        System.arraycopy(oldClassPath, 0, newClassPath, 0, oldClassPath.length);
        newClassPath[oldClassPath.length] = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins"));
        javaProject.setRawClasspath(newClassPath, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void createManifest(IProject project) throws CoreException {
        IFile manifestFile;
        IFolder folder = project.getFolder("META-INF");
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!(manifestFile = folder.getFile("MANIFEST.MF")).exists()) {
            StringBuffer manifestSB = new StringBuffer();
            manifestSB.append("Manifest-Version: 1.0\n");
            manifestSB.append("Bundle-ManifestVersion: 2\n");
            manifestSB.append("Bundle-Name: " + project.getName() + "\n");
            manifestSB.append("Bundle-SymbolicName: " + project.getName() + ";singleton:=true\n");
            manifestSB.append("Bundle-Version: 0.0.1.qualifier\n");
            manifestSB.append("Require-Bundle: org.eclipse.gmt.modisco.infra.query.core\n");
            manifestSB.append("Bundle-RequiredExecutionEnvironment: J2SE-1.5\n");
            manifestSB.append("Bundle-ActivationPolicy: lazy\n");
            manifestSB.append("Bundle-ClassPath: .,bin\n");
            ByteArrayInputStream source = new ByteArrayInputStream(manifestSB.toString().getBytes());
            manifestFile.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void addPdeNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "org.eclipse.pde.PluginNature";
        description.setNatureIds(newNatures);
        project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void addPdeBuilder(IProject project) throws CoreException {
        IProjectDescription projectDescription = project.getDescription();
        ICommand[] oldBuildSpec = project.getDescription().getBuildSpec();
        ICommand[] newBuildSpec = new ICommand[oldBuildSpec.length + 2];
        System.arraycopy(oldBuildSpec, 0, newBuildSpec, 0, oldBuildSpec.length);
        ICommand command1 = project.getDescription().newCommand();
        command1.setBuilderName("org.eclipse.pde.ManifestBuilder");
        ICommand command2 = project.getDescription().newCommand();
        command2.setBuilderName("org.eclipse.pde.SchemaBuilder");
        newBuildSpec[oldBuildSpec.length] = command1;
        newBuildSpec[oldBuildSpec.length + 1] = command2;
        projectDescription.setBuildSpec(newBuildSpec);
        project.setDescription(projectDescription, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void configureAsJavaProject(IProject project, IProgressMonitor monitor) throws CoreException {
        ProjectUtils.addNature(project, monitor, "org.eclipse.jdt.core.javanature");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPath path = project.getFullPath().append("bin");
        javaProject.setOutputLocation(path, null);
        ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
        IFolder sourceFolder = project.getFolder("src");
        sourceFolder.create(false, true, monitor);
        classpathEntries.add(JavaCore.newSourceEntry((IPath)javaProject.getPath().append((IPath)new Path("src"))));
        classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path(String.valueOf(JavaRuntime.JRE_CONTAINER) + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/" + JAVA_VERSION)));
        javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[0]), monitor);
    }

    public static void importPlugin(Bundle bundle) throws CoreException, IOException {
        String bundleName = bundle.getSymbolicName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(bundleName);
        if (project.exists()) {
            bundleName = String.valueOf(bundleName) + " " + System.currentTimeMillis();
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(bundleName);
            if (project.exists()) {
                throw new RuntimeException("Unexpected error.");
            }
        }
        project.create((IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        ZipFile zip = null;
        try {
            String bundlePath = bundle.getLocation();
            String filePath = bundlePath.replaceFirst("^reference:file:", "");
            File bundleFile = new File(filePath);
            if (bundleFile.isDirectory()) {
                FolderUtils.copyDirectory(bundleFile, project.getLocation().toFile());
            } else {
                zip = new ZipFile(new File(filePath));
                Enumeration<? extends ZipEntry> entries = zip.entries();
                ArrayList<Status> errors = new ArrayList<Status>();
                while (entries.hasMoreElements()) {
                    try {
                        ZipEntry zipEntry = entries.nextElement();
                        if (zipEntry.isDirectory()) {
                            IFolder f = project.getFolder(zipEntry.getName());
                            if (f.exists()) continue;
                            f.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                            continue;
                        }
                        InputStream is = zip.getInputStream(zipEntry);
                        IFile f = project.getFile(zipEntry.getName());
                        if (!f.getParent().exists() && f.getParent() instanceof IFolder) {
                            IFolder folder = (IFolder)f.getParent();
                            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        if (f.exists()) {
                            f.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        f.create(is, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        errors.add(new Status(4, "org.eclipse.gmt.modisco.infra.common.core", e.getMessage(), (Throwable)e));
                    }
                }
                if (errors.size() > 0) {
                    IStatus[] statusArray = errors.toArray(new IStatus[0]);
                    MultiStatus status = new MultiStatus("org.eclipse.gmt.modisco.infra.common.core", 4, statusArray, "Errors happend", (Throwable)new Exception());
                    CoreException exception = new CoreException((IStatus)status);
                    throw exception;
                }
            }
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        project.build(15, (IProgressMonitor)new NullProgressMonitor());
        project.build(6, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void configureAsPluginProject(IProject project) throws CoreException {
        ProjectUtils.addPdeNature(project);
        ProjectUtils.addPdeBuilder(project);
        ProjectUtils.addPdeClassPath(project);
        ProjectUtils.createManifest(project);
    }

    public static void addNature(IProject project, IProgressMonitor monitor, String natureId) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = natureId;
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    public static void createBuildProperties(IProject project) throws CoreException {
        IFile manifestFile = project.getFile("build.properties");
        if (!manifestFile.exists()) {
            StringBuffer manifestSB = new StringBuffer();
            manifestSB.append("source.. = src/\n");
            manifestSB.append("output.. = bin/\n");
            manifestSB.append("bin.includes = META-INF/,\\\n");
            manifestSB.append("               .\n");
            ByteArrayInputStream source = new ByteArrayInputStream(manifestSB.toString().getBytes());
            manifestFile.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static void create(IProject project, IProgressMonitor monitor) throws CoreException {
        IPath projectLocation = project.getLocation();
        monitor.beginTask(Messages.ProjectUtils_0, -1);
        if (!project.exists()) {
            IProjectDescription description = project.getWorkspace().newProjectDescription(project.getName());
            if (!Platform.getLocation().equals((Object)projectLocation)) {
                description.setLocation(projectLocation);
            }
            project.create(monitor);
            project.open(monitor);
            monitor.subTask(Messages.ProjectUtils_1);
            ProjectUtils.addNature(project, monitor, "org.eclipse.gmt.modisco.common.ProjectNature");
            ProjectUtils.configureAsJavaProject(project, monitor);
            monitor.subTask(Messages.ProjectUtils_2);
            ProjectUtils.configureAsPluginProject(project);
            ProjectUtils.createBuildProperties(project);
        } else {
            MoDiscoLogger.logWarning("Project creation aborted : the project already exists", (Plugin)CommonModiscoActivator.getDefault());
        }
        monitor.done();
    }

    public static IProject createTestProject(String projectName, Bundle bundleContainingResources, String resourceFolder) throws Exception {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        IProject projectToCreate = ws.getRoot().getProject(projectName);
        if (projectToCreate.exists()) {
            projectToCreate.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (projectToCreate.exists()) {
            throw new Exception(String.valueOf(projectName) + " project already exists");
        }
        ProjectUtils.create(projectToCreate, (IProgressMonitor)new NullProgressMonitor());
        String manifestLocation = "resources/" + resourceFolder + "/MANIFEST.MF_" + projectName;
        if (bundleContainingResources.getResource(manifestLocation) != null) {
            FileUtils.copyFileFromBundle(manifestLocation, projectToCreate, "META-INF/MANIFEST.MF", bundleContainingResources);
        }
        return projectToCreate;
    }

    public static void refresh(IProject project) throws CoreException, InterruptedException {
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, null);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, null);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, null);
    }
}

