/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.custom.core;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.infra.browser.custom.core.Activator;
import org.eclipse.gmt.modisco.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.gmt.modisco.infra.common.core.internal.builder.IModiscoBuilder;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationsBuilder
implements IModiscoBuilder {
    protected static final String FILE_EXTENSION = "uiCustom";

    public IProject[] build(IncrementalProjectBuilder builder, int kind, Map<?, ?> args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(builder);
        } else {
            IProject project = builder.getProject();
            IResourceDelta delta = builder.getDelta(project);
            if (delta == null) {
                this.fullBuild(builder);
            } else {
                this.incrementalBuild(builder, delta);
            }
        }
        return null;
    }

    private void incrementalBuild(IncrementalProjectBuilder builder, IResourceDelta resourceDelta) {
        try {
            resourceDelta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    String fileExtension = resource.getFileExtension();
                    if (resource instanceof IFile && fileExtension != null && fileExtension.equals(CustomizationsBuilder.FILE_EXTENSION)) {
                        IFile file = (IFile)resource;
                        switch (delta.getKind()) {
                            case 1: 
                            case 8: {
                                CustomizationsCatalog.getInstance().addCustomization(file);
                                break;
                            }
                            case 2: 
                            case 16: {
                                CustomizationsCatalog.getInstance().removeCustomization(file);
                                break;
                            }
                            case 4: {
                                CustomizationsCatalog.getInstance().customizationChanged(file);
                            }
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (String)("Failed to build: " + builder.getProject()), (Plugin)Activator.getDefault());
        }
    }

    private void fullBuild(IncrementalProjectBuilder builder) {
        IProject project = builder.getProject();
        this.handleProject(project, false);
    }

    public void clean(IncrementalProjectBuilder builder, IProgressMonitor monitor) throws CoreException {
        IProject project = builder.getProject();
        this.handleProject(project, true);
    }

    private void handleProject(IProject project, final boolean clean) {
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    IFile file;
                    String fileExtension;
                    if (resource instanceof IFile && (fileExtension = (file = (IFile)resource).getFileExtension()) != null && fileExtension.equals(CustomizationsBuilder.FILE_EXTENSION)) {
                        if (clean) {
                            CustomizationsCatalog.getInstance().removeCustomization(file);
                        } else {
                            CustomizationsCatalog.getInstance().addCustomization(file);
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            String operation = clean ? "clean" : "build";
            MoDiscoLogger.logError((Throwable)e, (String)("Failed to " + operation + " " + project), (Plugin)Activator.getDefault());
        }
    }
}

