/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.actions.IBrowserActionBarContributor;
import org.eclipse.gmt.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.ImageUtils;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.FacetPackage;
import org.eclipse.gmt.modisco.infra.facet.FacetSet;
import org.eclipse.gmt.modisco.infra.facet.core.FacetSetCatalog;
import org.eclipse.gmt.modisco.infra.facet.ui.views.FacetSetContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class LoadFacetsAction
extends Action {
    private final IBrowserActionBarContributor browserActionBarContributor;
    private final LabelProvider labelProvider = new LabelProvider(){

        public String getText(Object element) {
            String label;
            if (element instanceof FacetSet) {
                FacetSet facetSet = (FacetSet)element;
                label = facetSet.getName();
            } else if (element instanceof Facet) {
                Facet facet = (Facet)element;
                label = facet.getName();
            } else {
                label = element == null ? "null" : element.getClass().getName();
            }
            return label;
        }

        public Image getImage(Object element) {
            return ImageUtils.getImage((Object)element);
        }
    };

    public LoadFacetsAction(IBrowserActionBarContributor browserActionBarContributor) {
        super(Messages.BrowserActionBarContributor_loadFacets, 1);
        this.browserActionBarContributor = browserActionBarContributor;
        this.setToolTipText(Messages.BrowserActionBarContributor_loadFacets);
        this.setImageDescriptor(ImageProvider.getInstance().getFacetIconDescriptor());
    }

    public void run() {
        EcoreBrowser browser = this.browserActionBarContributor.getBrowser();
        if (browser != null) {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    FacetSetCatalog.getSingleton().waitUntilBuilt();
                }
            });
            this.openDialog(browser);
        }
    }

    protected void openDialog(final EcoreBrowser browser) {
        FacetSetContentProvider treeContentProvider = new FacetSetContentProvider(FacetPackage.eINSTANCE.getFacet());
        LoadFacetsDialog dialog = new LoadFacetsDialog(null, (ILabelProvider)this.labelProvider, (ITreeContentProvider)treeContentProvider, browser.getMetamodelURI());
        dialog.setContainerMode(true);
        dialog.setHelpAvailable(false);
        dialog.setTitle(Messages.BrowserActionBarContributor_dialogTitle_LoadFacets);
        dialog.setMessage(Messages.BrowserActionBarContributor_chooseFacetToLoad);
        Collection facetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
        dialog.setInput(facetSets.toArray());
        dialog.setInitialElementSelections(new ArrayList(browser.getBrowserConfiguration().getAppearanceConfiguration().getLoadedFacets()));
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            browser.getBrowserConfiguration().getAppearanceConfiguration().clearFacets();
            final HashSet<Facet> facetsToLoad = new HashSet<Facet>();
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object resultElement = objectArray[n2];
                if (resultElement instanceof Facet) {
                    Facet facet = (Facet)resultElement;
                    facetsToLoad.add(facet);
                } else if (!(resultElement instanceof FacetSet)) {
                    throw new RuntimeException("Unexpected element type");
                }
                ++n2;
            }
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    for (Facet facetToLoad : facetsToLoad) {
                        browser.getBrowserConfiguration().getAppearanceConfiguration().loadFacet(facetToLoad);
                    }
                    if (facetsToLoad.size() > 0) {
                        browser.getBrowserConfiguration().getAppearanceConfiguration().getCustomizationEngine().loadCustomizations();
                    }
                    browser.getBrowserConfiguration().getInstancesForMetaclasses().buildDerivationTree();
                    browser.getBrowserConfiguration().getAppearanceConfiguration().touch();
                    browser.refreshDelayed(true);
                }
            });
        }
    }

    private class LoadFacetsDialog
    extends CheckedTreeSelectionDialog {
        private static final String LOAD_FACETS_DIALOG = "LoadFacetsDialog";
        private static final String EXPANDED_ELEMENTS = "expandedElements";

        public LoadFacetsDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, final String metamodelURI) {
            super(parent, labelProvider, contentProvider);
            EPackage metamodelPackage = EPackage.Registry.INSTANCE.getEPackage(metamodelURI);
            final Set referencedMetamodels = ModelUtils.computeReferencedPackages((EPackage)metamodelPackage);
            this.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof FacetSet) {
                        FacetSet facetSet = (FacetSet)element;
                        if (facetSet.getExtendedPackage() == null) {
                            return true;
                        }
                        String nsURI = facetSet.getExtendedPackage().getNsURI();
                        return nsURI != null && (nsURI.equals(metamodelURI) || referencedMetamodels.contains(facetSet.getExtendedPackage()));
                    }
                    return true;
                }
            });
        }

        public int open() {
            this.restoreExpandedElements();
            return super.open();
        }

        public boolean close() {
            this.saveExpandedElements();
            return super.close();
        }

        public void saveExpandedElements() {
            try {
                Object[] expandedElements;
                String filename = this.getSettingsFilename();
                DialogSettings settings = new DialogSettings(LOAD_FACETS_DIALOG);
                ArrayList<String> expandedFacetSets = new ArrayList<String>();
                Object[] objectArray = expandedElements = this.getTreeViewer().getExpandedElements();
                int n = expandedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object expandedElement = objectArray[n2];
                    if (expandedElement instanceof FacetSet) {
                        FacetSet facetSet = (FacetSet)expandedElement;
                        expandedFacetSets.add(facetSet.getName());
                    }
                    ++n2;
                }
                String[] array = expandedFacetSets.toArray(new String[expandedFacetSets.size()]);
                settings.put(EXPANDED_ELEMENTS, array);
                settings.save(filename);
            }
            catch (Exception e) {
                MoDiscoBrowserPlugin.logException(e);
            }
        }

        private String getSettingsFilename() {
            IPath stateLocation = MoDiscoBrowserPlugin.getPlugin().getStateLocation();
            String filename = stateLocation.append(LOAD_FACETS_DIALOG).toOSString();
            return filename;
        }

        public void restoreExpandedElements() {
            try {
                String filename = this.getSettingsFilename();
                DialogSettings settings = new DialogSettings(LOAD_FACETS_DIALOG);
                if (new File(filename).isFile()) {
                    settings.load(filename);
                    String[] array = settings.getArray(EXPANDED_ELEMENTS);
                    Collection facetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
                    ArrayList<FacetSet> expandedFacetSets = new ArrayList<FacetSet>();
                    String[] stringArray = array;
                    int n = array.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String expandedFacetSetName = stringArray[n2];
                        for (FacetSet facetSet : facetSets) {
                            if (facetSet.getName() == null || !facetSet.getName().equals(expandedFacetSetName)) continue;
                            expandedFacetSets.add(facetSet);
                        }
                        ++n2;
                    }
                    this.setExpandedElements(expandedFacetSets.toArray());
                }
            }
            catch (Exception e) {
                MoDiscoBrowserPlugin.logException(e);
            }
        }
    }
}

