/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.queries.text;

import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.java.ParameterValueList;
import org.eclipse.gmt.modisco.java.MethodDeclaration;
import org.eclipse.gmt.modisco.java.SingleVariableDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMethodDeclarationText
implements IJavaModelQuery<MethodDeclaration, String> {
    public String evaluate(MethodDeclaration context, ParameterValueList parameterValues) throws ModelQueryExecutionException {
        StringBuilder completeMethodName = new StringBuilder();
        if (context.getModifier() != null && !context.getModifier().getVisibility().getName().equalsIgnoreCase("none")) {
            completeMethodName.append(context.getModifier().getVisibility().getName());
            completeMethodName.append(" ");
        }
        if (context.getName() != null) {
            completeMethodName.append(context.getName());
        }
        if (context.getParameters() != null) {
            completeMethodName.append("(");
            int i = 0;
            while (i < context.getParameters().size()) {
                SingleVariableDeclaration var = (SingleVariableDeclaration)context.getParameters().get(i);
                completeMethodName.append(var.getType().getType().getName()).append(" ").append(var.getName());
                if (i != context.getParameters().size() - 1) {
                    completeMethodName.append(", ");
                }
                ++i;
            }
            completeMethodName.append(")");
        }
        return completeMethodName.toString();
    }
}

