/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Grgoire Dup (Mia-Software) - initial API and implementation
 * 
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.ReportmodelFactory
 * @model kind="package"
 * @generated
 */
public interface ReportmodelPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "reportmodel"; //$NON-NLS-1$

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclispse.org/MoDisco/Java/benchmark/report"; //$NON-NLS-1$

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "reportmodel"; //$NON-NLS-1$

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ReportmodelPackage eINSTANCE = org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ReportmodelPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.BenchmarkImpl <em>Benchmark</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.BenchmarkImpl
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ReportmodelPackageImpl#getBenchmark()
	 * @generated
	 */
	int BENCHMARK = 0;

	/**
	 * The feature id for the '<em><b>Java Project Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BENCHMARK__JAVA_PROJECT_NAME = 0;

	/**
	 * The feature id for the '<em><b>Xmx</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BENCHMARK__XMX = 1;

	/**
	 * The feature id for the '<em><b>Configurations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BENCHMARK__CONFIGURATIONS = 2;

	/**
	 * The number of structural features of the '<em>Benchmark</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BENCHMARK_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ConfigurationImpl <em>Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ConfigurationImpl
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ReportmodelPackageImpl#getConfiguration()
	 * @generated
	 */
	int CONFIGURATION = 1;

	/**
	 * The feature id for the '<em><b>Dicovery Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION__DICOVERY_DATE = 0;

	/**
	 * The feature id for the '<em><b>Algo Variante</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION__ALGO_VARIANTE = 1;

	/**
	 * The feature id for the '<em><b>Discoverer Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION__DISCOVERER_CLASS_NAME = 2;

	/**
	 * The feature id for the '<em><b>Save Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION__SAVE_TIME = 3;

	/**
	 * The feature id for the '<em><b>Total Execution Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION__TOTAL_EXECUTION_TIME = 4;

	/**
	 * The feature id for the '<em><b>Meta Model Variante</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION__META_MODEL_VARIANTE = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION__NAME = 6;

	/**
	 * The feature id for the '<em><b>Max Used Memory</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION__MAX_USED_MEMORY = 7;

	/**
	 * The number of structural features of the '<em>Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONFIGURATION_FEATURE_COUNT = 8;

	/**
	 * The meta object id for the '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.CDOConfigurationImpl <em>CDO Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.CDOConfigurationImpl
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ReportmodelPackageImpl#getCDOConfiguration()
	 * @generated
	 */
	int CDO_CONFIGURATION = 2;

	/**
	 * The feature id for the '<em><b>Dicovery Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CDO_CONFIGURATION__DICOVERY_DATE = CONFIGURATION__DICOVERY_DATE;

	/**
	 * The feature id for the '<em><b>Algo Variante</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CDO_CONFIGURATION__ALGO_VARIANTE = CONFIGURATION__ALGO_VARIANTE;

	/**
	 * The feature id for the '<em><b>Discoverer Class Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CDO_CONFIGURATION__DISCOVERER_CLASS_NAME = CONFIGURATION__DISCOVERER_CLASS_NAME;

	/**
	 * The feature id for the '<em><b>Save Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CDO_CONFIGURATION__SAVE_TIME = CONFIGURATION__SAVE_TIME;

	/**
	 * The feature id for the '<em><b>Total Execution Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CDO_CONFIGURATION__TOTAL_EXECUTION_TIME = CONFIGURATION__TOTAL_EXECUTION_TIME;

	/**
	 * The feature id for the '<em><b>Meta Model Variante</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CDO_CONFIGURATION__META_MODEL_VARIANTE = CONFIGURATION__META_MODEL_VARIANTE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CDO_CONFIGURATION__NAME = CONFIGURATION__NAME;

	/**
	 * The feature id for the '<em><b>Max Used Memory</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CDO_CONFIGURATION__MAX_USED_MEMORY = CONFIGURATION__MAX_USED_MEMORY;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CDO_CONFIGURATION__VERSION = CONFIGURATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Revised Lru Capacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CDO_CONFIGURATION__REVISED_LRU_CAPACITY = CONFIGURATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Cache Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CDO_CONFIGURATION__CACHE_TYPE = CONFIGURATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Server Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CDO_CONFIGURATION__SERVER_DESCRIPTION = CONFIGURATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Current Lru Capacity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CDO_CONFIGURATION__CURRENT_LRU_CAPACITY = CONFIGURATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Init Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CDO_CONFIGURATION__INIT_TIME = CONFIGURATION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>CDO Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CDO_CONFIGURATION_FEATURE_COUNT = CONFIGURATION_FEATURE_COUNT + 6;

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Benchmark <em>Benchmark</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Benchmark</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Benchmark
	 * @generated
	 */
	EClass getBenchmark();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Benchmark#getJavaProjectName <em>Java Project Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Java Project Name</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Benchmark#getJavaProjectName()
	 * @see #getBenchmark()
	 * @generated
	 */
	EAttribute getBenchmark_JavaProjectName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Benchmark#getXmx <em>Xmx</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Xmx</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Benchmark#getXmx()
	 * @see #getBenchmark()
	 * @generated
	 */
	EAttribute getBenchmark_Xmx();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Benchmark#getConfigurations <em>Configurations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Configurations</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Benchmark#getConfigurations()
	 * @see #getBenchmark()
	 * @generated
	 */
	EReference getBenchmark_Configurations();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration <em>Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Configuration</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration
	 * @generated
	 */
	EClass getConfiguration();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration#getDicoveryDate <em>Dicovery Date</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Dicovery Date</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration#getDicoveryDate()
	 * @see #getConfiguration()
	 * @generated
	 */
	EAttribute getConfiguration_DicoveryDate();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration#getAlgoVariante <em>Algo Variante</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Algo Variante</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration#getAlgoVariante()
	 * @see #getConfiguration()
	 * @generated
	 */
	EAttribute getConfiguration_AlgoVariante();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration#getDiscovererClassName <em>Discoverer Class Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Discoverer Class Name</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration#getDiscovererClassName()
	 * @see #getConfiguration()
	 * @generated
	 */
	EAttribute getConfiguration_DiscovererClassName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration#getSaveTime <em>Save Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Save Time</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration#getSaveTime()
	 * @see #getConfiguration()
	 * @generated
	 */
	EAttribute getConfiguration_SaveTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration#getTotalExecutionTime <em>Total Execution Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Execution Time</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration#getTotalExecutionTime()
	 * @see #getConfiguration()
	 * @generated
	 */
	EAttribute getConfiguration_TotalExecutionTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration#getMetaModelVariante <em>Meta Model Variante</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Meta Model Variante</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration#getMetaModelVariante()
	 * @see #getConfiguration()
	 * @generated
	 */
	EAttribute getConfiguration_MetaModelVariante();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration#getName()
	 * @see #getConfiguration()
	 * @generated
	 */
	EAttribute getConfiguration_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration#getMaxUsedMemory <em>Max Used Memory</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max Used Memory</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration#getMaxUsedMemory()
	 * @see #getConfiguration()
	 * @generated
	 */
	EAttribute getConfiguration_MaxUsedMemory();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.CDOConfiguration <em>CDO Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CDO Configuration</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.CDOConfiguration
	 * @generated
	 */
	EClass getCDOConfiguration();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.CDOConfiguration#getVersion <em>Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Version</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.CDOConfiguration#getVersion()
	 * @see #getCDOConfiguration()
	 * @generated
	 */
	EAttribute getCDOConfiguration_Version();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.CDOConfiguration#getRevisedLruCapacity <em>Revised Lru Capacity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Revised Lru Capacity</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.CDOConfiguration#getRevisedLruCapacity()
	 * @see #getCDOConfiguration()
	 * @generated
	 */
	EAttribute getCDOConfiguration_RevisedLruCapacity();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.CDOConfiguration#getCacheType <em>Cache Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cache Type</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.CDOConfiguration#getCacheType()
	 * @see #getCDOConfiguration()
	 * @generated
	 */
	EAttribute getCDOConfiguration_CacheType();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.CDOConfiguration#getServerDescription <em>Server Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Server Description</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.CDOConfiguration#getServerDescription()
	 * @see #getCDOConfiguration()
	 * @generated
	 */
	EAttribute getCDOConfiguration_ServerDescription();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.CDOConfiguration#getCurrentLruCapacity <em>Current Lru Capacity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Current Lru Capacity</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.CDOConfiguration#getCurrentLruCapacity()
	 * @see #getCDOConfiguration()
	 * @generated
	 */
	EAttribute getCDOConfiguration_CurrentLruCapacity();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.CDOConfiguration#getInitTime <em>Init Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Init Time</em>'.
	 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.CDOConfiguration#getInitTime()
	 * @see #getCDOConfiguration()
	 * @generated
	 */
	EAttribute getCDOConfiguration_InitTime();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ReportmodelFactory getReportmodelFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.BenchmarkImpl <em>Benchmark</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.BenchmarkImpl
		 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ReportmodelPackageImpl#getBenchmark()
		 * @generated
		 */
		EClass BENCHMARK = eINSTANCE.getBenchmark();

		/**
		 * The meta object literal for the '<em><b>Java Project Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BENCHMARK__JAVA_PROJECT_NAME = eINSTANCE.getBenchmark_JavaProjectName();

		/**
		 * The meta object literal for the '<em><b>Xmx</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BENCHMARK__XMX = eINSTANCE.getBenchmark_Xmx();

		/**
		 * The meta object literal for the '<em><b>Configurations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BENCHMARK__CONFIGURATIONS = eINSTANCE.getBenchmark_Configurations();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ConfigurationImpl <em>Configuration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ConfigurationImpl
		 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ReportmodelPackageImpl#getConfiguration()
		 * @generated
		 */
		EClass CONFIGURATION = eINSTANCE.getConfiguration();

		/**
		 * The meta object literal for the '<em><b>Dicovery Date</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONFIGURATION__DICOVERY_DATE = eINSTANCE.getConfiguration_DicoveryDate();

		/**
		 * The meta object literal for the '<em><b>Algo Variante</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONFIGURATION__ALGO_VARIANTE = eINSTANCE.getConfiguration_AlgoVariante();

		/**
		 * The meta object literal for the '<em><b>Discoverer Class Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONFIGURATION__DISCOVERER_CLASS_NAME = eINSTANCE.getConfiguration_DiscovererClassName();

		/**
		 * The meta object literal for the '<em><b>Save Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONFIGURATION__SAVE_TIME = eINSTANCE.getConfiguration_SaveTime();

		/**
		 * The meta object literal for the '<em><b>Total Execution Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONFIGURATION__TOTAL_EXECUTION_TIME = eINSTANCE.getConfiguration_TotalExecutionTime();

		/**
		 * The meta object literal for the '<em><b>Meta Model Variante</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONFIGURATION__META_MODEL_VARIANTE = eINSTANCE.getConfiguration_MetaModelVariante();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONFIGURATION__NAME = eINSTANCE.getConfiguration_Name();

		/**
		 * The meta object literal for the '<em><b>Max Used Memory</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONFIGURATION__MAX_USED_MEMORY = eINSTANCE.getConfiguration_MaxUsedMemory();

		/**
		 * The meta object literal for the '{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.CDOConfigurationImpl <em>CDO Configuration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.CDOConfigurationImpl
		 * @see org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.ReportmodelPackageImpl#getCDOConfiguration()
		 * @generated
		 */
		EClass CDO_CONFIGURATION = eINSTANCE.getCDOConfiguration();

		/**
		 * The meta object literal for the '<em><b>Version</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CDO_CONFIGURATION__VERSION = eINSTANCE.getCDOConfiguration_Version();

		/**
		 * The meta object literal for the '<em><b>Revised Lru Capacity</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CDO_CONFIGURATION__REVISED_LRU_CAPACITY = eINSTANCE.getCDOConfiguration_RevisedLruCapacity();

		/**
		 * The meta object literal for the '<em><b>Cache Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CDO_CONFIGURATION__CACHE_TYPE = eINSTANCE.getCDOConfiguration_CacheType();

		/**
		 * The meta object literal for the '<em><b>Server Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CDO_CONFIGURATION__SERVER_DESCRIPTION = eINSTANCE.getCDOConfiguration_ServerDescription();

		/**
		 * The meta object literal for the '<em><b>Current Lru Capacity</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CDO_CONFIGURATION__CURRENT_LRU_CAPACITY = eINSTANCE.getCDOConfiguration_CurrentLruCapacity();

		/**
		 * The meta object literal for the '<em><b>Init Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CDO_CONFIGURATION__INIT_TIME = eINSTANCE.getCDOConfiguration_InitTime();

	}

} //ReportmodelPackage
