/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.kdm.browser.extension.source;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.gmt.modisco.kdm.browser.extension.Activator;
import org.eclipse.gmt.modisco.omg.kdm.source.*;

/**
 * @generated
 */
public class IconProvider implements org.eclipse.gmt.modisco.infra.browser.uicore.extensions.icons.IconProvider {
//	Start of user code Image attribute for SourceFile		
	private Image SourceFileImage = this.createImage("source_attach_attrib.gif");
//	End of user code
//	Start of user code Image attribute for Image		
	private Image ImageImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Configuration		
	private Image ConfigurationImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for ResourceDescription		
	private Image ResourceDescriptionImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for BinaryFile		
	private Image BinaryFileImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for ExecutableFile		
	private Image ExecutableFileImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Directory		
	private Image DirectoryImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Project		
	private Image ProjectImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for InventoryModel		
	private Image InventoryModelImage = this.createImage("folder.gif");
//	End of user code
//	Start of user code Image attribute for InventoryItem		
	private Image InventoryItemImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for InventoryContainer		
	private Image InventoryContainerImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for DependsOn		
	private Image DependsOnImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for InventoryElement		
	private Image InventoryElementImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for InventoryRelationship		
	private Image InventoryRelationshipImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for AbstractInventoryElement		
	private Image AbstractInventoryElementImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for AbstractInventoryRelationship		
	private Image AbstractInventoryRelationshipImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for SourceRef		
	private Image SourceRefImage = this.createImage("ExchangeSourceAndTarget.gif");
//	End of user code
//	Start of user code Image attribute for SourceRegion		
	private Image SourceRegionImage = this.createImage("source.gif");
//	End of user code
	

	/**
	 * @generated
	 */	
	public IconProvider() {
	}

	/**
	 * @return the icon that must be displayed for the given {@link EObject}, or <code>null</code>
	 *         to keep the default icon, which can be empty, or let another {@link IconProvider}
	 *         provide the icon
	 * 
	 */
	public Image getIcon(EObject eObject) {
    Image result = null;
    if (eObject instanceof SourceFile) {
      result = this.SourceFileImage;
    } else
    if (eObject instanceof org.eclipse.gmt.modisco.omg.kdm.source.Image) {
      result = this.ImageImage;
    } else
    if (eObject instanceof Configuration) {
      result = this.ConfigurationImage;
    } else
    if (eObject instanceof ResourceDescription) {
      result = this.ResourceDescriptionImage;
    } else
    if (eObject instanceof BinaryFile) {
      result = this.BinaryFileImage;
    } else
    if (eObject instanceof ExecutableFile) {
      result = this.ExecutableFileImage;
    } else
    if (eObject instanceof Directory) {
      result = this.DirectoryImage;
    } else
    if (eObject instanceof Project) {
      result = this.ProjectImage;
    } else
    if (eObject instanceof InventoryModel) {
      result = this.InventoryModelImage;
    } else
    if (eObject instanceof InventoryItem) {
      result = this.InventoryItemImage;
    } else
    if (eObject instanceof InventoryContainer) {
      result = this.InventoryContainerImage;
    } else
    if (eObject instanceof DependsOn) {
      result = this.DependsOnImage;
    } else
    if (eObject instanceof InventoryElement) {
      result = this.InventoryElementImage;
    } else
    if (eObject instanceof InventoryRelationship) {
      result = this.InventoryRelationshipImage;
    } else
    if (eObject instanceof AbstractInventoryElement) {
      result = this.AbstractInventoryElementImage;
    } else
    if (eObject instanceof AbstractInventoryRelationship) {
      result = this.AbstractInventoryRelationshipImage;
    } else
    if (eObject instanceof SourceRef) {
      result = this.SourceRefImage;
    } else
    if (eObject instanceof SourceRegion) {
      result = this.SourceRegionImage;
    } 

    return result;

  }

	/**
	 * Create an image from a resource in the bundle (plugin)
	 * 
	 * @param resourcePath
	 *            the path of the resource (in the bundle)
	 * @return the image
	 * @generated
	 */
	private Image createImage(String resourcePath) {
    Image result = null;
    if ((resourcePath != null) && (resourcePath.length() > 0)) {
      ImageDescriptor descriptor = Activator.getImageDescriptor("icons/kdm/source/" + resourcePath);
      if (descriptor != null) {
        result = descriptor.createImage();
      }
    }
    return result;
  }

}

