/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.ui;

import java.util.HashMap;
import java.util.Map.Entry;

import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constants;
import org.eclipse.gmt.modisco.workflow.DriverInterface;
import org.eclipse.gmt.modisco.workflow.controller.ControllerDriverPage;
import org.eclipse.gmt.modisco.workflow.ui.common.Common;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/**
 * This class defines a page of Wizard. This page allows to list all of drivers
 * connected on MoDiscoWorkflow
 * 
 * @author Nicolas Payneau
 */
public class ListDriversPage extends WizardPage {
	private Table driversTable;
	private ControllerDriverPage controller;
	private Composite container;
	private HashMap<TableItem, DriverInterface> mapItemDriver;

	/**
	 * Class constructor
	 * 
	 * @param pageName
	 *            Name of the wizard page
	 * @param controller
	 *            The controller managing the display
	 */
	protected ListDriversPage(final String pageName, final ControllerDriverPage controller) {
		super(pageName, pageName, null);
		this.setImageDescriptor(Activator
				.getImageDescriptor(Constants.pathBigImage));
		this.controller = controller;
		this.setDescription(Messages.ListDriversPage_0);
		this.mapItemDriver = new HashMap<TableItem, DriverInterface>();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets
	 * .Composite)
	 */
	public void createControl(final Composite parent) {
		this.container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		this.container.setLayout(layout);
		layout.numColumns = 3;
		layout.verticalSpacing = 9;

		GridData gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData.verticalAlignment = org.eclipse.swt.layout.GridData.FILL;
		gridData.grabExcessVerticalSpace = true;
		this.driversTable = new Table(this.container, SWT.BORDER | SWT.V_SCROLL);
		this.driversTable.setLayoutData(gridData);
		this.driversTable.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(final SelectionEvent e) {
			}

			public void widgetSelected(final SelectionEvent e) {
				ListDriversPage.this.getController()
						.refreshDriverPage(ListDriversPage.this.getMapItemDriver()
								.get(
										ListDriversPage.this.getDriversTable()
												.getItem(ListDriversPage.this.getDriversTable()
														.getSelectionIndex()))
								.getTypeLaunchConfig());
				setErrorMessage(null);
				setMessage(Messages.ListDriversPage_1);
				setPageComplete(true);
			}
		});
		loadDriver();
		setControl(this.container);
		this.container.layout();
	}

	/**
	 * Load all the drivers defined in the table
	 */
	private void loadDriver() {
		boolean oneDriver = false;
		for (Entry<String, DriverInterface> entry : this.controller
				.getMapNameDriver().entrySet()) {
			TableItem item = new TableItem(this.driversTable, SWT.NULL);
			item.setText(entry.getKey());
			item.setImage(Common.getInstance().retrieveImageDriver(
					entry.getValue().getTypeLaunchConfig()));
			oneDriver = true;
			this.mapItemDriver.put(item, entry.getValue());
		}
		if (oneDriver) {
			setErrorMessage(Messages.ListDriversPage_2);
		} else {
			setErrorMessage(Messages.ListDriversPage_3);
		}
		setPageComplete(false);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.DialogPage#setVisible(boolean)
	 */
	@Override
	public void setVisible(final boolean visible) {
		if (visible) {
			this.getShell().setSize(400, 400);
			this.getShell().setLocation(
					Common.getInstance().centerShell(Display.getDefault(),
							this.getShell()));
		}
		super.setVisible(visible);
	}

	public void setController(final ControllerDriverPage controller) {
		this.controller = controller;
	}

	public ControllerDriverPage getController() {
		return this.controller;
	}

	public void setMapItemDriver(final HashMap<TableItem, DriverInterface> mapItemDriver) {
		this.mapItemDriver = mapItemDriver;
	}

	public HashMap<TableItem, DriverInterface> getMapItemDriver() {
		return this.mapItemDriver;
	}

	public void setDriversTable(final Table driversTable) {
		this.driversTable = driversTable;
	}

	public Table getDriversTable() {
		return this.driversTable;
	}
}
