/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constants;
import org.eclipse.gmt.modisco.workflow.controller.ControllerDriverPage;
import org.eclipse.gmt.modisco.workflow.controller.ControllerWorkflowTransformation;
import org.eclipse.gmt.modisco.workflow.ui.DriverPage;
import org.eclipse.gmt.modisco.workflow.ui.ListDriversPage;
import org.eclipse.gmt.modisco.workflow.ui.LoadLauncherPage;
import org.eclipse.gmt.modisco.workflow.ui.Messages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.TableItem;

public class DriversWizard
extends Wizard {
    private DriverPage driver;
    private LoadLauncherPage loadLauncher;
    private ControllerDriverPage controllerDriverpage;
    private ControllerWorkflowTransformation controllerWorkflow;
    private Constants mode;

    public DriversWizard(ControllerWorkflowTransformation controllerWorkflow, ControllerDriverPage controllerDriverpage, Constants mode) {
        this.controllerWorkflow = controllerWorkflow;
        this.mode = mode;
        this.controllerDriverpage = controllerDriverpage;
        if (mode.equals((Object)Constants.addMode)) {
            this.setWindowTitle(Messages.DriversWizard_0);
        } else if (mode.equals((Object)Constants.editMode)) {
            this.setWindowTitle(Messages.DriversWizard_1);
        } else {
            this.setWindowTitle(Messages.DriversWizard_2);
        }
    }

    public final void addPages() {
        this.driver = new DriverPage(Messages.DriversWizard_3, this.mode, this.controllerWorkflow.getGroup());
        this.driver.setController(this.controllerDriverpage);
        if (this.mode.equals((Object)Constants.addMode)) {
            this.addPage((IWizardPage)new ListDriversPage(Messages.DriversWizard_4, this.controllerDriverpage));
        }
        if (this.mode.equals((Object)Constants.loadMode)) {
            this.loadLauncher = new LoadLauncherPage(Messages.DriversWizard_5, this.controllerDriverpage);
            this.addPage((IWizardPage)this.loadLauncher);
        }
        if (!this.mode.equals((Object)Constants.loadMode)) {
            this.addPage((IWizardPage)this.driver);
        }
    }

    public boolean performFinish() {
        if (this.mode.equals((Object)Constants.addMode)) {
            this.controllerDriverpage.launchPerformFinish();
            this.controllerWorkflow.addElement(this.controllerDriverpage.getCurrentDriver().getTypeLaunchConfig(), -1, this.driver.getTransformationName(), true);
        } else if (this.mode.equals((Object)Constants.editMode)) {
            this.controllerDriverpage.launchPerformFinish();
            this.controllerWorkflow.performFinishEditTransformation(this.driver.getTransformationName());
        } else if (this.mode.equals((Object)Constants.loadMode)) {
            try {
                TableItem[] tableItemArray = this.loadLauncher.getItemsSelected();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    ILaunchConfiguration launchConfiguration = this.loadLauncher.getLaunchConfigurationMap().get(item);
                    this.controllerWorkflow.addElement(launchConfiguration.getType().getIdentifier(), -1, item.getText(), true);
                    ++n2;
                }
            }
            catch (CoreException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return true;
    }
}

