/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.uicore.internal.model;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.Activator;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.AppearanceConfiguration;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.customization.CustomizationEngine;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.BigListItem;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.util.ColorProvider;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.FacetReference;
import org.eclipse.gmt.modisco.infra.facet.FacetStructuralFeature;
import org.eclipse.gmt.modisco.infra.facet.Shortcut;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkItem
implements ITreeElement {
    private final EReference reference;
    private final EObject parent;
    private final ITreeElement treeParent;
    private final AppearanceConfiguration appearanceConfiguration;
    private int cachedChildrenModCount = -1;
    private List<?> cachedChildren = null;
    private int cachedChildrenElementsModCount = -1;
    private List<EObject> cachedChildrenElements = null;

    public LinkItem(EObject parent, ITreeElement treeParent, EReference reference, AppearanceConfiguration appearanceConfiguration) {
        this.reference = reference;
        this.parent = parent;
        this.treeParent = treeParent;
        this.appearanceConfiguration = appearanceConfiguration;
    }

    public EReference getReference() {
        return this.reference;
    }

    public int getCount() {
        return this.getChildrenElements().size();
    }

    @Override
    public String getText() {
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        String customizedLabel = customizationEngine.getReferenceLabel(this.facetOrParentClass(), this.reference.getName(), this.parent);
        String staticText = LinkItem.getStaticText(this.reference, this.appearanceConfiguration.isShowMultiplicity(), this.appearanceConfiguration.isShowOppositeLinks(), customizedLabel);
        String result = String.valueOf(staticText) + " (" + this.getCount() + ")";
        if (this.appearanceConfiguration.isShowTypeOfLinks()) {
            result = String.valueOf(result) + " [" + this.getReference().getEReferenceType().getName() + "]";
        }
        return result;
    }

    public static String getStaticText(EReference reference, boolean showMultiplicity, boolean showOpposite, String customizedName) {
        EReference oppositeRef;
        String multiplicity = "";
        if (showMultiplicity) {
            multiplicity = LinkItem.getMultiplicity(reference);
        }
        String opposite = "";
        if (showOpposite && (oppositeRef = reference.getEOpposite()) != null) {
            String oppositeMultiplicity = "";
            if (showMultiplicity) {
                oppositeMultiplicity = LinkItem.getMultiplicity(oppositeRef);
            }
            opposite = " <-> " + oppositeRef.getName() + oppositeMultiplicity;
        }
        String prefix = reference.isDerived() ? "/" : "";
        String referenceName = customizedName != null ? customizedName : reference.getName();
        return String.valueOf(prefix) + referenceName + multiplicity + opposite;
    }

    public static String getMultiplicity(EReference reference) {
        String multLow = reference.isRequired() ? "1" : "0";
        String multHigh = reference.isMany() ? "*" : "1";
        return " [" + multLow + ".." + multHigh + "]";
    }

    @Override
    public Image getImage() {
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        Image customizedIcon = customizationEngine.getReferenceIcon(this.facetOrParentClass(), this.reference.getName(), this.parent);
        if (customizedIcon != null) {
            return customizedIcon;
        }
        return LinkItem.getImageFor(this.reference);
    }

    public static Image getImageFor(EReference reference) {
        if (reference instanceof FacetReference || reference instanceof Shortcut) {
            return ImageProvider.getInstance().getFacetLinkIcon();
        }
        EReference opposite = reference.getEOpposite();
        if (reference.isContainment()) {
            if (opposite == null) {
                return ImageProvider.getInstance().getUnidirectionalAggregIcon();
            }
            return ImageProvider.getInstance().getAggregIcon();
        }
        if (opposite != null && opposite.isContainment()) {
            return ImageProvider.getInstance().getInvAggregIcon();
        }
        if (opposite == null) {
            return ImageProvider.getInstance().getUnidirectionalLinkIcon();
        }
        return ImageProvider.getInstance().getLinkIcon();
    }

    public EObject getParent() {
        return this.parent;
    }

    @Override
    public ITreeElement getTreeParent() {
        return this.treeParent;
    }

    @Override
    public List<?> getChildren() {
        if (this.cachedChildren == null || this.cachedChildrenModCount != this.appearanceConfiguration.getModCount()) {
            List<EObject> childrenList = this.getChildrenElements();
            if (childrenList.isEmpty()) {
                this.cachedChildren = Collections.emptyList();
            } else {
                boolean ordered = this.reference.isMany() && this.reference.isOrdered();
                this.cachedChildren = BigListItem.splitElements(this, this.parent, childrenList, this.appearanceConfiguration, ordered);
            }
            this.cachedChildrenModCount = this.appearanceConfiguration.getModCount();
        }
        return this.cachedChildren;
    }

    @Override
    public boolean hasChildren() {
        return this.getChildrenElements().size() > 0;
    }

    public List<EObject> getChildrenElements() {
        if (this.cachedChildrenElements == null || this.cachedChildrenElementsModCount != this.appearanceConfiguration.getModCount()) {
            CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
            if (this.reference.isMany()) {
                List childrenList = (List)this.localEGet();
                this.cachedChildrenElements = childrenList != null ? customizationEngine.filterVisible(childrenList) : Collections.emptyList();
            } else {
                EObject element = (EObject)this.localEGet();
                if (element != null && !customizationEngine.isTypeVisible(element.eClass(), this.parent)) {
                    element = null;
                }
                this.cachedChildrenElements = element == null ? Collections.emptyList() : Collections.singletonList(element);
            }
            this.cachedChildrenElementsModCount = this.appearanceConfiguration.getModCount();
        }
        return this.cachedChildrenElements;
    }

    private Object localEGet() {
        Object result;
        if (this.reference instanceof FacetStructuralFeature || this.reference instanceof Shortcut) {
            try {
                result = this.appearanceConfiguration.getFacetContext().get(this.parent, (EStructuralFeature)this.reference);
            }
            catch (Exception e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                result = null;
            }
        } else {
            result = this.parent.eGet((EStructuralFeature)this.reference);
        }
        return result;
    }

    @Override
    public Color getForeground() {
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        Color color = customizationEngine.getReferenceColor(this.facetOrParentClass(), this.reference.getName(), this.parent);
        if (color != null) {
            return color;
        }
        if (this.getCount() == 0) {
            return ColorProvider.getInstance().getGray();
        }
        return null;
    }

    @Override
    public Color getBackground() {
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        Color color = customizationEngine.getReferenceBackgroundColor(this.facetOrParentClass(), this.reference.getName(), this.parent);
        if (color != null) {
            return color;
        }
        return null;
    }

    @Override
    public Font getFont() {
        CustomizationEngine customizationEngine = this.appearanceConfiguration.getCustomizationEngine();
        Font customizedFont = customizationEngine.getCustomizedReferenceFont(this.facetOrParentClass(), this.reference.getName(), this.appearanceConfiguration.getCustomFont(), this.parent);
        if (customizedFont != null) {
            return customizedFont;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LinkItem) {
            LinkItem other = (LinkItem)obj;
            return this.reference.equals(other.reference) && this.parent.equals(other.parent);
        }
        return false;
    }

    public int hashCode() {
        return this.reference.hashCode() * 47 + this.parent.hashCode() + 13;
    }

    public EClass facetOrParentClass() {
        if (this.reference instanceof FacetReference || this.reference instanceof Shortcut) {
            Facet facet = (Facet)this.reference.eContainer();
            return facet;
        }
        return this.parent.eClass();
    }
}

