/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.actions.IBrowserActionBarContributor;
import org.eclipse.gmt.modisco.infra.browser.custom.MetamodelView;
import org.eclipse.gmt.modisco.infra.browser.custom.TypeView;
import org.eclipse.gmt.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.gmt.modisco.infra.browser.ui.LoadCustomizationsDialog;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.FacetSet;
import org.eclipse.gmt.modisco.infra.facet.core.FacetSetCatalog;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadCustomizationsAction
extends Action {
    private final IBrowserActionBarContributor browserActionBarContributor;

    public LoadCustomizationsAction(IBrowserActionBarContributor browserActionBarContributor) {
        super(Messages.BrowserActionBarContributor_loadCustomization, 1);
        this.setToolTipText(Messages.BrowserActionBarContributor_loadCustomization);
        this.setImageDescriptor(ImageProvider.getInstance().getAddUiCustomIconDescriptor());
        this.browserActionBarContributor = browserActionBarContributor;
    }

    public void run() {
        EcoreBrowser browser = this.browserActionBarContributor.getBrowser();
        if (browser != null) {
            List registeredCustomizations = browser.getBrowserConfiguration().getAppearanceConfiguration().getCustomizationEngine().getRegisteredCustomizations();
            LoadCustomizationsDialog loadCustomizationsDialog = new LoadCustomizationsDialog(browser.getSite().getShell(), registeredCustomizations, browser.getMetamodelURI());
            if (loadCustomizationsDialog.open() == 0) {
                try {
                    List<MetamodelView> selectedCustomizations = loadCustomizationsDialog.getSelectedCustomizations();
                    if (loadCustomizationsDialog.isLoadRequiredFacetsSelected()) {
                        this.loadFacetsForCustomizations(selectedCustomizations, browser);
                    }
                    browser.loadCustomizations(selectedCustomizations);
                }
                catch (Exception e) {
                    MoDiscoBrowserPlugin.logException(Messages.BrowserActionBarContributor_loadingCustomizationFailed, e);
                }
            }
        }
    }

    private void loadFacetsForCustomizations(List<MetamodelView> customizations, EcoreBrowser browser) {
        HashSet<Facet> referencedFacets = new HashSet<Facet>();
        Collection facetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
        for (MetamodelView customization : customizations) {
            String metamodelURI = customization.getMetamodelURI();
            FacetSet customizedFacetSet = null;
            if (metamodelURI != null) {
                for (FacetSet facetSet : facetSets) {
                    if (!metamodelURI.equals(facetSet.getNsURI())) continue;
                    customizedFacetSet = facetSet;
                    break;
                }
            }
            if (customizedFacetSet == null) continue;
            EList types = customization.getTypes();
            for (TypeView typeView : types) {
                String metaclassName = typeView.getMetaclassName();
                Facet facet = this.findFacetWithFullyQualifiedName(metaclassName, customizedFacetSet);
                if (facet != null) {
                    referencedFacets.add(facet);
                    continue;
                }
                MoDiscoBrowserPlugin.logWarning(NLS.bind((String)Messages.BrowserActionBarContributor_missingRequiredFacet, (Object[])new Object[]{metaclassName, customizedFacetSet.getName(), customization.getName()}));
            }
            for (Facet referencedFacet : referencedFacets) {
                browser.getBrowserConfiguration().getAppearanceConfiguration().loadFacet(referencedFacet);
            }
        }
        browser.getBrowserConfiguration().getInstancesForMetaclasses().buildDerivationTree();
        browser.getBrowserConfiguration().getAppearanceConfiguration().touch();
        browser.refreshDelayed(true);
    }

    private Facet findFacetWithFullyQualifiedName(String metaclassName, FacetSet customizedFacetSet) {
        EList facets = customizedFacetSet.getFacets();
        for (Facet facet : facets) {
            String facetName = ModelUtils.getMetaclassQualifiedName((EClassifier)facet);
            if (!metaclassName.equals(facetName)) continue;
            return facet;
        }
        return null;
    }
}

