/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterDirectionKind;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterImpl;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.actions.DefaultDiscoverer;
import org.eclipse.gmt.modisco.java.actions.DiscoverJavaModelFromJavaProject;
import org.eclipse.gmt.modisco.java.actions.Messages;
import org.eclipse.gmt.modisco.java.actions.TranslateJavaModelToKdm;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.m2m.atl.core.ATLCoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverKdmModelFromJavaProject
extends DefaultDiscoverer {
    public static final String KDM_FILE_EXTENSION = "kdm";
    private static List<DiscoveryParameter> parametersKeys = null;
    public static final DiscoveryParameter PARAMETERS_BEAN = new DiscoveryParameterImpl("PARAMETERS_BEAN", DiscoveryParameterDirectionKind.in, DiscoveryParameter.class, false);

    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        HashMap<Object, Object> javaDiscParams = null;
        javaDiscParams = parameters != null ? new HashMap<DiscoveryParameter, Object>(parameters) : new HashMap();
        javaDiscParams.put(DefaultDiscoverer.PARAMETER_BROWSE_RESULT, false);
        DiscoverJavaModelFromJavaProject javaDiscoverer = new DiscoverJavaModelFromJavaProject();
        javaDiscoverer.discoverElement(source, javaDiscParams);
        Resource javaModelResource = (Resource)javaDiscParams.get(DefaultDiscoverer.PARAMETER_TARGET_RESOURCE);
        Resource kdmModelResource = null;
        if (javaModelResource != null) {
            try {
                URI javaModelURI = javaModelResource.getURI();
                URI kdmModelUri = javaModelURI.trimFileExtension().appendFileExtension(KDM_FILE_EXTENSION);
                TranslateJavaModelToKdm kdmTranslater = new TranslateJavaModelToKdm();
                kdmModelResource = kdmTranslater.getKDMModelFromJavaModelWithCustomTransformation(javaModelURI, kdmModelUri);
                if (kdmModelResource != null) {
                    String kdmFileString = kdmModelUri.toFileString();
                    IFile kdmFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(kdmFileString));
                    kdmFile.getProject().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    this.openEditor(kdmFile, parameters);
                    if (parameters != null) {
                        parameters.put(DefaultDiscoverer.PARAMETER_TARGET_RESOURCE, kdmModelResource);
                    }
                }
            }
            catch (ATLCoreException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            }
            catch (CoreException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            }
        }
    }

    public boolean isApplicableTo(Object source) {
        boolean result = false;
        if (source instanceof IJavaProject) {
            result = ((IJavaProject)source).getProject().isAccessible();
        } else if (source instanceof IProject) {
            IProject project = (IProject)source;
            try {
                if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                    result = true;
                }
            }
            catch (CoreException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            }
        }
        return result;
    }

    public String toString() {
        return Messages.DiscoverKdmModelFromJavaProject_title;
    }

    public List<DiscoveryParameter> getDiscovererParameters() {
        if (parametersKeys == null) {
            parametersKeys = new ArrayList<DiscoveryParameter>();
            parametersKeys.add(PARAMETER_SILENT_MODE);
            parametersKeys.add(PARAMETER_TARGET_RESOURCE);
            parametersKeys.add(PARAMETERS_BEAN);
        }
        return parametersKeys;
    }
}

