/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire Dupe (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.java.discoverer.benchmark.cdo.server;

import java.util.HashMap;
import java.util.Map;

import javax.sql.DataSource;

import org.apache.derby.jdbc.EmbeddedDataSource;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.gmt.modisco.infra.common.cdo.server.AbstractCDOServer;
import org.eclipse.net4j.db.IDBAdapter;

public class H2CDOServer extends AbstractCDOServer {

	@Override
	protected DataSource getDataSource(final String dbName) {
		EmbeddedDataSource dataSource = new EmbeddedDataSource();
		String javaIoTmpdirStr = System.getProperty("java.io.tmpdir"); //$NON-NLS-1$
		dataSource.setDatabaseName(javaIoTmpdirStr + dbName);
		dataSource.setCreateDatabase("create"); //$NON-NLS-1$
		return dataSource;
	}

	@Override
	protected Map<String, String> getProps() {
		Map<String, String> props = new HashMap<String, String>();
		props.put(IRepository.Props.OVERRIDE_UUID, "gastro"); //$NON-NLS-1$
		props.put(IRepository.Props.SUPPORTING_AUDITS, Boolean.TRUE.toString());
		// props.put(IRepository.Props.VERIFYING_REVISIONS, Boolean.FALSE
		// .toString());
		props.put(IRepository.Props.CURRENT_LRU_CAPACITY, Integer
				.toString(CURRENT_LRU_CAPACITY));
		props.put(IRepository.Props.REVISED_LRU_CAPACITY, Integer
				.toString(REVISED_LRU_CAPACITY));
		return props;
	}

	@Override
	protected IMappingStrategy getMappingStrategy() {
		IMappingStrategy mappingStrategy = CDODBUtil
				.createHorizontalMappingStrategy(true);
		return mappingStrategy;
	}

	public String getDescription() {
		return "H2, SUPPORTING_AUDITS"; //$NON-NLS-1$
	}

	@Override
	protected IDBAdapter getDBAdapter() {
		return null;
	}

	


}
