/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Grgoire Dup (Mia-Software)
 *    Romain Dervaux (Mia-Software)
 *******************************************************************************/

package org.eclipse.gmt.modisco.java.discoverer.benchmark.emfstat;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.actions.DefaultDiscoverer;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.Activator;
import org.eclipse.gmt.modisco.java.internal.actions.DiscoverSimpleJavaModelFromJavaProject;
import org.eclipse.gmt.modisco.java.io.java.JavaReader;
import org.eclipse.jdt.core.IJavaProject;

@SuppressWarnings("deprecation")
public class DiscoverJavaModelFromJavaProjectEMFStat extends
		DiscoverSimpleJavaModelFromJavaProject {

	private static final int MEGA_BYTES = 1024;
	private static final int BUFFER_SIZE = 10000;
	public static final String STORAGE_KIND = "STORAGE_KIND"; //$NON-NLS-1$
	public static final String JAVA_PROJECT_NAME = "JAVA_PROJECT_NAME"; //$NON-NLS-1$
	public static final String DISCOVERER_CLASS_NAME = "DISCOVERER_CLASS_NAME"; //$NON-NLS-1$
	public static final String DISCOVERY_DATE = "DISCOVERY_DATE"; //$NON-NLS-1$
	public static final String XMX = "XMX"; //$NON-NLS-1$
	public static final String MM_VARIANTE = "MM_VARIANTE"; //$NON-NLS-1$
	public static final String ALGO_VARIANTE = "ALGO_VARIANTE"; //$NON-NLS-1$

	private Statistics statistics;
	private IProject statProject;

	protected boolean getEnableValidation() {
		return true;
	}

	@Override
	public void discoverElement(final Object source,
			final Map<DiscoveryParameter, Object> parameters) {
		Map<DiscoveryParameter, Object> localParameters = new HashMap<DiscoveryParameter, Object>();
		localParameters.putAll(parameters);
		localParameters.put(DefaultDiscoverer.PARAMETER_BROWSE_RESULT,
				new Boolean(false));
		localParameters.put(DefaultDiscoverer.PARAMETER_SILENT_MODE,
				new Boolean(true));
		IJavaProject javaProject = (IJavaProject) source;
		this.setStatistics(this.getStatistics(javaProject));
		if (this.getStatistics() != null) {
			this.getStatistics().getProperties().put(
					DiscoverJavaModelFromJavaProjectEMFStat.JAVA_PROJECT_NAME,
					javaProject.getElementName());
			this
					.getStatistics()
					.getProperties()
					.put(
							DiscoverJavaModelFromJavaProjectEMFStat.DISCOVERER_CLASS_NAME,
							this.getClass().getName());
			this.getStatistics().getProperties().put(
					DiscoverJavaModelFromJavaProjectEMFStat.DISCOVERY_DATE,
					new Date().toString());
			this.getStatistics().getProperties().putAll(this.getProperties());
			this.getStatistics().begin();
		}
		super.discoverElement(source, localParameters);
		if (this.getStatistics() != null) {
			this.getStatistics().end();
		}
	}

	protected Statistics getStatistics(final IJavaProject javaProject) {
		Statistics statisticsResult;
		if (this.statProject != null) {
			File projectFile = this.statProject.getLocation().toFile();
			statisticsResult = Statistics.getStatistics(javaProject
					.getElementName()
					+ "_" + System.currentTimeMillis(), projectFile); //$NON-NLS-1$
		} else {
			File projectFile = getDefaultStatProject(javaProject).getLocation()
					.toFile();
			statisticsResult = Statistics.getStatistics(javaProject
					.getElementName()
					+ "_" + System.currentTimeMillis(), projectFile); //$NON-NLS-1$
		}
		return statisticsResult;
	}

	private IProject getDefaultStatProject(final IJavaProject sourceProject) {
		IWorkspace ws = ResourcesPlugin.getWorkspace();
		IProject localStatProject = ws.getRoot().getProject(
				"statistics_" + System.currentTimeMillis() + "_" //$NON-NLS-1$ //$NON-NLS-2$
						+ sourceProject.getElementName());
		try {
			localStatProject.create(new NullProgressMonitor());
			localStatProject.open(new NullProgressMonitor());
		} catch (CoreException e) {
			IStatus status = new Status(IStatus.ERROR, JavaActivator.PLUGIN_ID,
					e.getMessage(), e);
			JavaActivator.getDefault().getLog().log(status);
			localStatProject = null;
		}
		return localStatProject;
	}

	@Override
	public void saveResource(final URI target, final IPath path,
			final Resource resource, final IProgressMonitor monitor)
			throws IOException {
		if (this.getStatistics() != null) {
			this.getStatistics().beginSave();
		}
		Map<Object, Object> optionMap = new HashMap<Object, Object>();
		optionMap.put(XMLResource.OPTION_FLUSH_THRESHOLD,
				DiscoverJavaModelFromJavaProjectEMFStat.BUFFER_SIZE);
		optionMap.put(XMLResource.OPTION_USE_FILE_BUFFER, true);
		monitor.subTask("Saving model"); //$NON-NLS-1$
		if (target != null) {
			resource.setURI(target);
		} else {
			URI uri = URI.createFileURI(path.toString());
			resource.setURI(uri);
		}
		resource.save(optionMap);
		if (this.getStatistics() != null) {
			this.getStatistics().endSave();
		}
	}

	@Override
	public Resource getResource(final String resourceName,
			final IJavaProject javaProject) {
		Status status = new Status(IStatus.INFO, Activator.PLUGIN_ID,
				"Resource name=" + javaProject.getElementName() + "_" //$NON-NLS-1$ //$NON-NLS-2$
						+ System.currentTimeMillis());
		Activator.getDefault().getLog().log(status);
		ResourceSet resourceSet = new ResourceSetImpl();
		Resource resource = resourceSet.createResource(URI.createURI("file:///" //$NON-NLS-1$
				+ javaProject.getProject().getLocation().toString() + "/" //$NON-NLS-1$
				+ resourceName + ".javaxmi")); //$NON-NLS-1$
		return resource;
	}

	protected Properties getProperties() {
		Properties properties = new Properties();
		properties.put(DiscoverJavaModelFromJavaProjectEMFStat.STORAGE_KIND,
				"XMI"); //$NON-NLS-1$
		properties.put(DiscoverJavaModelFromJavaProjectEMFStat.XMX, Runtime
				.getRuntime().maxMemory()
				/ DiscoverJavaModelFromJavaProjectEMFStat.MEGA_BYTES
				/ DiscoverJavaModelFromJavaProjectEMFStat.MEGA_BYTES + "Mo"); //$NON-NLS-1$
		return properties;
	}

	@Override
	protected JavaReader getJavaReader(final boolean isIncremental) {
		JavaReaderEMFStat javaReader = new JavaReaderEMFStat(getEFactory(),
				false);
		javaReader.setStatistics(this.getStatistics());
		return javaReader;
	}

	public void setStatProject(final IProject statProject) {
		this.statProject = statProject;
	}

	public void setStatistics(final Statistics aStatistics) {
		this.statistics = aStatistics;
	}

	public Statistics getStatistics() {
		return this.statistics;
	}

}
