/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Grgoire Dup (Mia-Software) - initial API and implementation
 * 
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Benchmark;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.Configuration;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.ReportmodelPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Benchmark</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.BenchmarkImpl#getJavaProjectName <em>Java Project Name</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.BenchmarkImpl#getXmx <em>Xmx</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.java.discoverer.benchmark.reportmodel.impl.BenchmarkImpl#getConfigurations <em>Configurations</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class BenchmarkImpl extends EObjectImpl implements Benchmark {
	/**
	 * The default value of the '{@link #getJavaProjectName() <em>Java Project Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getJavaProjectName()
	 * @generated
	 * @ordered
	 */
	protected static final String JAVA_PROJECT_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getJavaProjectName() <em>Java Project Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getJavaProjectName()
	 * @generated
	 * @ordered
	 */
	protected String javaProjectName = JAVA_PROJECT_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getXmx() <em>Xmx</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getXmx()
	 * @generated
	 * @ordered
	 */
	protected static final int XMX_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getXmx() <em>Xmx</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getXmx()
	 * @generated
	 * @ordered
	 */
	protected int xmx = XMX_EDEFAULT;

	/**
	 * The cached value of the '{@link #getConfigurations() <em>Configurations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConfigurations()
	 * @generated
	 * @ordered
	 */
	protected EList<Configuration> configurations;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BenchmarkImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ReportmodelPackage.Literals.BENCHMARK;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getJavaProjectName() {
		return javaProjectName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setJavaProjectName(String newJavaProjectName) {
		String oldJavaProjectName = javaProjectName;
		javaProjectName = newJavaProjectName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReportmodelPackage.BENCHMARK__JAVA_PROJECT_NAME, oldJavaProjectName, javaProjectName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getXmx() {
		return xmx;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setXmx(int newXmx) {
		int oldXmx = xmx;
		xmx = newXmx;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ReportmodelPackage.BENCHMARK__XMX, oldXmx, xmx));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Configuration> getConfigurations() {
		if (configurations == null) {
			configurations = new EObjectContainmentEList<Configuration>(Configuration.class, this, ReportmodelPackage.BENCHMARK__CONFIGURATIONS);
		}
		return configurations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ReportmodelPackage.BENCHMARK__CONFIGURATIONS:
				return ((InternalEList<?>)getConfigurations()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ReportmodelPackage.BENCHMARK__JAVA_PROJECT_NAME:
				return getJavaProjectName();
			case ReportmodelPackage.BENCHMARK__XMX:
				return getXmx();
			case ReportmodelPackage.BENCHMARK__CONFIGURATIONS:
				return getConfigurations();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ReportmodelPackage.BENCHMARK__JAVA_PROJECT_NAME:
				setJavaProjectName((String)newValue);
				return;
			case ReportmodelPackage.BENCHMARK__XMX:
				setXmx((Integer)newValue);
				return;
			case ReportmodelPackage.BENCHMARK__CONFIGURATIONS:
				getConfigurations().clear();
				getConfigurations().addAll((Collection<? extends Configuration>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ReportmodelPackage.BENCHMARK__JAVA_PROJECT_NAME:
				setJavaProjectName(JAVA_PROJECT_NAME_EDEFAULT);
				return;
			case ReportmodelPackage.BENCHMARK__XMX:
				setXmx(XMX_EDEFAULT);
				return;
			case ReportmodelPackage.BENCHMARK__CONFIGURATIONS:
				getConfigurations().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ReportmodelPackage.BENCHMARK__JAVA_PROJECT_NAME:
				return JAVA_PROJECT_NAME_EDEFAULT == null ? javaProjectName != null : !JAVA_PROJECT_NAME_EDEFAULT.equals(javaProjectName);
			case ReportmodelPackage.BENCHMARK__XMX:
				return xmx != XMX_EDEFAULT;
			case ReportmodelPackage.BENCHMARK__CONFIGURATIONS:
				return configurations != null && !configurations.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (javaProjectName: "); //$NON-NLS-1$
		result.append(javaProjectName);
		result.append(", xmx: "); //$NON-NLS-1$
		result.append(xmx);
		result.append(')');
		return result.toString();
	}

} //BenchmarkImpl
