/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.query.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.common.ui.internal.util.WorkbenchUtils;
import org.eclipse.gmt.modisco.infra.query.JavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.editor.presentation.QueryEditor;
import org.eclipse.gmt.modisco.infra.query.ui.Activator;
import org.eclipse.gmt.modisco.infra.query.ui.Messages;
import org.eclipse.gmt.modisco.infra.query.ui.exceptions.ClassAlreadyExistsException;
import org.eclipse.gmt.modisco.infra.query.ui.exceptions.ResourceURIExpectedException;
import org.eclipse.gmt.modisco.infra.query.ui.wizards.NewClassCreationWizard;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class CreateJavaQueryImplClassAction
implements IActionDelegate {
    private ISelection fSelection;

    public void run(IAction action) {
        ArrayList<JavaModelQuery> selectedQueries = new ArrayList<JavaModelQuery>();
        if (this.fSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.fSelection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof JavaModelQuery)) continue;
                JavaModelQuery element = (JavaModelQuery)selectedElement;
                selectedQueries.add(element);
            }
        }
        for (JavaModelQuery query : selectedQueries) {
            try {
                QueryEditor queryEditor;
                ResourceSet resourceSet;
                EditingDomain editingDomain = null;
                IWorkbenchPart activePart = WorkbenchUtils.getActivePart();
                if (activePart instanceof QueryEditor && (resourceSet = (queryEditor = (QueryEditor)activePart).getEditingDomain().getResourceSet()).getResources().contains((Object)query.eResource())) {
                    editingDomain = queryEditor.getEditingDomain();
                }
                NewClassCreationWizard wizard = new NewClassCreationWizard(query, editingDomain);
                IWorkbench workbench = Activator.getDefault().getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                Shell shell = window.getShell();
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.create();
                dialog.open();
            }
            catch (ResourceURIExpectedException e) {
                MessageDialog.openError((Shell)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.CreateJavaQueryImplClass_cannotCreate, (String)Messages.CreateJavaQueryImplClass_modelURIMustBePlatform);
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
            catch (ClassAlreadyExistsException e) {
                MessageDialog.openError((Shell)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.CreateJavaQueryImplClass_cannotCreateImplClass, (String)Messages.CreateJavaQueryImplClass_implClassAlreadyExists);
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.CreateJavaQueryImplClass_unknownError, (String)Messages.CreateJavaQueryImplClass_cannotCreateImplClass2);
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }
}

