/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.cdo.derby;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.gmt.modisco.infra.common.cdo.server.AbstractCDOServer;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.derby.EmbeddedDerbyAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyCDOServer
extends AbstractCDOServer {
    protected DataSource getDataSource(String dbName) throws Exception {
        EmbeddedDataSource dataSource = new EmbeddedDataSource();
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(dbName);
            project.create((IProgressMonitor)new NullProgressMonitor());
            if (!project.exists()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.gmt.modisco.infra.common.cdo.derby", "Failed to create the DB project"));
            }
            dataSource.setDatabaseName(String.valueOf(project.getLocation().toString()) + "/derbyDB");
        }
        catch (Exception e) {
            throw new Exception("Failed to use the workspace.", e);
        }
        dataSource.setCreateDatabase("create");
        return dataSource;
    }

    protected Map<String, String> getProps() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("overrideUUID", "gastro");
        props.put("supportingAudits", Boolean.TRUE.toString());
        props.put("currentLRUCapacity", Integer.toString(100000));
        props.put("revisedLRUCapacity", Integer.toString(10000));
        return props;
    }

    protected IMappingStrategy getMappingStrategy() {
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)true);
        return mappingStrategy;
    }

    public String getDescription() {
        return "Derby, SUPPORTING_AUDITS";
    }

    protected IDBAdapter getDBAdapter() {
        return new EmbeddedDerbyAdapter();
    }
}

