/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.editors;

import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public final class TreeToolBar {
    private final ToolBar toolBar;
    private ToolItem btnShowMenu;
    private final EcoreBrowser browser;
    private final Composite fParentComposite;
    private final Action actionShowTypeOfLinks = new Action(Messages.TreeToolBar_showTypeOfLinks, 2){
        {
            this.setToolTipText(Messages.TreeToolBar_showTypeOfLinks);
            this.setImageDescriptor(ImageProvider.getInstance().getLinkTypeIconDescriptor());
        }

        public void run() {
            TreeToolBar.this.browser.setShowTypeOfLinks(this.isChecked());
        }
    };
    private final Action actionShowEmptyLinks = new Action(Messages.TreeToolBar_showEmptyLinks, 2){
        {
            this.setToolTipText(Messages.TreeToolBar_showEmptyLinks);
            this.setImageDescriptor(ImageProvider.getInstance().getEmptyLinksImageDescriptor());
        }

        public void run() {
            TreeToolBar.this.browser.setShowEmptyLinks(this.isChecked());
        }
    };
    private final Action actionShowDerivedLinks = new Action(Messages.TreeToolBar_showDerivedLinks, 2){
        {
            this.setToolTipText(Messages.TreeToolBar_showDerivedLinks);
            this.setImageDescriptor(ImageProvider.getInstance().getShowDerivedLinksImageDescriptor());
        }

        public void run() {
            TreeToolBar.this.browser.setShowDerivedLinks(this.isChecked());
        }
    };
    private final Action actionSortInstances = new Action(Messages.TreeToolBar_sortInstances, 2){
        {
            this.setToolTipText(Messages.TreeToolBar_sortInstances);
            this.setImageDescriptor(ImageProvider.getInstance().getSortInstancesIcon());
        }

        public void run() {
            TreeToolBar.this.browser.setSortInstances(this.isChecked());
        }
    };
    private final Action actionSortLinks = new Action(Messages.TreeToolBar_sortLinks, 2){
        {
            this.setToolTipText(Messages.TreeToolBar_sortLinks);
            this.setImageDescriptor(ImageProvider.getInstance().getSortLinksImageDescriptor());
        }

        public void run() {
            TreeToolBar.this.browser.setSortLinks(this.isChecked());
        }
    };
    private final Action actionSortLinksByType = new Action(Messages.TreeToolBar_sortLinksByType, 2){
        {
            this.setToolTipText(Messages.TreeToolBar_sortLinksByType);
            this.setImageDescriptor(ImageProvider.getInstance().getSortLinksByTypeImageDescriptor());
        }

        public void run() {
            TreeToolBar.this.browser.setSortLinksByType(this.isChecked());
        }
    };
    private final Action actionShowFullQualifiedNames = new Action(Messages.TreeToolBar_showFullQualifiedNames, 2){
        {
            this.setToolTipText(Messages.TreeToolBar_showFullQualifiedNames);
            this.setImageDescriptor(ImageProvider.getInstance().getShowFullQualifiedNamesImageDescriptor());
        }

        public void run() {
            TreeToolBar.this.browser.setShowFullQualifiedNames(this.isChecked());
        }
    };
    private final Action actionShowMultiplicity = new Action(Messages.TreeToolBar_showMultiplicity, 2){
        {
            this.setToolTipText(Messages.TreeToolBar_showMultiplicity);
            this.setImageDescriptor(ImageProvider.getInstance().getShowMultiplicityImageDescriptor());
        }

        public void run() {
            TreeToolBar.this.browser.setShowMultiplicity(this.isChecked());
        }
    };
    private final Action actionShowOppositeLinks = new Action(Messages.TreeToolBar_showOppositeLinks, 2){
        {
            this.setToolTipText(Messages.TreeToolBar_showOppositeLinks);
            this.setImageDescriptor(ImageProvider.getInstance().getShowOppositeLinksImageDescriptor());
        }

        public void run() {
            TreeToolBar.this.browser.setShowOppositeLinks(this.isChecked());
        }
    };
    private final Action actionShowContainer = new Action(Messages.TreeToolBar_showContainer, 2){
        {
            this.setToolTipText(Messages.TreeToolBar_showContainer);
            this.setImageDescriptor(ImageProvider.getInstance().getContainerImageDescriptor());
        }

        public void run() {
            TreeToolBar.this.browser.setShowContainer(this.isChecked());
        }
    };
    private final Action actionShowAttributes = new Action(Messages.TreeToolBar_showAttributes, 2){
        {
            this.setToolTipText(Messages.TreeToolBar_showAttributes);
            this.setImageDescriptor(ImageProvider.getInstance().getAttributeImageDescriptor());
        }

        public void run() {
            TreeToolBar.this.browser.setShowAttributes(this.isChecked());
            TreeToolBar.this.actionShowEmptyAttributes.setEnabled(this.isChecked());
        }
    };
    private final Action actionShowEmptyAttributes = new Action(Messages.TreeToolBar_showEmptyAttributes, 2){
        {
            this.setToolTipText(Messages.TreeToolBar_showEmptyAttributes);
            this.setImageDescriptor(ImageProvider.getInstance().getEmptyAttributeImageDescriptor());
        }

        public void run() {
            TreeToolBar.this.browser.setShowEmptyAttributes(this.isChecked());
        }
    };
    private final Action actionShowOrdering = new Action(Messages.TreeToolBar_showOrdering, 2){
        {
            this.setToolTipText(Messages.TreeToolBar_showOrdering);
            this.setImageDescriptor(ImageProvider.getInstance().getOrderingImageDescriptor());
        }

        public void run() {
            TreeToolBar.this.browser.setShowOrdering(this.isChecked());
        }
    };
    private final Action actionShowElementIDs = new Action(Messages.TreeToolBar_showElementIDs, 2){
        {
            this.setToolTipText(Messages.TreeToolBar_showElementIDs);
            this.setImageDescriptor(ImageProvider.getInstance().getShowElementIDsDescriptor());
        }

        public void run() {
            TreeToolBar.this.browser.setShowElementIDs(this.isChecked());
        }
    };
    private final Action actionShowURI = new Action(Messages.TreeToolBar_showURI, 2){
        {
            this.setToolTipText(Messages.TreeToolBar_showURI);
            this.setImageDescriptor(ImageProvider.getInstance().getShowURIDescriptor());
        }

        public void run() {
            TreeToolBar.this.browser.setShowURI(this.isChecked());
        }
    };

    public static TreeToolBar create(Composite parent, EcoreBrowser browser) {
        return new TreeToolBar(parent, browser);
    }

    private TreeToolBar(Composite parent, EcoreBrowser browser) {
        this.fParentComposite = parent;
        this.browser = browser;
        RowLayout layout = new RowLayout(256);
        layout.wrap = true;
        parent.setLayout((Layout)layout);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        toolBarManager.add((IAction)this.actionSortInstances);
        toolBarManager.add((IAction)this.actionShowEmptyLinks);
        toolBarManager.add((IAction)this.actionShowDerivedLinks);
        this.toolBar = toolBarManager.createControl(parent);
        this.initialize();
        this.createShowMenuAction();
    }

    private void createShowMenuAction() {
        this.btnShowMenu = new ToolItem(this.toolBar, 8);
        this.btnShowMenu.setToolTipText(Messages.MetaclassViewToolBar_showViewMenu);
        this.btnShowMenu.setImage(ImageProvider.getInstance().getViewMenuIcon());
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type != 3 || TreeToolBar.this.toolBar.getItem(new Point(event.x, event.y)) == TreeToolBar.this.btnShowMenu) {
                    TreeToolBar.this.openViewMenu();
                }
            }
        };
        this.toolBar.addListener(3, listener);
        this.btnShowMenu.addListener(13, listener);
    }

    public Menu openViewMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)this.actionSortInstances);
        menuManager.add((IAction)this.actionShowEmptyLinks);
        menuManager.add((IAction)this.actionShowDerivedLinks);
        menuManager.add((IAction)this.actionSortLinks);
        menuManager.add((IAction)this.actionSortLinksByType);
        menuManager.add((IAction)this.actionShowFullQualifiedNames);
        menuManager.add((IAction)this.actionShowMultiplicity);
        menuManager.add((IAction)this.actionShowOrdering);
        menuManager.add((IAction)this.actionShowOppositeLinks);
        menuManager.add((IAction)this.actionShowContainer);
        menuManager.add((IAction)this.actionShowAttributes);
        menuManager.add((IAction)this.actionShowEmptyAttributes);
        menuManager.add((IAction)this.actionShowTypeOfLinks);
        menuManager.add((IAction)this.actionShowElementIDs);
        menuManager.add((IAction)this.actionShowURI);
        Menu contextMenu = menuManager.createContextMenu((Control)this.fParentComposite);
        Rectangle bounds = Display.getCurrent().map((Control)this.toolBar, null, this.btnShowMenu.getBounds());
        contextMenu.setLocation(bounds.x, bounds.y + bounds.height);
        contextMenu.setVisible(true);
        return contextMenu;
    }

    private void initialize() {
        this.actionShowEmptyLinks.setChecked(this.browser.isShowEmptyLinks());
        this.actionSortInstances.setChecked(this.browser.isSortInstances());
        this.actionSortLinks.setChecked(this.browser.isSortLinks());
        this.actionSortLinksByType.setChecked(this.browser.isSortLinksByType());
        this.actionShowDerivedLinks.setChecked(this.browser.isShowDerivedLinks());
        this.actionShowFullQualifiedNames.setChecked(this.browser.isShowFullQualifiedNames());
        this.actionShowMultiplicity.setChecked(this.browser.isShowMultiplicity());
        this.actionShowOppositeLinks.setChecked(this.browser.isShowOppositeLinks());
        this.actionShowContainer.setChecked(this.browser.isShowContainer());
        this.actionShowAttributes.setChecked(this.browser.isShowAttributes());
        this.actionShowEmptyAttributes.setChecked(this.browser.isShowEmptyAttributes());
        this.actionShowOrdering.setChecked(this.browser.isShowOrdering());
        this.actionShowTypeOfLinks.setChecked(this.browser.isShowTypeOfLinks());
        this.actionShowElementIDs.setChecked(this.browser.isShowElementIDs());
        this.actionShowURI.setChecked(this.browser.isShowURI());
        this.actionShowEmptyAttributes.setEnabled(this.browser.isShowAttributes());
    }
}

