/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.uicore;

import java.util.Collections;
import java.util.List;
import org.eclipse.gmt.modisco.infra.browser.custom.MetamodelView;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.AppearanceConfiguration;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.CustomTreePainter;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.ItemsFactory;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationManager {
    private final AppearanceConfiguration appearanceConfiguration = new AppearanceConfiguration(new ItemsFactory());

    public void installCustomPainter(Tree tree) {
        new CustomTreePainter(tree, this.appearanceConfiguration);
    }

    public void registerCustomization(MetamodelView customization) {
        this.appearanceConfiguration.getCustomizationEngine().registerCustomization(customization);
    }

    public void loadCustomizations() {
        this.appearanceConfiguration.getCustomizationEngine().loadCustomizations();
    }

    public void clearCustomizations() {
        this.appearanceConfiguration.getCustomizationEngine().clear();
    }

    public List<MetamodelView> getRegisteredCustomizations() {
        return Collections.unmodifiableList(this.appearanceConfiguration.getCustomizationEngine().getRegisteredCustomizations());
    }

    public void loadFacet(Facet facet) {
        this.appearanceConfiguration.loadFacet(facet);
    }

    public void clearFacets() {
        this.appearanceConfiguration.clearFacets();
    }

    AppearanceConfiguration getAppearanceConfiguration() {
        return this.appearanceConfiguration;
    }

    public boolean isShowEmptyLinks() {
        return this.appearanceConfiguration.isShowEmptyLinks();
    }

    public void setShowEmptyLinks(boolean showEmptyLinks) {
        this.appearanceConfiguration.setShowEmptyLinks(showEmptyLinks);
    }

    public boolean isSortInstances() {
        return this.appearanceConfiguration.isSortInstances();
    }

    public void setSortInstances(boolean sortInstances) {
        this.appearanceConfiguration.setSortInstances(sortInstances);
    }

    public boolean isShowDerivedLinks() {
        return this.appearanceConfiguration.isShowDerivedLinks();
    }

    public void setShowDerivedLinks(boolean showDerivedLinks) {
        this.appearanceConfiguration.setShowDerivedLinks(showDerivedLinks);
    }

    public boolean isShowFullQualifiedNames() {
        return this.appearanceConfiguration.isShowFullQualifiedNames();
    }

    public void setShowFullQualifiedNames(boolean showFullQualifiedNames) {
        this.appearanceConfiguration.setShowFullQualifiedNames(showFullQualifiedNames);
    }

    public boolean isShowMultiplicity() {
        return this.appearanceConfiguration.isShowMultiplicity();
    }

    public void setShowMultiplicity(boolean showMultiplicity) {
        this.appearanceConfiguration.setShowMultiplicity(showMultiplicity);
    }

    public boolean isShowOppositeLinks() {
        return this.appearanceConfiguration.isShowOppositeLinks();
    }

    public void setShowOppositeLinks(boolean showOppositeLinks) {
        this.appearanceConfiguration.setShowOppositeLinks(showOppositeLinks);
    }

    public boolean isShowContainer() {
        return this.appearanceConfiguration.isShowContainer();
    }

    public void setShowContainer(boolean showContainer) {
        this.appearanceConfiguration.setShowContainer(showContainer);
    }

    public boolean isSortLinks() {
        return this.appearanceConfiguration.isSortLinks();
    }

    public void setSortLinks(boolean value) {
        this.appearanceConfiguration.setSortLinks(value);
    }

    public void setSortLinksByType(boolean value) {
        this.appearanceConfiguration.setSortLinksByType(value);
    }

    public boolean isSortLinksByType() {
        return this.appearanceConfiguration.isSortLinksByType();
    }

    public void setShowAttributes(boolean value) {
        this.appearanceConfiguration.setShowAttributes(value);
    }

    public boolean isShowAttributes() {
        return this.appearanceConfiguration.isShowAttributes();
    }

    public void setShowEmptyAttributes(boolean value) {
        this.appearanceConfiguration.setShowEmptyAttributes(value);
    }

    public boolean isShowEmptyAttributes() {
        return this.appearanceConfiguration.isShowEmptyAttributes();
    }

    public void setShowOrdering(boolean value) {
        this.appearanceConfiguration.setShowOrdering(value);
    }

    public boolean isShowOrdering() {
        return this.appearanceConfiguration.isShowOrdering();
    }

    public void setShowTypeOfLinks(boolean value) {
        this.appearanceConfiguration.setShowTypeOfLinks(value);
    }

    public boolean isShowTypeOfLinks() {
        return this.appearanceConfiguration.isShowTypeOfLinks();
    }

    public void setShowElementIDs(boolean showElementIDs) {
        this.appearanceConfiguration.setShowElementIDs(showElementIDs);
    }

    public boolean isShowElementIDs() {
        return this.appearanceConfiguration.isShowElementIDs();
    }

    public void setShowURI(boolean showURI) {
        this.appearanceConfiguration.setShowURI(showURI);
    }

    public boolean isShowURI() {
        return this.appearanceConfiguration.isShowURI();
    }

    public void setFontSizeDelta(int value) {
        this.appearanceConfiguration.setFontSizeDelta(value);
    }

    public int getFontSizeDelta() {
        return this.appearanceConfiguration.getFontSizeDelta();
    }

    public void setCustomFont(Font customFont) {
        this.appearanceConfiguration.setCustomFont(customFont);
    }

    public Font getCustomFont() {
        return this.appearanceConfiguration.getCustomFont();
    }

    public void setCustomItalicFont(Font customItalicFont) {
        this.appearanceConfiguration.setCustomItalicFont(customItalicFont);
    }

    public Font getCustomItalicFont() {
        return this.appearanceConfiguration.getCustomItalicFont();
    }
}

