/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.core.internal.validation;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.BuildPropertiesUtils;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.PluginUtils;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.osgi.util.NLS;

public final class ValidationUtils {
    private ValidationUtils() {
    }

    public static void validateRegistered(IProject project, final String extensionToCheck, String markerType, String elementType, final String extensionPoint) {
        IMarker marker;
        String message;
        IFile buildMarkersResource;
        IFile buildProperties;
        IFile markersResource;
        final ArrayList notDeclared = new ArrayList();
        final ArrayList notInBuild = new ArrayList();
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    String fileExtension = resource.getFileExtension();
                    if (resource.getType() == 1 && fileExtension != null && fileExtension.equals(extensionToCheck)) {
                        IFile file = (IFile)resource;
                        if (!PluginUtils.isRegistered(file, extensionPoint)) {
                            notDeclared.add(file);
                        }
                        try {
                            if (!BuildPropertiesUtils.isInBuild(file)) {
                                notInBuild.add(file);
                            }
                        }
                        catch (CoreException e) {
                            MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
        }
        try {
            project.deleteMarkers(markerType, true, 1);
        }
        catch (CoreException e) {
            MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
        }
        IFile pluginXML = project.getFile("plugin.xml");
        if (pluginXML.exists()) {
            markersResource = pluginXML;
            try {
                pluginXML.deleteMarkers(markerType, true, 1);
            }
            catch (CoreException e) {
                MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
            }
        } else {
            markersResource = project;
        }
        if ((buildProperties = project.getFile("build.properties")).exists()) {
            buildMarkersResource = buildProperties;
            try {
                buildProperties.deleteMarkers(markerType, true, 1);
            }
            catch (CoreException e) {
                MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
            }
        } else {
            buildMarkersResource = project;
        }
        for (IFile file : notDeclared) {
            try {
                message = NLS.bind((String)"{0} \"{1}\" should be registered", (Object)elementType, (Object)file.getName());
                marker = markersResource.createMarker(markerType);
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("severity", 1);
            }
            catch (CoreException e) {
                MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
            }
        }
        for (IFile file : notInBuild) {
            try {
                message = NLS.bind((String)"{0} \"{1}\" should be in bin.includes (in build.properties)", (Object)elementType, (Object)file.getName());
                marker = buildMarkersResource.createMarker(markerType);
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("severity", 1);
            }
            catch (CoreException e) {
                MoDiscoLogger.logError(e, (Plugin)CommonModiscoActivator.getDefault());
            }
        }
    }
}

