/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.ui.internal.views;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmt.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.gmt.modisco.infra.common.core.internal.builder.AbstractMoDiscoCatalog;
import org.eclipse.gmt.modisco.infra.common.core.internal.builder.EcoreCatalog;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.ImageUtils;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.common.ui.internal.Messages;
import org.eclipse.gmt.modisco.infra.common.ui.internal.MoDiscoCommonUIPlugin;
import org.eclipse.gmt.modisco.infra.common.ui.internal.views.AbstractCatalogView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;

public class PackageRegistryView
extends AbstractCatalogView
implements AbstractMoDiscoCatalog.ModiscoCatalogChangeListener,
IMenuListener {
    private static final String NAME_COLUMN = "PackageRegistryView_NameColumn";
    private static final String LOCATION_COLUMN = "PackageRegistryView_LocationColumn";
    private static final String NSURI_COLUMN = "PackageRegistryView_NsURIColumn";
    private static final int COLUMN_WIDTH = 200;
    private static final String DEBUG_ID = "org.eclipse.gmt.modisco.infra.common.ui/debug/PackageRegistryView/event_debug";
    private static final boolean DEBUG = CommonModiscoActivator.getDefault().isDebugging() && new Boolean(Platform.getDebugOption((String)"org.eclipse.gmt.modisco.infra.common.ui/debug/PackageRegistryView/event_debug")) != false;
    private final Action actionCopyNsURI = new Action(Messages.PackageRegistryView_copyNsURI, 1){

        public void run() {
            EPackage selectedPackage = PackageRegistryView.this.getSelectedPackage();
            if (selectedPackage != null) {
                String nsURI = selectedPackage.getNsURI();
                Clipboard clipboard = new Clipboard(Display.getDefault());
                clipboard.setContents(new Object[]{nsURI}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
            }
        }
    };

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        EcoreCatalog.getSingleton().addChangeListener((AbstractMoDiscoCatalog.ModiscoCatalogChangeListener)this);
        this.createContextMenu();
    }

    protected void createContextMenu() {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IAction)this.actionCopyNsURI);
        contextMenu.add((IContributionItem)new GroupMarker("additions"));
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.getViewer());
    }

    public void dispose() {
        super.dispose();
        EcoreCatalog.getSingleton().removeChangeListener((AbstractMoDiscoCatalog.ModiscoCatalogChangeListener)this);
    }

    protected void createColumns() {
        this.createNameColumn();
        this.createNsUriColumn();
        this.createLocationColumn();
    }

    private void createNameColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof EPackage) {
                    EPackage ePackage = (EPackage)element;
                    return ePackage.getName();
                }
                if (element instanceof String) {
                    return (String)element;
                }
                return "";
            }

            public Image getImage(Object element) {
                return ImageUtils.getImage((Object)element);
            }
        };
        this.createColumn(Messages.PackageRegistryView_Name, NAME_COLUMN, 200, columnLabelProvider);
    }

    private void createLocationColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof EPackage)) {
                    return "";
                }
                EPackage ePackage = (EPackage)element;
                return EcoreCatalog.getSingleton().getOriginalLocation(ePackage);
            }
        };
        this.createColumn(Messages.PackageRegistryView_Location, LOCATION_COLUMN, 400, columnLabelProvider);
    }

    private void createNsUriColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof EPackage)) {
                    return "";
                }
                EPackage ePackage = (EPackage)element;
                return ePackage.getNsURI();
            }
        };
        this.createColumn(Messages.PackageRegistryView_nsURI, NSURI_COLUMN, 400, columnLabelProvider);
    }

    void preloadRegistry(EPackage.Registry registry) {
        ArrayList keys = new ArrayList();
        keys.addAll(registry.keySet());
        for (String nsURI : keys) {
            try {
                registry.getEPackage(nsURI);
            }
            catch (Exception e) {
                MoDiscoLogger.logWarning((Throwable)e, (String)("An error happened while loading an EPackage from Package.Registry.INSTANCE: " + nsURI), (Plugin)MoDiscoCommonUIPlugin.getDefault());
            }
        }
    }

    public void added(EObject eObject, IFile file) {
        if (DEBUG) {
            System.out.println(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".added(EObject,IFile)");
        }
        this.refresh(true);
    }

    public void changed(EObject eObject, IFile file) {
        if (DEBUG) {
            System.out.println(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".changed(EObject,IFile)");
        }
        this.refresh(true);
    }

    public void removed(IFile file) {
        if (DEBUG) {
            System.out.println(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".removed(EObject,IFile)");
        }
        this.refresh(true);
    }

    protected IContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof EPackage.Registry) {
                    EPackage.Registry registry = (EPackage.Registry)inputElement;
                    ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
                    ArrayList keys = new ArrayList();
                    keys.addAll(registry.keySet());
                    for (String nsURI : keys) {
                        try {
                            EPackage ePackage = registry.getEPackage(nsURI);
                            if (ePackage == null) {
                                throw new Exception("ePackage is null for : " + nsURI);
                            }
                            ePackages.add(ePackage);
                        }
                        catch (Exception e) {
                            MoDiscoLogger.logWarning((Throwable)e, (String)("An error happened while loading an EPackage from Package.Registry.INSTANCE: " + nsURI), (Plugin)MoDiscoCommonUIPlugin.getDefault());
                        }
                    }
                    return ePackages.toArray();
                }
                if (inputElement == null) {
                    return new Object[0];
                }
                if (inputElement instanceof String) {
                    String message = (String)inputElement;
                    return new Object[]{message};
                }
                throw new RuntimeException("Unexpected element type: " + inputElement.getClass().getName());
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof EPackage.Registry) {
                    EPackage.Registry registry = (EPackage.Registry)parentElement;
                    return registry.values().toArray();
                }
                if (parentElement == null || parentElement instanceof String) {
                    return new Object[0];
                }
                throw new RuntimeException("Unexpected element type: " + parentElement.getClass().getName());
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof EPackage.Registry;
            }

            public void dispose() {
            }
        };
    }

    protected void openElement(Object element) {
        if (element instanceof EPackage) {
            EPackage ePackage = (EPackage)element;
            try {
                URIEditorInput input = new URIEditorInput(URI.createURI((String)ePackage.getNsURI()));
                IDE.openEditor((IWorkbenchPage)this.getSite().getPage(), (IEditorInput)input, (String)"org.eclipse.gmt.modisco.infra.browser.editorID", (boolean)true);
            }
            catch (Exception e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)MoDiscoCommonUIPlugin.getDefault());
            }
        }
    }

    protected String getRefreshMessage() {
        return Messages.PackageRegistryView_RefreshingPackageRegistryView;
    }

    protected void doRefresh() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                PackageRegistryView.this.getViewer().setInput((Object)Messages.PackageRegistryView_initializing);
            }
        });
        final EPackage.Registry registry = EPackage.Registry.INSTANCE;
        this.preloadRegistry(registry);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (!PackageRegistryView.this.getViewer().getControl().isDisposed()) {
                    PackageRegistryView.this.getViewer().setInput((Object)registry);
                    PackageRegistryView.this.getViewer().refresh();
                }
            }
        });
    }

    protected Object getInput() {
        return EPackage.Registry.INSTANCE;
    }

    private EPackage getSelectedPackage() {
        IStructuredSelection structuredSelection;
        Object element;
        ISelection selection = this.getViewer().getSelection();
        if (selection instanceof IStructuredSelection && (element = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof EPackage) {
            EPackage ePackage = (EPackage)element;
            return ePackage;
        }
        return null;
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.actionCopyNsURI.setEnabled(this.getSelectedPackage() != null);
    }
}

