/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.driver.discoverer.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryManager;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.workflow.AbstractDriverCore;
import org.eclipse.gmt.modisco.workflow.driver.discoverer.Activator;
import org.eclipse.gmt.modisco.workflow.driver.discoverer.ui.Messages;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Direction;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameter;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameterStringValue;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameterValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchDriverModiscoDiscoverer
extends AbstractDriverCore {
    public String getTypeLaunchConfig() {
        return "org.eclipse.gmt.modisco.infra.discoverymanager.launchConfigurationType";
    }

    public List<WorkParameter> getParameters(ILaunchConfiguration configuration) {
        ArrayList<WorkParameter> parameters = new ArrayList<WorkParameter>();
        try {
            String kind = configuration.getAttribute("discoverer_kind", "");
            Discoverer discoverer = DiscoveryManager.getDefault().getDiscoverer(kind);
            if (discoverer != null) {
                for (DiscoveryParameter discoveryParameter : discoverer.getDiscovererParameters()) {
                    try {
                        WorkParameter workParameter = this.createOneWorkParameter(discoveryParameter.getName(), Direction.get((String)discoveryParameter.getParameterDirectionKind().name()), discoveryParameter.getDescription(), new Boolean(discoveryParameter.isRequired()), discoveryParameter.getType());
                        workParameter.setValue(this.bridgeParameterValue(discoveryParameter, configuration));
                        parameters.add(workParameter);
                    }
                    catch (CoreException e) {
                        MoDiscoLogger.logError((Throwable)e, (String)Messages.LaunchDriverModiscoDiscoverer_parameterBrokenValue, (Plugin)Activator.getDefault());
                    }
                }
            } else {
                MoDiscoLogger.logWarning((String)(String.valueOf(Messages.LaunchDriverModiscoDiscoverer_0) + kind), (Plugin)Activator.getDefault());
            }
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (String)Messages.LaunchDriverModiscoDiscoverer_kindOfDiscoverer, (Plugin)Activator.getDefault());
        }
        return parameters;
    }

    private final WorkParameterValue bridgeParameterValue(DiscoveryParameter parameter, ILaunchConfiguration configuration) throws CoreException {
        WorkParameterStringValue result = null;
        Class type = parameter.getType();
        if (type.equals(String.class)) {
            String value = configuration.getAttribute(parameter.getName(), "");
            result = this.createStringValue(value);
        } else if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            int value = configuration.getAttribute(parameter.getName(), 0);
            result = this.createIntegerValue(value);
        } else if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            boolean value = configuration.getAttribute(parameter.getName(), false);
            result = this.createBooleanValue(value);
        } else if (List.class.isAssignableFrom(type)) {
            List value = configuration.getAttribute(parameter.getName(), Collections.emptyList());
            result = this.createStringListValue(value);
        } else if (Set.class.isAssignableFrom(type)) {
            List list = configuration.getAttribute(parameter.getName(), Collections.emptyList());
            result = this.createStringListValue(list);
        } else if (Map.class.isAssignableFrom(type)) {
            Map value = configuration.getAttribute(parameter.getName(), Collections.emptyMap());
            result = this.createMapValue(value);
        } else {
            String value = configuration.getAttribute(parameter.getName(), "");
            result = this.createStringValue(value);
        }
        return result;
    }
}

