/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.kdm.browser.extension.platform;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.gmt.modisco.kdm.browser.extension.Activator;
import org.eclipse.gmt.modisco.omg.kdm.platform.*;
import org.eclipse.gmt.modisco.omg.kdm.platform.Process;
import org.eclipse.gmt.modisco.omg.kdm.platform.Thread;

/**
 * @generated
 */
public class IconProvider implements org.eclipse.gmt.modisco.infra.browser.uicore.extensions.icons.IconProvider {
//	Start of user code Image attribute for Process		
	private Image ProcessImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Thread		
	private Image ThreadImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for NamingResource		
	private Image NamingResourceImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for MarshalledResource		
	private Image MarshalledResourceImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for MessagingResource		
	private Image MessagingResourceImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for FileResource		
	private Image FileResourceImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for ExecutionResource		
	private Image ExecutionResourceImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for LockResource		
	private Image LockResourceImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for StreamResource		
	private Image StreamResourceImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for DataManager		
	private Image DataManagerImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for PlatformEvent		
	private Image PlatformEventImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for ExternalActor		
	private Image ExternalActorImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for RuntimeResource		
	private Image RuntimeResourceImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for PlatformModel		
	private Image PlatformModelImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for ResourceType		
	private Image ResourceTypeImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for PlatformAction		
	private Image PlatformActionImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for BindsTo		
	private Image BindsToImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Requires		
	private Image RequiresImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for ManagesResource		
	private Image ManagesResourceImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for ReadsResource		
	private Image ReadsResourceImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for WritesResource		
	private Image WritesResourceImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for DefinedBy		
	private Image DefinedByImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for DeployedComponent		
	private Image DeployedComponentImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for DeployedSoftwareSystem		
	private Image DeployedSoftwareSystemImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Machine		
	private Image MachineImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for DeployedResource		
	private Image DeployedResourceImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Loads		
	private Image LoadsImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for Spawns		
	private Image SpawnsImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for PlatformElement		
	private Image PlatformElementImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for PlatformRelationship		
	private Image PlatformRelationshipImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for AbstractPlatformElement		
	private Image AbstractPlatformElementImage = this.createImage("");
//	End of user code
//	Start of user code Image attribute for AbstractPlatformRelationship		
	private Image AbstractPlatformRelationshipImage = this.createImage("");
//	End of user code
	

	/**
	 * @generated
	 */	
	public IconProvider() {
	}

	/**
	 * @return the icon that must be displayed for the given {@link EObject}, or <code>null</code>
	 *         to keep the default icon, which can be empty, or let another {@link IconProvider}
	 *         provide the icon
	 * @generated
	 */
	public Image getIcon(EObject eObject) {
    Image result = null;
    if (eObject instanceof Process) {
      result = this.ProcessImage;
    } else
    if (eObject instanceof Thread) {
      result = this.ThreadImage;
    } else
    if (eObject instanceof NamingResource) {
      result = this.NamingResourceImage;
    } else
    if (eObject instanceof MarshalledResource) {
      result = this.MarshalledResourceImage;
    } else
    if (eObject instanceof MessagingResource) {
      result = this.MessagingResourceImage;
    } else
    if (eObject instanceof FileResource) {
      result = this.FileResourceImage;
    } else
    if (eObject instanceof ExecutionResource) {
      result = this.ExecutionResourceImage;
    } else
    if (eObject instanceof LockResource) {
      result = this.LockResourceImage;
    } else
    if (eObject instanceof StreamResource) {
      result = this.StreamResourceImage;
    } else
    if (eObject instanceof DataManager) {
      result = this.DataManagerImage;
    } else
    if (eObject instanceof PlatformEvent) {
      result = this.PlatformEventImage;
    } else
    if (eObject instanceof ExternalActor) {
      result = this.ExternalActorImage;
    } else
    if (eObject instanceof RuntimeResource) {
      result = this.RuntimeResourceImage;
    } else
    if (eObject instanceof PlatformModel) {
      result = this.PlatformModelImage;
    } else
    if (eObject instanceof ResourceType) {
      result = this.ResourceTypeImage;
    } else
    if (eObject instanceof PlatformAction) {
      result = this.PlatformActionImage;
    } else
    if (eObject instanceof BindsTo) {
      result = this.BindsToImage;
    } else
    if (eObject instanceof Requires) {
      result = this.RequiresImage;
    } else
    if (eObject instanceof ManagesResource) {
      result = this.ManagesResourceImage;
    } else
    if (eObject instanceof ReadsResource) {
      result = this.ReadsResourceImage;
    } else
    if (eObject instanceof WritesResource) {
      result = this.WritesResourceImage;
    } else
    if (eObject instanceof DefinedBy) {
      result = this.DefinedByImage;
    } else
    if (eObject instanceof DeployedComponent) {
      result = this.DeployedComponentImage;
    } else
    if (eObject instanceof DeployedSoftwareSystem) {
      result = this.DeployedSoftwareSystemImage;
    } else
    if (eObject instanceof Machine) {
      result = this.MachineImage;
    } else
    if (eObject instanceof DeployedResource) {
      result = this.DeployedResourceImage;
    } else
    if (eObject instanceof Loads) {
      result = this.LoadsImage;
    } else
    if (eObject instanceof Spawns) {
      result = this.SpawnsImage;
    } else
    if (eObject instanceof PlatformElement) {
      result = this.PlatformElementImage;
    } else
    if (eObject instanceof PlatformRelationship) {
      result = this.PlatformRelationshipImage;
    } else
    if (eObject instanceof AbstractPlatformElement) {
      result = this.AbstractPlatformElementImage;
    } else
    if (eObject instanceof AbstractPlatformRelationship) {
      result = this.AbstractPlatformRelationshipImage;
    } 

    return result;

  }

	/**
	 * Create an image from a resource in the bundle (plugin)
	 * 
	 * @param resourcePath
	 *            the path of the resource (in the bundle)
	 * @return the image
	 * @generated
	 */
	private Image createImage(String resourcePath) {
    Image result = null;
    if ((resourcePath != null) && (resourcePath.length() > 0)) {
      ImageDescriptor descriptor = Activator.getImageDescriptor("icons/kdm/platform/" + resourcePath);
      if (descriptor != null) {
        result = descriptor.createImage();
      }
    }
    return result;
  }

}

