/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.jdom;

import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class JDOMNamespacePointer
extends NodePointer {
    private String prefix;
    private String namespaceURI;

    public JDOMNamespacePointer(NodePointer parent, String prefix) {
        super(parent);
        this.prefix = prefix;
    }

    public JDOMNamespacePointer(NodePointer parent, String prefix, String namespaceURI) {
        super(parent);
        this.prefix = prefix;
        this.namespaceURI = namespaceURI;
    }

    public QName getName() {
        return new QName(this.prefix);
    }

    public Object getBaseValue() {
        return null;
    }

    public boolean isCollection() {
        return false;
    }

    public int getLength() {
        return 1;
    }

    public Object getImmediateNode() {
        return this.getNamespaceURI();
    }

    public String getNamespaceURI() {
        if (this.namespaceURI == null) {
            this.namespaceURI = this.parent.getNamespaceURI(this.prefix);
        }
        return this.namespaceURI;
    }

    public boolean isLeaf() {
        return true;
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException("Cannot modify a namespace");
    }

    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
            if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '/') {
                buffer.append('/');
            }
        }
        buffer.append("namespace::");
        buffer.append(this.prefix);
        return buffer.toString();
    }

    public int hashCode() {
        return this.prefix.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JDOMNamespacePointer)) {
            return false;
        }
        JDOMNamespacePointer other = (JDOMNamespacePointer)object;
        return this.prefix.equals(other.prefix);
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return 0;
    }
}

