/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.common.core.adapters.instances;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.resource.Resource;

public final class MetaclassInstancesAdapterFactory extends AdapterFactoryImpl {
	private static final AdapterFactory INSTANCE = new MetaclassInstancesAdapterFactory();

	private MetaclassInstancesAdapterFactory() {
		// singleton
	}

	public static AdapterFactory getInstance() {
		return MetaclassInstancesAdapterFactory.INSTANCE;
	}

	@Override
	public boolean isFactoryForType(final Object type) {
		return type == MetaclassInstances.class;
	}

	@Override
	protected Adapter createAdapter(final Notifier target) {
		if (target instanceof Resource) {
			return new MetaclassInstancesAdapter((Resource) target);
		} else {
			throw new IllegalArgumentException("This adapter only works on Resources"); //$NON-NLS-1$
		}
	}
}
