/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.core.logging;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmt.modisco.common.core.CommonModiscoActivator;

public final class MoDiscoLogger {
    private MoDiscoLogger() {
    }

    public static void logError(Throwable e, Plugin plugin) {
        MoDiscoLogger.log(e, 4, e.getMessage(), plugin);
    }

    public static void logError(String message, Plugin plugin) {
        MoDiscoLogger.log(null, 4, String.valueOf(message) + MoDiscoLogger.getPosition(), plugin);
    }

    public static void logError(Throwable e, String message, Plugin plugin) {
        MoDiscoLogger.log(e, 4, message, plugin);
    }

    public static void logWarning(Throwable e, Plugin plugin) {
        MoDiscoLogger.log(e, 2, e.getMessage(), plugin);
    }

    public static void logWarning(String message, Plugin plugin) {
        MoDiscoLogger.log(null, 2, String.valueOf(message) + MoDiscoLogger.getPosition(), plugin);
    }

    public static void logWarning(Throwable e, String message, Plugin plugin) {
        MoDiscoLogger.log(e, 2, message, plugin);
    }

    public static void logInfo(Throwable e, Plugin plugin) {
        MoDiscoLogger.log(e, 1, e.getMessage(), plugin);
    }

    public static void logInfo(String message, Plugin plugin) {
        MoDiscoLogger.log(null, 1, message, plugin);
    }

    public static void log(Throwable e, int level, String message, Plugin plugin) {
        Throwable effectiveE = e;
        Object effectivePlugin = plugin;
        String effectiveMessage = message;
        IStatus status = null;
        if (effectiveE instanceof InvocationTargetException) {
            effectiveE = ((InvocationTargetException)effectiveE).getTargetException();
        }
        if (effectivePlugin == null) {
            effectivePlugin = CommonModiscoActivator.getDefault();
        }
        if (effectiveE instanceof CoreException) {
            status = ((CoreException)effectiveE).getStatus();
        } else {
            if (effectiveMessage == null) {
                effectiveMessage = effectiveE.getMessage();
            }
            if (effectiveMessage == null) {
                effectiveMessage = effectiveE.toString();
            }
            status = effectiveE != null ? new Status(level, effectivePlugin.getBundle().getSymbolicName(), effectiveMessage, effectiveE) : new Status(level, effectivePlugin.getBundle().getSymbolicName(), effectiveMessage);
        }
        effectivePlugin.getLog().log(status);
    }

    private static String getPosition() {
        try {
            StackTraceElement element = new Exception().getStackTrace()[2];
            return " \n[" + element.getClassName() + "#" + element.getMethodName() + " : " + element.getLineNumber() + "]";
        }
        catch (Throwable e) {
            return "";
        }
    }
}

