/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.custom.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gmt.modisco.common.core.resource.MoDiscoResourceSet;
import org.eclipse.gmt.modisco.common.core.utils.FileUtils;
import org.eclipse.gmt.modisco.common.core.utils.ValidationUtils;
import org.eclipse.gmt.modisco.infra.browser.custom.MetamodelView;
import org.eclipse.gmt.modisco.infra.browser.custom.core.Activator;
import org.eclipse.gmt.modisco.infra.browser.custom.core.CustomizationsRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationsCatalog {
    public static final String FILE_EXTENSION = "uiCustom";
    private static final String PERSISTENCE_FILE_NAME = "uiCustomCatalog";
    private static CustomizationsCatalog instance = null;
    private final HashSet<IFile> workspaceCustomizations = new HashSet();
    private final List<CustomizationChangeListener> changeListeners = new ArrayList<CustomizationChangeListener>();

    public static CustomizationsCatalog getInstance() {
        if (instance == null) {
            instance = new CustomizationsCatalog();
        }
        return instance;
    }

    public CustomizationsCatalog() {
        this.load();
        this.addChangeListener(new CustomizationChangeListener(){

            public void removed(IFile customizationFile) {
            }

            public void added(MetamodelView addedCustomization, IFile file) {
                try {
                    ValidationUtils.validate((Resource)addedCustomization.eResource(), (IResource)file);
                }
                catch (CoreException e) {
                    Activator.logException(e);
                }
            }

            public void changed(MetamodelView customization, IFile file) {
                try {
                    ValidationUtils.validate((Resource)customization.eResource(), (IResource)file);
                }
                catch (CoreException e) {
                    Activator.logException(e);
                }
            }
        });
    }

    public List<MetamodelView> getWorkspaceCustomizations() {
        ArrayList<MetamodelView> metamodelViews = new ArrayList<MetamodelView>();
        for (IFile file : this.workspaceCustomizations) {
            java.net.URI locationURI = file.getLocationURI();
            MetamodelView customization = this.loadCustomization(locationURI);
            if (customization == null) continue;
            customization.setLocation(locationURI.toString());
            metamodelViews.add(customization);
        }
        return metamodelViews;
    }

    public List<MetamodelView> getRegistryCustomizations() {
        ArrayList<MetamodelView> metamodelViews = new ArrayList<MetamodelView>();
        List<URL> uiCustomURLS = CustomizationsRegistry.getInstance().getUiCustomURLS();
        for (URL url : uiCustomURLS) {
            try {
                MetamodelView customization = this.loadCustomization(url.toURI());
                if (customization == null) continue;
                metamodelViews.add(customization);
                customization.setLocation(url.toString());
            }
            catch (Exception e) {
                Activator.logException(e);
            }
        }
        return metamodelViews;
    }

    public List<MetamodelView> getRegistryDefaultCustomizations() {
        ArrayList<MetamodelView> metamodelViews = new ArrayList<MetamodelView>();
        List<URL> uiCustomURLS = CustomizationsRegistry.getInstance().getUiCustomDefaultURLS();
        for (URL url : uiCustomURLS) {
            try {
                MetamodelView customization = this.loadCustomization(url.toURI());
                if (customization == null) continue;
                metamodelViews.add(customization);
                customization.setLocation(url.toString());
            }
            catch (Exception e) {
                Activator.logException(e);
            }
        }
        return metamodelViews;
    }

    public List<MetamodelView> getAllCustomizations() {
        ArrayList<MetamodelView> metamodelViews = new ArrayList<MetamodelView>();
        metamodelViews.addAll(this.getWorkspaceCustomizations());
        metamodelViews.addAll(this.getRegistryCustomizations());
        return metamodelViews;
    }

    private MetamodelView loadCustomization(java.net.URI locationURI) {
        try {
            MoDiscoResourceSet resourceSet = MoDiscoResourceSet.getResourceSetSingleton();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(FILE_EXTENSION, new XMIResourceFactoryImpl());
            URI uri = URI.createURI((String)locationURI.toString());
            Resource resource = resourceSet.createResource(uri);
            resource.load(null);
            MetamodelView metamodelView = (MetamodelView)resource.getContents().get(0);
            return metamodelView;
        }
        catch (Exception e) {
            Activator.logException("Error loading resource " + locationURI, e);
            return null;
        }
    }

    public void addCustomization(IFile customizationFile) {
        this.workspaceCustomizations.add(customizationFile);
        this.customizationAdded(customizationFile);
        this.save();
    }

    private void save() {
        File file = this.getPersistenceFile();
        try {
            FileWriter fileWriter = new FileWriter(file);
            for (IFile customizationFile : this.workspaceCustomizations) {
                fileWriter.write(String.valueOf(customizationFile.getFullPath().toString()) + "\n");
            }
            fileWriter.close();
        }
        catch (IOException e) {
            Activator.logException(e);
        }
    }

    private void load() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        File persistenceFile = this.getPersistenceFile();
        if (persistenceFile.isFile()) {
            try {
                String[] files;
                String contents = FileUtils.getContents((File)persistenceFile);
                String[] stringArray = files = contents.split("\\n");
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    IResource resource = workspaceRoot.findMember((IPath)new Path(file));
                    if (resource instanceof IFile) {
                        IFile customizationFile = (IFile)resource;
                        this.workspaceCustomizations.add(customizationFile);
                    }
                    ++n2;
                }
            }
            catch (IOException e) {
                Activator.logException(e);
            }
        }
    }

    private File getPersistenceFile() {
        return Activator.getDefault().getStateLocation().append(PERSISTENCE_FILE_NAME).toFile();
    }

    public void removeCustomization(IFile customizationFile) {
        this.workspaceCustomizations.remove(customizationFile);
        this.customizationRemoved(customizationFile);
        this.save();
    }

    public void customizationChanged(IFile customizationFile) {
        MetamodelView customization = this.loadCustomization(customizationFile.getLocationURI());
        ArrayList<CustomizationChangeListener> tempListeners = new ArrayList<CustomizationChangeListener>(this.changeListeners);
        for (CustomizationChangeListener changeListener : tempListeners) {
            changeListener.changed(customization, customizationFile);
        }
    }

    private void customizationRemoved(IFile customizationFile) {
        if (customizationFile != null) {
            ArrayList<CustomizationChangeListener> tempListeners = new ArrayList<CustomizationChangeListener>(this.changeListeners);
            for (CustomizationChangeListener changeListener : tempListeners) {
                changeListener.removed(customizationFile);
            }
        }
    }

    private void customizationAdded(IFile customizationFile) {
        MetamodelView customization = this.loadCustomization(customizationFile.getLocationURI());
        if (customization != null) {
            ArrayList<CustomizationChangeListener> tempListeners = new ArrayList<CustomizationChangeListener>(this.changeListeners);
            for (CustomizationChangeListener changeListener : tempListeners) {
                changeListener.added(customization, customizationFile);
            }
        }
    }

    public void addChangeListener(CustomizationChangeListener listener) {
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    public void removeChangeListener(CustomizationChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public static interface CustomizationChangeListener
    extends EventListener {
        public void changed(MetamodelView var1, IFile var2);

        public void added(MetamodelView var1, IFile var2);

        public void removed(IFile var1);
    }
}

