/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.custom.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmt.modisco.infra.browser.custom.core.Activator;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomizationsRegistry {
    private static final String REGISTRATION_EXTENSION_POINT_ID = "org.eclipse.gmt.modisco.infra.browser.custom.core.registration";
    private static CustomizationsRegistry instance = null;
    private final List<URL> uiCustomURLS = new ArrayList<URL>();
    private final List<URL> uiCustomDefaultURLS = new ArrayList<URL>();

    private CustomizationsRegistry() {
        this.readExtensions();
    }

    public static CustomizationsRegistry getInstance() {
        if (instance == null) {
            instance = new CustomizationsRegistry();
        }
        return instance;
    }

    public List<URL> getUiCustomURLS() {
        return this.uiCustomURLS;
    }

    private void readExtensions() {
        try {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(REGISTRATION_EXTENSION_POINT_ID);
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                String fileAttribute = configurationElement.getAttribute("file");
                if (fileAttribute == null) {
                    Activator.logError("Missing 'file' attribute in customization registration extension");
                } else {
                    String pluginId = configurationElement.getNamespaceIdentifier();
                    Bundle bundle = Platform.getBundle((String)pluginId);
                    URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(fileAttribute), null);
                    this.uiCustomURLS.add(url);
                    String loadByDefaultAttribute = configurationElement.getAttribute("loadByDefault");
                    if (loadByDefaultAttribute != null && loadByDefaultAttribute.equalsIgnoreCase(String.valueOf(Boolean.TRUE))) {
                        this.uiCustomDefaultURLS.add(url);
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Activator.logException(e);
        }
    }

    public List<URL> getUiCustomDefaultURLS() {
        return this.uiCustomDefaultURLS;
    }
}

