/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.custom.editor.dialogs;

import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.Messages;
import org.eclipse.gmt.modisco.infra.browser.util.ImageProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorsDialog
extends Dialog {
    private static final int LIST_MIN_WIDTH = 400;
    private static final int LIST_MIN_HEIGHT = 100;
    private final Set<Resource.Diagnostic> errors;

    public ErrorsDialog(Shell parentShell, Set<Resource.Diagnostic> allErrors) {
        super(parentShell);
        this.errors = allErrors;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ErrorsDialog_errors);
        newShell.setImage(ImageProvider.getInstance().getMoDiscoIcon());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ListViewer listViewer = new ListViewer(composite, 2820);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 400;
        gridData.minimumHeight = 100;
        listViewer.getControl().setLayoutData((Object)gridData);
        listViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((Set)inputElement).toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Resource.Diagnostic diagnostic = (Resource.Diagnostic)element;
                return diagnostic.getMessage();
            }

            public Image getImage(Object element) {
                return ImageProvider.getInstance().getErrorIcon();
            }
        });
        listViewer.setInput(this.errors);
        final Text text = new Text(parent, 2826);
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.minimumWidth = 400;
        gridData2.minimumHeight = 100;
        text.setLayoutData((Object)gridData2);
        listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    text.setText("");
                    return;
                }
                Resource.Diagnostic diagnostic = (Resource.Diagnostic)selection.getFirstElement();
                String str = NLS.bind((String)Messages.ErrorsDialog_diagnosticMessage, (Object[])new Object[]{diagnostic.getMessage(), diagnostic.getLocation(), diagnostic.getLine(), diagnostic.getColumn()});
                text.setText(str);
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected boolean isResizable() {
        return true;
    }
}

