/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.custom.editor.editors;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.common.core.utils.ModelUtils;
import org.eclipse.gmt.modisco.common.ui.controls.FormStyleSashForm;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.custom.AttributeView;
import org.eclipse.gmt.modisco.infra.browser.custom.CustomView;
import org.eclipse.gmt.modisco.infra.browser.custom.CustomViewFeature;
import org.eclipse.gmt.modisco.infra.browser.custom.CustomizableFeatures;
import org.eclipse.gmt.modisco.infra.browser.custom.DerivedFeatureValue;
import org.eclipse.gmt.modisco.infra.browser.custom.FeatureValue;
import org.eclipse.gmt.modisco.infra.browser.custom.FeatureValueCase;
import org.eclipse.gmt.modisco.infra.browser.custom.MetamodelView;
import org.eclipse.gmt.modisco.infra.browser.custom.ReferenceView;
import org.eclipse.gmt.modisco.infra.browser.custom.StaticFeatureValue;
import org.eclipse.gmt.modisco.infra.browser.custom.TypeView;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.Activator;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.Messages;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.dialogs.CustomizationPropertiesDialog;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.dialogs.EditFeatureValueDialog;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.dialogs.ErrorsDialog;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.editors.CustomizationViewer;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.editors.MetaclassViewConfiguration;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.editors.MetaclassViewToolBar;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.editors.MetaclassViewer;
import org.eclipse.gmt.modisco.infra.browser.custom.emf.UicustomFactory;
import org.eclipse.gmt.modisco.infra.browser.custom.util.OverlayIconInfo;
import org.eclipse.gmt.modisco.infra.browser.custom.util.OverlayIconPosition;
import org.eclipse.gmt.modisco.infra.browser.custom.util.UicustomUtil;
import org.eclipse.gmt.modisco.infra.browser.util.EMFUtil;
import org.eclipse.gmt.modisco.infra.browser.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.core.FacetSetCatalog;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.ModelQuerySet;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.EditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationEditor
extends EditorPart {
    private static final int VERTICAL_SPACE_BETWEEN_BUTTON_GROUPS = 30;
    private static final int VERTICAL_SPACE_BEFORE_FIRST_BUTTON = 10;
    private static final int TOP_PANE_MARGIN_HEIGHT = 4;
    private static final int TOP_PANE_MARGIN_WIDTH = 5;
    public static final String ID = "org.eclipse.gmt.modisco.infra.browser.custom.editor";
    private static final int MAIN_FORM_MARGIN_WIDTH = 4;
    private static final int MAIN_FORM_MARGIN_HEIGHT = 6;
    private static final int LEFT_PANE_SASH_WEIGHT = 30;
    private static final int RIGHT_PANE_SASH_WEIGHT = 70;
    private MetamodelView fMetamodelView;
    private MetaclassViewer metaclassViewer;
    private MetaclassViewConfiguration metaclassViewConfiguration;
    private CustomizationViewer customizationViewer;
    private Button btnEditFeatureValue;
    private Button btnAdd;
    private Button btnEdit;
    private Button btnRemove;
    private Button btnUp;
    private Button btnDown;
    private Button cbAppliesToSubinstances;
    private boolean dirty;
    private Label headerLabel;
    private FormToolkit toolkit;
    private boolean readOnly;
    private final HashSet<Resource.Diagnostic> allErrors = new HashSet();
    private Button errorsButton;
    private Resource fMetamodel;
    private Form fForm;

    public CustomizationEditor() {
        FacetSetCatalog.getSingleton();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput) && !(input instanceof URIEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput or URIEditorInput");
        }
        this.readOnly = input instanceof URIEditorInput;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public void createPartControl(Composite parent) {
        java.net.URI locationURI;
        String fileName = "";
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            locationURI = fileEditorInput.getFile().getLocationURI();
            fileName = fileEditorInput.getFile().getName();
        } else if (editorInput instanceof URIEditorInput) {
            URIEditorInput uriEditorInput = (URIEditorInput)editorInput;
            try {
                locationURI = new java.net.URI(uriEditorInput.getURI().toString());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            fileName = new Path(locationURI.getPath()).lastSegment();
        } else {
            throw new IllegalStateException("wrong kind of input: " + editorInput.getClass().getName());
        }
        this.loadResource(locationURI);
        this.setPartName(fileName);
        this.metaclassViewConfiguration = new MetaclassViewConfiguration();
        this.metaclassViewConfiguration.load();
        this.getSite().getPage().addPartListener((IPartListener)new SaveSettingsOnCloseListener());
        this.createContents(parent);
        this.metaclassViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITreeSelection selection = (ITreeSelection)CustomizationEditor.this.metaclassViewer.getSelection();
                CustomizationEditor.this.metaclassSelectionChanged(selection.getFirstElement());
                CustomizationEditor.this.customizationViewer.getViewer().getControl().setRedraw(false);
                CustomizationEditor.this.customizationViewer.getViewer().expandAll();
                CustomizationEditor.this.customizationViewer.getViewer().getControl().setRedraw(true);
            }
        });
        this.customizationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CustomizationEditor.this.customizationSelectionChanged(CustomizationEditor.this.getSelectedElement());
            }
        });
        this.customizationViewer.getViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Object selectedElement = CustomizationEditor.this.getSelectedElement();
                if (selectedElement instanceof CustomViewFeature) {
                    CustomizationEditor.this.btnEditFeatureValueClicked();
                } else if (selectedElement instanceof FeatureValueCase) {
                    CustomizationEditor.this.btnEditClicked();
                }
            }
        });
        this.customizationViewer.getViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Object selectedElement;
                if (e.keyCode == 127 && (selectedElement = CustomizationEditor.this.getSelectedElement()) instanceof FeatureValueCase) {
                    CustomizationEditor.this.btnRemoveClicked();
                }
            }
        });
        this.fMetamodel = this.initMetamodel();
    }

    private Resource initMetamodel() {
        Resource resource;
        String metamodelURI = this.fMetamodelView.getMetamodelURI();
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(metamodelURI);
        if (ePackage != null && (resource = ePackage.eResource()) != null) {
            this.metaclassViewer.setInput(resource);
            return resource;
        }
        MoDiscoBrowserPlugin.logError((String)NLS.bind((String)Messages.CustomizationEditor_cannotFindMetamodel, (Object)metamodelURI));
        return null;
    }

    private void createContents(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.fForm = this.toolkit.createForm(parent);
        this.toolkit.decorateFormHeading(this.fForm);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 4;
        fillLayout.marginHeight = 6;
        this.fForm.getBody().setLayout((Layout)fillLayout);
        this.fForm.setHeadClient((Control)this.createTopPane(this.fForm.getHead()));
        this.createBottomPane(this.fForm.getBody());
        this.buttonsEnablementForSelection(null);
    }

    private Composite createTopPane(Composite parent) {
        Composite topPane = new Composite(parent, 0);
        GridData gridData = new GridData(4, 1, true, false);
        topPane.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 4;
        topPane.setLayout((Layout)gridLayout);
        this.headerLabel = new Label(topPane, 0);
        this.headerLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        this.refreshHeader();
        this.errorsButton = new Button(topPane, 8);
        this.errorsButton.setToolTipText(Messages.CustomizationEditor_btnTooltipViewErrors);
        this.errorsButton.setImage(ImageProvider.getInstance().getErrorIcon());
        this.errorsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorsDialog errorsDialog = new ErrorsDialog(CustomizationEditor.this.getSite().getShell(), CustomizationEditor.this.allErrors);
                errorsDialog.open();
            }
        });
        if (this.allErrors.isEmpty()) {
            this.errorsButton.setVisible(false);
        }
        Button propertiesButton = new Button(topPane, 8);
        propertiesButton.setText(Messages.CustomizationEditor_btnProperties);
        propertiesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationEditor.this.propertiesClicked();
            }
        });
        return topPane;
    }

    private void refreshHeader() {
        String readOnlyText = this.readOnly ? Messages.CustomizationEditor_readonly : "";
        this.headerLabel.setText(String.valueOf(readOnlyText) + NLS.bind((String)Messages.CustomizationEditor_customViewFor, (Object)this.getMetamodelName(), (Object)this.fMetamodelView.getMetamodelURI()));
    }

    protected void propertiesClicked() {
        CustomizationPropertiesDialog dialog = new CustomizationPropertiesDialog(this.getSite().getShell(), this.readOnly);
        dialog.setInitialMetamodel(this.fMetamodelView.getMetamodelURI());
        EList importedQuerySets = this.fMetamodelView.getAvailableQuerySets();
        dialog.setInitialQuerySets((List<String>)importedQuerySets);
        dialog.setInitialImportAllQuerySets(this.fMetamodelView.isAllQuerySetsAvailable());
        if (dialog.open() == 0 && !this.readOnly) {
            String[] selectedQuerySets;
            if (!dialog.getMetamodel().equals(this.fMetamodelView.getMetamodelURI())) {
                this.fMetamodelView.setMetamodelURI(dialog.getMetamodel());
                Resource newMetamodel = this.initMetamodel();
                this.promptToCleanCustomization(newMetamodel);
            }
            this.fMetamodelView.setAllQuerySetsAvailable(dialog.isAllQuerySetsAvailable());
            EList imports = this.fMetamodelView.getAvailableQuerySets();
            imports.clear();
            String[] stringArray = selectedQuerySets = dialog.getSelectedQuerySets();
            int n = selectedQuerySets.length;
            int n2 = 0;
            while (n2 < n) {
                String selectedQuerySet = stringArray[n2];
                imports.add((Object)selectedQuerySet);
                ++n2;
            }
            this.setDirty(true);
            this.refreshHeader();
            this.refresh();
        }
    }

    private void promptToCleanCustomization(Resource newMetamodel) {
        String message = String.valueOf(Messages.CustomizationEditor_youChangedMetamodel) + Messages.CustomizationEditor_promptCleanCustomizations;
        if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.CustomizationEditor_Title_cleanCustomization, (String)message)) {
            EList typeViews = this.fMetamodelView.getTypes();
            List metaclasses = EMFUtil.getMetaclasses((Resource)newMetamodel);
            ListIterator typeViewsIterator = typeViews.listIterator();
            while (typeViewsIterator.hasNext()) {
                TypeView typeView = (TypeView)typeViewsIterator.next();
                String metaclassName = typeView.getMetaclassName();
                EClass eClass = EMFUtil.findMetaclassWithName((String)metaclassName, (List)metaclasses);
                if (eClass == null) {
                    typeViewsIterator.remove();
                    continue;
                }
                EList attributeViews = typeView.getAttributes();
                ListIterator attributeViewsIterator = attributeViews.listIterator();
                while (attributeViewsIterator.hasNext()) {
                    AttributeView attributeView = (AttributeView)attributeViewsIterator.next();
                    if (EMFUtil.findElementWithName((String)attributeView.getAttributeName(), (EList)eClass.getEAllAttributes()) != null) continue;
                    attributeViewsIterator.remove();
                }
                EList referenceViews = typeView.getReferences();
                ListIterator referenceViewsIterator = referenceViews.listIterator();
                while (referenceViewsIterator.hasNext()) {
                    ReferenceView referenceView = (ReferenceView)referenceViewsIterator.next();
                    if (EMFUtil.findElementWithName((String)referenceView.getReferenceName(), (EList)eClass.getEAllReferences()) != null) continue;
                    referenceViewsIterator.remove();
                }
            }
            this.metaclassViewer.refresh();
        }
    }

    private String getMetamodelName() {
        String nsURI = this.fMetamodelView.getMetamodelURI();
        String metamodelName = EMFUtil.getMetamodelName((String)nsURI);
        if (metamodelName == null) {
            return Messages.CustomizationEditor_unknown;
        }
        return metamodelName;
    }

    private Composite createBottomPane(Composite parent) {
        FormStyleSashForm sashForm = new FormStyleSashForm(parent, 256, this.toolkit){

            protected void createContents() {
                CustomizationEditor.this.createLeftPane((Composite)this);
                CustomizationEditor.this.createRightPane((Composite)this);
            }
        };
        sashForm.setWeights(new int[]{30, 70});
        return sashForm;
    }

    private Composite createLeftPane(Composite parent) {
        Section section = this.toolkit.createSection(parent, 320);
        section.setText(Messages.CustomizationEditor_sectionName_types);
        Composite leftPaneComposite = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)leftPaneComposite);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        leftPaneComposite.setLayout((Layout)gridLayout);
        MetaclassViewToolBar toolBar = this.createToolBar((Composite)section);
        section.setTextClient((Control)toolBar.getParentComposite());
        this.metaclassViewer = new MetaclassViewer(leftPaneComposite, this.metaclassViewConfiguration, this.fMetamodelView);
        toolBar.setMetaclassViewer(this.metaclassViewer);
        GridData metaclassViewerGridData = new GridData();
        metaclassViewerGridData.grabExcessHorizontalSpace = true;
        metaclassViewerGridData.grabExcessVerticalSpace = true;
        metaclassViewerGridData.horizontalAlignment = 4;
        metaclassViewerGridData.verticalAlignment = 4;
        this.metaclassViewer.getViewer().getControl().setLayoutData((Object)metaclassViewerGridData);
        return leftPaneComposite;
    }

    private Composite createRightPane(Composite parent) {
        Section section = this.toolkit.createSection(parent, 320);
        section.setText(Messages.CustomizationEditor_sectionName_customizations);
        Composite rightPaneComposite = this.toolkit.createComposite((Composite)section, 0);
        section.setClient((Control)rightPaneComposite);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        rightPaneComposite.setLayout((Layout)gridLayout);
        Composite middle = new Composite(rightPaneComposite, 0);
        GridLayout middleLayout = new GridLayout();
        middleLayout.marginHeight = 0;
        middleLayout.marginWidth = 0;
        middle.setLayout((Layout)middleLayout);
        middle.setLayoutData((Object)new GridData(4, 4, true, true));
        this.customizationViewer = new CustomizationViewer(middle);
        this.customizationViewer.getViewer().getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        Composite optionsPane = this.toolkit.createComposite(middle);
        optionsPane.setLayout((Layout)new GridLayout());
        optionsPane.setLayoutData((Object)new GridData(4, 4, true, false));
        this.cbAppliesToSubinstances = this.toolkit.createButton(optionsPane, Messages.CustomizationEditor_appliesToSubInstances, 32);
        this.cbAppliesToSubinstances.setEnabled(false);
        this.cbAppliesToSubinstances.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationEditor.this.appliesToSubinstancesChanged(CustomizationEditor.this.cbAppliesToSubinstances.getSelection());
            }
        });
        if (this.readOnly) {
            this.cbAppliesToSubinstances.setEnabled(false);
        }
        GridData customizationViewerGridData = new GridData();
        customizationViewerGridData.grabExcessHorizontalSpace = true;
        customizationViewerGridData.grabExcessVerticalSpace = true;
        customizationViewerGridData.horizontalAlignment = 4;
        customizationViewerGridData.verticalAlignment = 4;
        this.customizationViewer.getViewer().getControl().setLayoutData((Object)customizationViewerGridData);
        if (!this.readOnly) {
            this.createButtonsPane(rightPaneComposite);
        }
        return rightPaneComposite;
    }

    private Composite createButtonsPane(Composite parent) {
        Composite buttonsPaneComposite = new Composite(parent, 0);
        GridData buttonsPaneGridData = new GridData();
        buttonsPaneGridData.grabExcessHorizontalSpace = false;
        buttonsPaneGridData.grabExcessVerticalSpace = true;
        buttonsPaneGridData.horizontalAlignment = 4;
        buttonsPaneGridData.verticalAlignment = 4;
        buttonsPaneComposite.setLayoutData((Object)buttonsPaneGridData);
        buttonsPaneComposite.setLayout((Layout)new GridLayout());
        Composite spacer1 = new Composite(buttonsPaneComposite, 0);
        GridData spacer1GridData = new GridData();
        spacer1GridData.heightHint = 10;
        spacer1.setLayoutData((Object)spacer1GridData);
        this.btnEditFeatureValue = new Button(buttonsPaneComposite, 8);
        this.btnEditFeatureValue.setText(Messages.CustomizationEditor_editFeatureValue);
        this.btnEditFeatureValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationEditor.this.btnEditFeatureValueClicked();
            }
        });
        Composite spacer2 = new Composite(buttonsPaneComposite, 0);
        GridData spacer2GridData = new GridData();
        spacer2GridData.heightHint = 30;
        spacer2.setLayoutData((Object)spacer2GridData);
        Label lblConditions = new Label(buttonsPaneComposite, 0);
        lblConditions.setText(Messages.CustomizationEditor_conditions);
        this.btnAdd = new Button(buttonsPaneComposite, 8);
        this.btnAdd.setText(Messages.CustomizationEditor_add);
        this.btnAdd.setLayoutData(this.buttonsGridData());
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationEditor.this.btnAddClicked();
            }
        });
        this.btnEdit = new Button(buttonsPaneComposite, 8);
        this.btnEdit.setText(Messages.CustomizationEditor_edit);
        this.btnEdit.setLayoutData(this.buttonsGridData());
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationEditor.this.btnEditClicked();
            }
        });
        this.btnRemove = new Button(buttonsPaneComposite, 8);
        this.btnRemove.setText(Messages.CustomizationEditor_remove);
        this.btnRemove.setLayoutData(this.buttonsGridData());
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationEditor.this.btnRemoveClicked();
            }
        });
        this.btnUp = new Button(buttonsPaneComposite, 8);
        this.btnUp.setText(Messages.CustomizationEditor_up);
        this.btnUp.setLayoutData(this.buttonsGridData());
        this.btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationEditor.this.btnUpClicked();
            }
        });
        this.btnDown = new Button(buttonsPaneComposite, 8);
        this.btnDown.setText(Messages.CustomizationEditor_down);
        this.btnDown.setLayoutData(this.buttonsGridData());
        this.btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizationEditor.this.btnDownClicked();
            }
        });
        return buttonsPaneComposite;
    }

    private Object buttonsGridData() {
        GridData buttonsGridData = new GridData();
        buttonsGridData.grabExcessHorizontalSpace = true;
        buttonsGridData.grabExcessVerticalSpace = false;
        buttonsGridData.horizontalAlignment = 4;
        buttonsGridData.verticalAlignment = 4;
        return buttonsGridData;
    }

    private MetaclassViewToolBar createToolBar(Composite parent) {
        Composite toolBarComposite = new Composite(parent, 0);
        GridData toolBarGridData = new GridData();
        toolBarGridData.grabExcessHorizontalSpace = true;
        toolBarGridData.horizontalAlignment = 4;
        toolBarComposite.setLayoutData((Object)toolBarGridData);
        return new MetaclassViewToolBar(toolBarComposite, this.metaclassViewConfiguration);
    }

    private void loadResource(java.net.URI locationURI) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.addResourceErrorsHandler((ResourceSet)resourceSet);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uiCustom", new XMIResourceFactoryImpl());
        URI uri = URI.createURI((String)locationURI.toString());
        Resource resource = resourceSet.createResource(uri);
        try {
            resource.load(null);
        }
        catch (IOException e) {
            Activator.logException("Error loading resource " + locationURI, e);
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.CustomizationEditor_error, (String)Messages.CustomizationEditor_errorLoadingResource);
            throw new IllegalStateException("Model couldn't be loaded", e);
        }
        this.fMetamodelView = (MetamodelView)resource.getContents().get(0);
    }

    private void addResourceErrorsHandler(ResourceSet resourceSet) {
        resourceSet.eAdapters().add((Object)new EContentAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void notifyChanged(Notification notification) {
                if (notification.getNotifier() instanceof Resource) {
                    switch (notification.getFeatureID(Resource.class)) {
                        case 4: 
                        case 6: 
                        case 7: {
                            Resource resource = (Resource)notification.getNotifier();
                            EList errors = resource.getErrors();
                            if (errors.isEmpty()) return;
                            CustomizationEditor.this.allErrors.addAll(errors);
                            if (CustomizationEditor.this.errorsButton == null) return;
                            CustomizationEditor.this.errorsButton.setVisible(true);
                        }
                        default: {
                            return;
                        }
                    }
                } else {
                    super.notifyChanged(notification);
                }
            }

            protected void setTarget(Resource target) {
                this.basicSetTarget((Notifier)target);
            }

            protected void unsetTarget(Resource targetResource) {
                this.basicUnsetTarget((Notifier)targetResource);
            }
        });
    }

    private void metaclassSelectionChanged(Object selectedElement) {
        this.cbAppliesToSubinstances.setEnabled(false);
        this.cbAppliesToSubinstances.setSelection(false);
        if (selectedElement == null) {
            this.customizationViewer.setInput(null);
            return;
        }
        TypeView customView = null;
        if (selectedElement instanceof EClass) {
            EClass eClass = (EClass)selectedElement;
            customView = this.findOrCreateTypeView(eClass);
            if (!this.readOnly) {
                this.cbAppliesToSubinstances.setEnabled(true);
            }
            this.cbAppliesToSubinstances.setSelection(customView.isAppliesToSubInstances());
        } else if (selectedElement instanceof MetaclassViewer.Attribute) {
            MetaclassViewer.Attribute attribute = (MetaclassViewer.Attribute)selectedElement;
            customView = this.findOrCreateAttributeView(attribute.getEClass(), attribute.getEAttribute());
        } else if (selectedElement instanceof MetaclassViewer.Reference) {
            MetaclassViewer.Reference reference = (MetaclassViewer.Reference)selectedElement;
            customView = this.findOrCreateReferenceView(reference.getEClass(), reference.getEReference());
        } else {
            throw new IllegalStateException("Unexpected element type: " + selectedElement.getClass().getSimpleName());
        }
        EList customizedFeatures = customView.getCustomizedFeatures();
        CustomizableFeatures[] customizableFeaturesArray = CustomizableFeatures.values();
        int n = customizableFeaturesArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomizableFeatures feature = customizableFeaturesArray[n2];
            if (this.appliesTo(feature, selectedElement)) {
                boolean present = false;
                for (CustomViewFeature customViewFeature : customizedFeatures) {
                    if (!customViewFeature.getCustomizedFeature().equals((Object)feature)) continue;
                    present = true;
                    break;
                }
                if (!present) {
                    CustomViewFeature newCustomViewFeature = UicustomFactory.eINSTANCE.createCustomViewFeature();
                    newCustomViewFeature.setCustomizedFeature(feature);
                    customizedFeatures.add((Object)newCustomViewFeature);
                }
            }
            ++n2;
        }
        this.customizationViewer.setInput(customView);
    }

    private boolean appliesTo(CustomizableFeatures feature, Object selectedElement) {
        if (selectedElement instanceof Facet) {
            switch (feature) {
                case ICON: 
                case FACET_MAIN_ICON: 
                case FACET_OVERLAY_ICON: 
                case METACLASS_VISIBLE: {
                    return true;
                }
            }
            return false;
        }
        switch (feature) {
            case HIDE_METACLASS_NAME: 
            case METACLASS_VISIBLE: {
                return selectedElement instanceof EClass;
            }
            case FACET_MAIN_ICON: 
            case FACET_OVERLAY_ICON: {
                return false;
            }
        }
        return true;
    }

    private TypeView findOrCreateTypeView(EClass eClass) {
        TypeView typeView2;
        String className = ModelUtils.getMetaclassQualifiedName((EClassifier)eClass);
        if (className == null) {
            return null;
        }
        EList types = this.fMetamodelView.getTypes();
        for (TypeView typeView2 : types) {
            if (!className.equals(typeView2.getMetaclassName())) continue;
            return typeView2;
        }
        typeView2 = UicustomFactory.eINSTANCE.createTypeView();
        typeView2.setMetaclassName(className);
        this.fMetamodelView.getTypes().add((Object)typeView2);
        return typeView2;
    }

    private AttributeView findOrCreateAttributeView(EClass eClass, EAttribute attribute) {
        AttributeView attributeView2;
        TypeView typeView = this.findOrCreateTypeView(eClass);
        String attributeName = attribute.getName();
        EList attributeViews = typeView.getAttributes();
        for (AttributeView attributeView2 : attributeViews) {
            if (!attributeName.equals(attributeView2.getAttributeName())) continue;
            return attributeView2;
        }
        attributeView2 = UicustomFactory.eINSTANCE.createAttributeView();
        attributeView2.setAttributeName(attributeName);
        typeView.getAttributes().add((Object)attributeView2);
        return attributeView2;
    }

    private ReferenceView findOrCreateReferenceView(EClass eClass, EReference reference) {
        ReferenceView referenceView2;
        TypeView typeView = this.findOrCreateTypeView(eClass);
        String referenceName = reference.getName();
        EList referenceViews = typeView.getReferences();
        for (ReferenceView referenceView2 : referenceViews) {
            if (!referenceName.equals(referenceView2.getReferenceName())) continue;
            return referenceView2;
        }
        referenceView2 = UicustomFactory.eINSTANCE.createReferenceView();
        referenceView2.setReferenceName(referenceName);
        typeView.getReferences().add((Object)referenceView2);
        return referenceView2;
    }

    protected void customizationSelectionChanged(Object selectedElement) {
        this.buttonsEnablementForSelection(selectedElement);
    }

    private void buttonsEnablementForSelection(Object selectedElement) {
        if (this.readOnly) {
            return;
        }
        if (selectedElement == null) {
            this.btnEditFeatureValue.setEnabled(false);
            this.btnAdd.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
            this.btnRemove.setEnabled(false);
        } else if (selectedElement instanceof CustomViewFeature) {
            this.btnEditFeatureValue.setEnabled(true);
            this.btnAdd.setEnabled(true);
            this.btnEdit.setEnabled(false);
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
            this.btnRemove.setEnabled(false);
        } else if (selectedElement instanceof FeatureValueCase) {
            FeatureValueCase featureValueCase = (FeatureValueCase)selectedElement;
            this.btnEditFeatureValue.setEnabled(false);
            this.btnAdd.setEnabled(false);
            this.btnEdit.setEnabled(true);
            this.btnUp.setEnabled(!this.isFirst(featureValueCase));
            this.btnDown.setEnabled(!this.isLast(featureValueCase));
            this.btnRemove.setEnabled(true);
        }
    }

    private boolean isFirst(FeatureValueCase featureValueCase) {
        EList valueCases = featureValueCase.getFeature().getValueCases();
        return valueCases.size() > 0 && ((FeatureValueCase)valueCases.get(0)).equals(featureValueCase);
    }

    private boolean isLast(FeatureValueCase featureValueCase) {
        EList valueCases = featureValueCase.getFeature().getValueCases();
        return valueCases.size() > 0 && ((FeatureValueCase)valueCases.get(valueCases.size() - 1)).equals(featureValueCase);
    }

    private Object getSelectedElement() {
        ITreeSelection selection = (ITreeSelection)this.customizationViewer.getSelection();
        return selection.getFirstElement();
    }

    private void btnEditFeatureValueClicked() {
        if (this.readOnly) {
            return;
        }
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof CustomViewFeature) {
            EClass customizedMetaclass;
            CustomViewFeature customViewFeature = (CustomViewFeature)selectedElement;
            CustomizableFeatures customizedFeature = customViewFeature.getCustomizedFeature();
            EditFeatureValueDialog editFeatureValueDialog = this.createDialogFor(customizedFeature, false, true, customizedMetaclass = this.findCustomizedMetaclass(customViewFeature));
            if (editFeatureValueDialog == null) {
                return;
            }
            FeatureValue defaultValue = customViewFeature.getDefaultValue();
            if (defaultValue instanceof StaticFeatureValue) {
                editFeatureValueDialog.setSelectedValueType(EditFeatureValueDialog.ValueType.STATIC);
                StaticFeatureValue staticFeatureValue = (StaticFeatureValue)defaultValue;
                editFeatureValueDialog.setInitialStaticValue(staticFeatureValue.getValue());
            } else if (defaultValue instanceof DerivedFeatureValue) {
                editFeatureValueDialog.setSelectedValueType(EditFeatureValueDialog.ValueType.DERIVED);
                DerivedFeatureValue derivedFeatureValue = (DerivedFeatureValue)defaultValue;
                ModelQuery valueCalculator = derivedFeatureValue.getValueCalculator();
                if (EMFUtil.tryResolve((EObject)valueCalculator)) {
                    editFeatureValueDialog.setSelectedQuery(valueCalculator.getModelQuerySet().getName(), valueCalculator.getName());
                }
            } else {
                editFeatureValueDialog.setSelectedValueType(EditFeatureValueDialog.ValueType.DEFAULT);
            }
            editFeatureValueDialog.open();
            if (editFeatureValueDialog.getReturnCode() == 0) {
                String selectedQueryName;
                String selectedQuerySetName;
                ModelQuery modelQuery;
                EditFeatureValueDialog.ValueType selectedValueType = editFeatureValueDialog.getSelectedValueType();
                if (selectedValueType == EditFeatureValueDialog.ValueType.STATIC) {
                    String staticValue = editFeatureValueDialog.getStaticValue();
                    if (staticValue != null) {
                        StaticFeatureValue value = UicustomFactory.eINSTANCE.createStaticFeatureValue();
                        value.setValue(staticValue);
                        customViewFeature.setDefaultValue((FeatureValue)value);
                        this.setDirty(true);
                    }
                } else if (selectedValueType == EditFeatureValueDialog.ValueType.DEFAULT) {
                    customViewFeature.setDefaultValue(null);
                    this.setDirty(true);
                } else if (selectedValueType == EditFeatureValueDialog.ValueType.DERIVED && (modelQuery = this.findModelQuery(selectedQuerySetName = editFeatureValueDialog.getSelectedQuerySetName(), selectedQueryName = editFeatureValueDialog.getSelectedQueryName())) != null) {
                    DerivedFeatureValue value = UicustomFactory.eINSTANCE.createDerivedFeatureValue();
                    value.setValueCalculator(modelQuery);
                    customViewFeature.setDefaultValue((FeatureValue)value);
                    this.setDirty(true);
                }
            }
        }
        this.refresh();
    }

    private ModelQuery findModelQuery(String querySetName, String queryName) {
        ModelQuerySet modelQuerySet = ModelQuerySetCatalog.getSingleton().getModelQuerySet(querySetName);
        if (modelQuerySet != null) {
            EList queries = modelQuerySet.getQueries();
            ModelQuery query = null;
            for (ModelQuery modelQuery : queries) {
                if (!modelQuery.getName().equals(queryName)) continue;
                query = modelQuery;
                break;
            }
            if (query != null) {
                return query;
            }
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.CustomizationEditor_nonExistingQuery, (String)NLS.bind((String)Messages.CustomizationEditor_missingQuery, (Object)queryName, (Object)querySetName));
            return null;
        }
        MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.CustomizationEditor_nonExistingQuerySet, (String)NLS.bind((String)Messages.CustomizationEditor_missingQuerySet, (Object)querySetName));
        return null;
    }

    private EditFeatureValueDialog createDialogFor(CustomizableFeatures customizedFeature, boolean withCondition, boolean withDefault, EClass customizedMetaclass) {
        switch (customizedFeature) {
            case BOLD: {
                return this.createBooleanFeatureDialog(Messages.CustomizationEditor_bold, withCondition, withDefault, customizedMetaclass);
            }
            case ITALIC: {
                return this.createBooleanFeatureDialog(Messages.CustomizationEditor_italic, withCondition, withDefault, customizedMetaclass);
            }
            case STRUCKTHROUGH: {
                return this.createBooleanFeatureDialog(Messages.CustomizationEditor_strikethrough, withCondition, withDefault, customizedMetaclass);
            }
            case UNDERLINED: {
                return this.createBooleanFeatureDialog(Messages.CustomizationEditor_underlined, withCondition, withDefault, customizedMetaclass);
            }
            case VISIBLE: {
                return this.createBooleanFeatureDialog(Messages.CustomizationEditor_visible, withCondition, withDefault, customizedMetaclass);
            }
            case METACLASS_VISIBLE: {
                return this.createBooleanFeatureDialog(Messages.CustomizationEditor_metaclassVisible, withCondition, withDefault, customizedMetaclass);
            }
            case LABEL: {
                return this.createTextFeatureDialog(Messages.CustomizationEditor_text, withCondition, withDefault, customizedMetaclass);
            }
            case COLOR: 
            case BACKGROUND_COLOR: {
                return this.createColorFeatureDialog(withCondition, withDefault, customizedMetaclass);
            }
            case ICON: 
            case FACET_MAIN_ICON: {
                return this.createIconFeatureDialog(withCondition, withDefault, customizedMetaclass);
            }
            case FACET_OVERLAY_ICON: {
                return this.createOverlayIconFeatureDialog(withCondition, withDefault, customizedMetaclass);
            }
            case FONT_NAME: {
                return this.createFontFeatureDialog(withCondition, withDefault, customizedMetaclass);
            }
            case HIDE_METACLASS_NAME: {
                return this.createBooleanFeatureDialog(Messages.CustomizationEditor_hideMetaclassName, withCondition, withDefault, customizedMetaclass);
            }
        }
        Activator.logError("Unhandled CustomizableFeature : " + customizedFeature.getName());
        return null;
    }

    private List<String> getAvailableQuerySets() {
        if (this.fMetamodelView.isAllQuerySetsAvailable()) {
            return null;
        }
        return this.fMetamodelView.getAvailableQuerySets();
    }

    private EditFeatureValueDialog createBooleanFeatureDialog(final String text, boolean withCondition, boolean withDefault, EClass customizedMetaclass) {
        return new EditFeatureValueDialog(this.getSite().getShell(), withCondition, withDefault, this.getAvailableQuerySets(), "EBoolean", customizedMetaclass){
            private Button button;

            protected void createValueEditor(Composite parent) {
                this.button = new Button(parent, 32);
                this.button.setText(text);
                this.button.setSelection(Boolean.parseBoolean(this.getInitialStaticValue()));
            }

            protected void okPressed() {
                this.setStaticValue(Boolean.toString(this.button.getSelection()));
                super.okPressed();
            }
        };
    }

    private EditFeatureValueDialog createTextFeatureDialog(final String labelText, boolean withCondition, boolean withDefault, EClass customizedMetaclass) {
        return new EditFeatureValueDialog(this.getSite().getShell(), withCondition, withDefault, this.getAvailableQuerySets(), "EString", customizedMetaclass){
            private Text text;

            protected void createValueEditor(Composite parent) {
                Composite composite = new Composite(parent, 0);
                composite.setLayout((Layout)new GridLayout(2, false));
                composite.setLayoutData((Object)new GridData(4, 4, true, true));
                Label label = new Label(composite, 0);
                label.setText(labelText);
                this.text = new Text(composite, 2048);
                this.text.setLayoutData((Object)new GridData(4, 4, true, false));
                if (this.getInitialStaticValue() != null) {
                    this.text.setText(this.getInitialStaticValue());
                }
            }

            protected void okPressed() {
                this.setStaticValue(this.text.getText());
                super.okPressed();
            }
        };
    }

    private EditFeatureValueDialog createColorFeatureDialog(boolean withCondition, boolean withDefault, EClass customizedMetaclass) {
        return new EditFeatureValueDialog(this.getSite().getShell(), withCondition, withDefault, this.getAvailableQuerySets(), "EString", customizedMetaclass){
            private ColorSelector colorSelector;

            protected void createValueEditor(Composite parent) {
                this.colorSelector = new ColorSelector(parent);
                if (this.getInitialStaticValue() != null) {
                    RGB color = UicustomUtil.decodeColor((String)this.getInitialStaticValue());
                    if (color != null) {
                        this.colorSelector.setColorValue(color);
                    } else {
                        Activator.logError("Wrong color format : " + this.getInitialStaticValue());
                    }
                } else {
                    this.colorSelector.setColorValue(new RGB(0, 0, 0));
                }
            }

            protected void okPressed() {
                RGB col = this.colorSelector.getColorValue();
                this.setStaticValue("(" + col.red + "," + col.green + "," + col.blue + ")");
                super.okPressed();
            }
        };
    }

    private EditFeatureValueDialog createIconFeatureDialog(boolean withCondition, boolean withDefault, EClass customizedMetaclass) {
        return new EditFeatureValueDialog(this.getSite().getShell(), withCondition, withDefault, this.getAvailableQuerySets(), "EString", customizedMetaclass){
            private Text text;

            protected void createValueEditor(Composite parent) {
                Composite composite = new Composite(parent, 0);
                composite.setLayout((Layout)new GridLayout(2, false));
                composite.setLayoutData((Object)new GridData(4, 4, true, true));
                this.text = new Text(composite, 2048);
                this.text.setLayoutData((Object)new GridData(4, 4, true, false));
                if (this.getInitialStaticValue() != null) {
                    this.text.setText(this.getInitialStaticValue());
                }
                Button button = new Button(composite, 8);
                button.setText(Messages.CustomizationEditor_btnOpenElementSelectionDialogText);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IFile selectedFile = CustomizationEditor.this.openIconSelectionDialog(this.getShell(), this.getText().getText());
                        if (selectedFile != null) {
                            this.getText().setText(selectedFile.getFullPath().toString());
                        }
                    }
                });
            }

            protected void okPressed() {
                this.setStaticValue(this.text.getText());
                super.okPressed();
            }

            public Text getText() {
                return this.text;
            }
        };
    }

    private EditFeatureValueDialog createOverlayIconFeatureDialog(boolean withCondition, boolean withDefault, EClass customizedMetaclass) {
        return new EditFeatureValueDialog(this.getSite().getShell(), withCondition, withDefault, this.getAvailableQuerySets(), "EString", customizedMetaclass){
            private Text text;
            private Combo combo;

            protected void createValueEditor(Composite parent) {
                Composite composite = new Composite(parent, 0);
                composite.setLayout((Layout)new GridLayout(2, false));
                composite.setLayoutData((Object)new GridData(4, 4, true, true));
                this.text = new Text(composite, 2048);
                this.text.setLayoutData((Object)new GridData(4, 4, true, false));
                Button button = new Button(composite, 8);
                button.setText(Messages.CustomizationEditor_btnOpenElementSelectionDialogText);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IFile selectedFile = CustomizationEditor.this.openIconSelectionDialog(this.getShell(), this.getText().getText());
                        if (selectedFile != null) {
                            this.getText().setText(selectedFile.getFullPath().toString());
                        }
                    }
                });
                this.combo = new Combo(composite, 12);
                OverlayIconPosition[] overlayIconPositionArray = OverlayIconPosition.values();
                int n = overlayIconPositionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    OverlayIconPosition overlayIconPosition = overlayIconPositionArray[n2];
                    this.combo.add(overlayIconPosition.name());
                    ++n2;
                }
                if (this.getInitialStaticValue() != null) {
                    try {
                        OverlayIconInfo overlayIcon = UicustomUtil.decodeOverlayIcon((String)this.getInitialStaticValue());
                        this.text.setText(overlayIcon.getPath());
                        this.combo.setText(overlayIcon.getIconPosition().name());
                    }
                    catch (Exception e) {
                        MoDiscoLogger.logError((Throwable)e, (String)"Error decoding overlay icon", (Plugin)Activator.getDefault());
                    }
                }
                if (this.combo.getSelectionIndex() == -1) {
                    this.combo.select(0);
                }
            }

            protected void okPressed() {
                OverlayIconPosition iconPosition = OverlayIconPosition.valueOf((String)this.combo.getText());
                this.setStaticValue(UicustomUtil.encodeOverlayIcon((String)this.text.getText(), (OverlayIconPosition)iconPosition));
                super.okPressed();
            }

            public Text getText() {
                return this.text;
            }
        };
    }

    private IFile openIconSelectionDialog(Shell shell, String initialText) {
        int result;
        ElementTreeSelectionDialog iconSelectionDialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        iconSelectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        iconSelectionDialog.setAllowMultiple(false);
        iconSelectionDialog.setMessage(Messages.CustomizationEditor_selectAnIcon);
        iconSelectionDialog.setTitle(Messages.CustomizationEditor_iconSelection);
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(initialText);
        if (resource != null) {
            iconSelectionDialog.setInitialSelection((Object)resource);
        }
        if ((result = iconSelectionDialog.open()) == 0) {
            Object firstResult = iconSelectionDialog.getFirstResult();
            if (firstResult instanceof IFile) {
                IFile file = (IFile)firstResult;
                return file;
            }
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)Messages.CustomizationEditor_invalidSelection, (String)Messages.CustomizationEditor_notFileSelected);
        }
        return null;
    }

    private EditFeatureValueDialog createFontFeatureDialog(boolean withCondition, boolean withDefault, EClass customizedMetaclass) {
        return new EditFeatureValueDialog(this.getSite().getShell(), withCondition, withDefault, this.getAvailableQuerySets(), "EString", customizedMetaclass){
            private Text text;

            protected void createValueEditor(Composite parent) {
                Composite composite = new Composite(parent, 0);
                composite.setLayout((Layout)new GridLayout(2, false));
                composite.setLayoutData((Object)new GridData(4, 4, true, true));
                this.text = new Text(composite, 2048);
                this.text.setLayoutData((Object)new GridData(4, 4, true, false));
                if (this.getInitialStaticValue() != null) {
                    this.text.setText(this.getInitialStaticValue());
                }
                Button button = new Button(composite, 8);
                button.setText(Messages.CustomizationEditor_btnOpenFontDialogText);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FontDialog fontDialog = new FontDialog(CustomizationEditor.this.getSite().getShell());
                        int fontHeight = 10;
                        fontDialog.setFontList(new FontData[]{new FontData(this.getText().getText(), 10, 0)});
                        FontData font = fontDialog.open();
                        if (font != null) {
                            this.getText().setText(font.getName());
                        }
                    }
                });
            }

            protected void okPressed() {
                this.setStaticValue(this.text.getText());
                super.okPressed();
            }

            public Text getText() {
                return this.text;
            }
        };
    }

    private void btnAddClicked() {
        if (this.readOnly) {
            return;
        }
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof CustomViewFeature) {
            CustomViewFeature customViewFeature = (CustomViewFeature)selectedElement;
            CustomizableFeatures customizedFeature = customViewFeature.getCustomizedFeature();
            EClass customizedMetaclass = this.findCustomizedMetaclass(customViewFeature);
            EditFeatureValueDialog editFeatureValueDialog = this.createDialogFor(customizedFeature, true, false, customizedMetaclass);
            FeatureValueCase newValueCase = null;
            if (editFeatureValueDialog != null) {
                editFeatureValueDialog.open();
                if (editFeatureValueDialog.getReturnCode() == 0) {
                    EditFeatureValueDialog.ValueType selectedValueType = editFeatureValueDialog.getSelectedValueType();
                    if (selectedValueType == EditFeatureValueDialog.ValueType.STATIC) {
                        ModelQuery conditionQuery;
                        String staticValue = editFeatureValueDialog.getStaticValue();
                        if (staticValue != null && (conditionQuery = this.findModelQuery(editFeatureValueDialog.getSelectedConditionQuerySetName(), editFeatureValueDialog.getSelectedConditionQueryName())) != null) {
                            StaticFeatureValue value = UicustomFactory.eINSTANCE.createStaticFeatureValue();
                            value.setValue(staticValue);
                            newValueCase = UicustomFactory.eINSTANCE.createFeatureValueCase();
                            newValueCase.setValue((FeatureValue)value);
                            newValueCase.setCondition(conditionQuery);
                            customViewFeature.getValueCases().add((Object)newValueCase);
                            this.setDirty(true);
                        }
                    } else if (selectedValueType == EditFeatureValueDialog.ValueType.DERIVED) {
                        ModelQuery conditionQuery = this.findModelQuery(editFeatureValueDialog.getSelectedConditionQuerySetName(), editFeatureValueDialog.getSelectedConditionQueryName());
                        ModelQuery query = this.findModelQuery(editFeatureValueDialog.getSelectedQuerySetName(), editFeatureValueDialog.getSelectedQueryName());
                        if (conditionQuery != null && query != null) {
                            DerivedFeatureValue value = UicustomFactory.eINSTANCE.createDerivedFeatureValue();
                            value.setValueCalculator(query);
                            newValueCase = UicustomFactory.eINSTANCE.createFeatureValueCase();
                            newValueCase.setValue((FeatureValue)value);
                            newValueCase.setCondition(conditionQuery);
                            customViewFeature.getValueCases().add((Object)newValueCase);
                            this.setDirty(true);
                        }
                    }
                }
            }
            this.refresh();
            if (newValueCase != null) {
                this.customizationViewer.getViewer().setSelection((ISelection)new StructuredSelection(newValueCase), true);
            }
        }
    }

    private EClass findCustomizedMetaclass(CustomViewFeature customViewFeature) {
        CustomView customView = customViewFeature.getCustomView();
        List metaclasses = EMFUtil.getMetaclasses((Resource)this.fMetamodel);
        if (customView instanceof TypeView) {
            TypeView typeView = (TypeView)customView;
            return EMFUtil.findMetaclassWithName((String)typeView.getMetaclassName(), (List)metaclasses);
        }
        if (customView instanceof AttributeView) {
            AttributeView attributeView = (AttributeView)customView;
            return EMFUtil.findMetaclassWithName((String)attributeView.getType().getMetaclassName(), (List)metaclasses);
        }
        if (customView instanceof ReferenceView) {
            ReferenceView referenceView = (ReferenceView)customView;
            return EMFUtil.findMetaclassWithName((String)referenceView.getType().getMetaclassName(), (List)metaclasses);
        }
        throw new IllegalStateException("Unknown CustomView type: " + customView.getClass().getSimpleName());
    }

    private void btnEditClicked() {
        if (this.readOnly) {
            return;
        }
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof FeatureValueCase) {
            FeatureValueCase featureValueCase = (FeatureValueCase)selectedElement;
            CustomViewFeature customViewFeature = featureValueCase.getFeature();
            CustomizableFeatures customizedFeature = customViewFeature.getCustomizedFeature();
            EClass customizedMetaclass = this.findCustomizedMetaclass(customViewFeature);
            EditFeatureValueDialog editFeatureValueDialog = this.createDialogFor(customizedFeature, true, false, customizedMetaclass);
            FeatureValue featureValue = featureValueCase.getValue();
            if (featureValue instanceof StaticFeatureValue) {
                StaticFeatureValue staticFeatureValue = (StaticFeatureValue)featureValue;
                editFeatureValueDialog.setSelectedValueType(EditFeatureValueDialog.ValueType.STATIC);
                editFeatureValueDialog.setInitialStaticValue(staticFeatureValue.getValue());
            } else if (featureValue instanceof DerivedFeatureValue) {
                DerivedFeatureValue derivedFeatureValue = (DerivedFeatureValue)featureValue;
                editFeatureValueDialog.setSelectedValueType(EditFeatureValueDialog.ValueType.DERIVED);
                ModelQuery valueCalculator = derivedFeatureValue.getValueCalculator();
                if (EMFUtil.tryResolve((EObject)valueCalculator)) {
                    editFeatureValueDialog.setSelectedQuery(valueCalculator.getModelQuerySet().getName(), valueCalculator.getName());
                }
            }
            ModelQuery condition = featureValueCase.getCondition();
            if (condition != null && EMFUtil.tryResolve((EObject)condition)) {
                editFeatureValueDialog.setSelectedConditionQuery(condition.getModelQuerySet().getName(), condition.getName());
            }
            if (editFeatureValueDialog != null) {
                editFeatureValueDialog.open();
                if (editFeatureValueDialog.getReturnCode() == 0) {
                    EditFeatureValueDialog.ValueType selectedValueType = editFeatureValueDialog.getSelectedValueType();
                    if (selectedValueType == EditFeatureValueDialog.ValueType.STATIC) {
                        String staticValue = editFeatureValueDialog.getStaticValue();
                        if (staticValue != null) {
                            StaticFeatureValue value = UicustomFactory.eINSTANCE.createStaticFeatureValue();
                            value.setValue(staticValue);
                            featureValueCase.setValue((FeatureValue)value);
                            this.setDirty(true);
                        }
                    } else if (selectedValueType == EditFeatureValueDialog.ValueType.DERIVED) {
                        DerivedFeatureValue value = UicustomFactory.eINSTANCE.createDerivedFeatureValue();
                        ModelQuery query = this.findModelQuery(editFeatureValueDialog.getSelectedQuerySetName(), editFeatureValueDialog.getSelectedQueryName());
                        ModelQuery conditionQuery = this.findModelQuery(editFeatureValueDialog.getSelectedConditionQuerySetName(), editFeatureValueDialog.getSelectedConditionQueryName());
                        if (query != null && conditionQuery != null) {
                            value.setValueCalculator(query);
                            featureValueCase.setCondition(conditionQuery);
                            featureValueCase.setValue((FeatureValue)value);
                            this.setDirty(true);
                        }
                    }
                }
            }
        }
        this.refresh();
    }

    private void btnRemoveClicked() {
        if (this.readOnly) {
            return;
        }
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof FeatureValueCase) {
            FeatureValueCase featureValueCase = (FeatureValueCase)selectedElement;
            EList list = featureValueCase.getFeature().getValueCases();
            list.remove((Object)featureValueCase);
            this.setDirty(true);
            this.refresh();
        }
    }

    private void btnUpClicked() {
        if (this.readOnly) {
            return;
        }
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof FeatureValueCase) {
            FeatureValueCase featureValueCase = (FeatureValueCase)selectedElement;
            EList list = featureValueCase.getFeature().getValueCases();
            int index = list.indexOf((Object)featureValueCase);
            if (index - 1 >= 0) {
                list.move(index - 1, index);
                this.setDirty(true);
            }
            this.refresh();
        }
    }

    private void btnDownClicked() {
        if (this.readOnly) {
            return;
        }
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof FeatureValueCase) {
            FeatureValueCase featureValueCase = (FeatureValueCase)selectedElement;
            EList list = featureValueCase.getFeature().getValueCases();
            int index = list.indexOf((Object)featureValueCase);
            if (index + 1 < list.size()) {
                list.move(index + 1, index);
                this.setDirty(true);
            }
            this.refresh();
        }
    }

    private void appliesToSubinstancesChanged(boolean newValue) {
        IStructuredSelection selection = (IStructuredSelection)this.metaclassViewer.getSelection();
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof EClass) {
            EClass eClass = (EClass)selectedElement;
            TypeView typeView = this.findOrCreateTypeView(eClass);
            typeView.setAppliesToSubInstances(newValue);
            this.setDirty(true);
            this.refresh();
        }
    }

    private void refresh() {
        this.customizationViewer.refresh();
        this.metaclassViewer.refresh();
        this.buttonsEnablementForSelection(this.getSelectedElement());
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.readOnly) {
            return;
        }
        IFileEditorInput fileEditorInput = (IFileEditorInput)this.getEditorInput();
        String locationURI = fileEditorInput.getFile().getLocationURI().toString();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uiCustom", new XMIResourceFactoryImpl());
        Resource resource = resourceSet.createResource(URI.createURI((String)locationURI));
        MetamodelView metamodelViewCopy = (MetamodelView)EcoreUtil.copy((EObject)this.fMetamodelView);
        resource.getContents().add((Object)this.cleanModel(metamodelViewCopy));
        try {
            resource.save(null);
            this.setDirty(false);
            fileEditorInput.getFile().refreshLocal(0, monitor);
        }
        catch (Exception e) {
            Activator.logException(e);
        }
    }

    private MetamodelView cleanModel(MetamodelView metamodelView) {
        ListIterator typesIterator = metamodelView.getTypes().listIterator();
        while (typesIterator.hasNext()) {
            TypeView typeView = (TypeView)typesIterator.next();
            boolean containsInformation = true;
            if (!this.clean((CustomView)typeView)) {
                containsInformation = false;
            }
            ListIterator attributesIterator = typeView.getAttributes().listIterator();
            while (attributesIterator.hasNext()) {
                AttributeView attributeView = (AttributeView)attributesIterator.next();
                if (this.clean((CustomView)attributeView)) {
                    containsInformation = true;
                    continue;
                }
                attributesIterator.remove();
            }
            ListIterator referencesIterator = typeView.getReferences().listIterator();
            while (referencesIterator.hasNext()) {
                ReferenceView referenceView = (ReferenceView)referencesIterator.next();
                if (this.clean((CustomView)referenceView)) {
                    containsInformation = true;
                    continue;
                }
                referencesIterator.remove();
            }
            if (containsInformation) continue;
            typesIterator.remove();
        }
        return metamodelView;
    }

    private boolean clean(CustomView customView) {
        EList customizedFeatures = customView.getCustomizedFeatures();
        ListIterator featuresIterator = customizedFeatures.listIterator();
        while (featuresIterator.hasNext()) {
            CustomViewFeature customViewFeature = (CustomViewFeature)featuresIterator.next();
            if (customViewFeature.getDefaultValue() != null || customViewFeature.getValueCases().size() != 0) continue;
            featuresIterator.remove();
        }
        return customizedFeatures.size() > 0;
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.dirty && !this.readOnly;
    }

    private void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.firePropertyChange(257);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        this.toolkit.dispose();
    }

    private class SaveSettingsOnCloseListener
    implements IPartListener {
        private SaveSettingsOnCloseListener() {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == CustomizationEditor.this) {
                CustomizationEditor.this.metaclassViewConfiguration.save();
                CustomizationEditor.this.getSite().getPage().removePartListener((IPartListener)this);
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
        }
    }
}

