/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Grgoire Dup (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.browser.custom.examples.uml;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.runtime.ModelQueryParameterValue;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

/**
 * @author Gregoire Dupe (Mia-Software)
 */
public class AllClassifiers_Package implements IJavaModelQuery {

	public Object evaluate(EObject context,
			List<ModelQueryParameterValue> parameterValues)
			throws ModelQueryExecutionException {
		if (context instanceof org.eclipse.uml2.uml.Model) {
			return evaluate((org.eclipse.uml2.uml.Model) context);
		}
		throw new ModelQueryExecutionException(
				"An instance of Classifier is expected as contxt parameter."); //$NON-NLS-1$
	}

	public List<Classifier> evaluate(org.eclipse.uml2.uml.Package context) {
		List<Classifier> allClassifiers = new ArrayList<Classifier>();
		for (Element ownedElement : context.getOwnedElements()){
			if (ownedElement instanceof Classifier) {
				Classifier ownedClassifier = (Classifier) ownedElement;
				allClassifiers.add(ownedClassifier);
			}
		}
		
//		for (Type classifier : context.getOwnedTypes()){
//			allClassifiers.addAll(new AllClassifiers_Classifier().evaluate(classifier));
//		}
		for (Package package1 : context.getNestedPackages()){
			allClassifiers.addAll(new AllClassifiers_Package().evaluate(package1));
		}

		return allClassifiers;
	}

}
