/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Grgoire Dup (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.browser.custom.examples.uml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.runtime.ModelQueryParameterValue;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;

/**
 * @author Gregoire Dupe (Mia-Software)
 */
public class AttributesNotAssociationEnds implements IJavaModelQuery {

	public Object evaluate(EObject context,
			List<ModelQueryParameterValue> parameterValues)
			throws ModelQueryExecutionException {
		if (context instanceof Classifier) {
			return evaluate((Classifier)context);
		}
		throw new ModelQueryExecutionException(
				"An instance of Classifier is expected as contxt parameter."); //$NON-NLS-1$
	}

	public Collection<? extends Property> evaluate(Classifier context) {
		List<Property> result = new ArrayList<Property>();
		for (Property property : context.getAttributes()) {
			if (new IsAssociationEnd().evaluate(property)) {
				result.add(property);
			}
		}
		return result;
	}

}
