/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Grgoire Dup (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.browser.custom.examples.uml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.runtime.ModelQueryParameterValue;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;

/**
 * @author Gregoire Dupe (Mia-Software)
 */
public class AllAttributesNotAssociationEnd implements IJavaModelQuery {

	public Object evaluate(EObject context,
			List<ModelQueryParameterValue> parameterValues)
			throws ModelQueryExecutionException {
		return evaluate((Classifier) context);
	}

	/**
	 * Returns all the attributes: firstly the attributes owned by the parent
	 * class Renvoie tous les attributs : d'abord les attributs des classes
	 * meres (allParents), puis ceux de la classe
	 */
	public List<Property> evaluate(Classifier context)
			throws ModelQueryExecutionException {
		List<Classifier> allParents = new AllParents().evaluate(context);
		List<Property> allAttributes = new ArrayList<Property>();
		for (Iterator<Classifier> i = allParents.iterator(); i.hasNext();) {
			org.eclipse.uml2.uml.Classifier parent = i.next();
			allAttributes.addAll(new AttributesNotAssociationEnds()
					.evaluate(parent));
		}
		allAttributes.addAll(new AttributesNotAssociationEnds()
				.evaluate(context));
		return allAttributes;
	}

}
