/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *    
 *******************************************************************************/

package org.eclipse.gmt.modisco.infra.browser.custom.ui.controls;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmt.modisco.infra.browser.custom.ui.Messages;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

/**
 * A control for selecting a metamodel from a list of metamodels, that can be
 * filtered using the associated text field.
 */
public class MetamodelSelectionControl extends Composite {

	private final Text filterText;
	private final FilteredList fFilteredList;

	public MetamodelSelectionControl(final Composite parent) {
		super(parent, SWT.NONE);
		setLayout(new GridLayout());

		this.filterText = createFilterText(this);
		this.fFilteredList = createFilteredList(this);

		final Set<String> uris = new TreeSet<String>();
		for (final Object name : ((Map<?, ?>) EPackage.Registry.INSTANCE).keySet()) {
			uris.add((name).toString());
		}

		this.fFilteredList.setElements(uris.toArray());

		this.filterText.addModifyListener(new ModifyListener() {
			public void modifyText(final ModifyEvent e) {
				MetamodelSelectionControl.this.fFilteredList.setFilter("*" //$NON-NLS-1$
						+ MetamodelSelectionControl.this.filterText.getText());
			}
		});

		this.filterText.addKeyListener(new KeyListener() {
			public void keyPressed(final KeyEvent e) {
				if (e.keyCode == SWT.ARROW_DOWN) {
					MetamodelSelectionControl.this.fFilteredList.setFocus();
				}
			}

			public void keyReleased(final KeyEvent e) {
			}
		});
	}

	protected FilteredList createFilteredList(final Composite parent) {
		final FilteredList filteredList = new FilteredList(parent, SWT.BORDER | SWT.V_SCROLL
				| SWT.H_SCROLL | SWT.SINGLE, new LabelProvider(), true, false, true);

		final GridData data = new GridData();
		data.grabExcessVerticalSpace = true;
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		data.verticalAlignment = GridData.FILL;
		filteredList.setLayoutData(data);
		filteredList.setFilter(""); //$NON-NLS-1$

		return filteredList;
	}

	protected Text createFilterText(final Composite parent) {
		final Text text = new Text(parent, SWT.BORDER);
		text.setMessage(Messages.MetamodelSelectionControl_typeFilterText);

		final GridData data = new GridData();
		data.grabExcessVerticalSpace = false;
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		data.verticalAlignment = GridData.BEGINNING;
		text.setLayoutData(data);

		return text;
	}

	public String getSelectedMetamodel() {
		final Object[] selection = this.fFilteredList.getSelection();
		if (selection.length > 0) {
			return (String) selection[0];
		}
		return null;
	}

	public FilteredList getFilteredList() {
		return this.fFilteredList;
	}

	public Text getFilterText() {
		return this.filterText;
	}
}
